/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

public class PaymentMerchantServicesRequest {
    private final boolean fraudScoring;
    private final boolean fraudManualReview;

    PaymentMerchantServicesRequest(boolean fraudScoring, boolean fraudManualReview) {
        this.fraudScoring = fraudScoring;
        this.fraudManualReview = fraudManualReview;
    }

    public static PaymentMerchantServicesRequestBuilder builder() {
        return new PaymentMerchantServicesRequestBuilder();
    }

    public boolean isFraudScoring() {
        return this.fraudScoring;
    }

    public boolean isFraudManualReview() {
        return this.fraudManualReview;
    }

    public static class PaymentMerchantServicesRequestBuilder {
        private boolean fraudScoring;
        private boolean fraudManualReview;

        PaymentMerchantServicesRequestBuilder() {
        }

        public PaymentMerchantServicesRequestBuilder fraudScoring(boolean fraudScoring) {
            this.fraudScoring = fraudScoring;
            return this;
        }

        public PaymentMerchantServicesRequestBuilder fraudManualReview(boolean fraudManualReview) {
            this.fraudManualReview = fraudManualReview;
            return this;
        }

        public PaymentMerchantServicesRequest build() {
            return new PaymentMerchantServicesRequest(this.fraudScoring, this.fraudManualReview);
        }

        public String toString() {
            return "PaymentMerchantServicesRequest.PaymentMerchantServicesRequestBuilder(fraudScoring=" + this.fraudScoring + ", fraudManualReview=" + this.fraudManualReview + ")";
        }
    }
}

