/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.customer;

public class CustomerAddressRequest {
    private final String id;
    private final String zipCode;
    private final String streetName;
    private final Integer streetNumber;

    CustomerAddressRequest(String id, String zipCode, String streetName, Integer streetNumber) {
        this.id = id;
        this.zipCode = zipCode;
        this.streetName = streetName;
        this.streetNumber = streetNumber;
    }

    public static CustomerAddressRequestBuilder builder() {
        return new CustomerAddressRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public Integer getStreetNumber() {
        return this.streetNumber;
    }

    public static class CustomerAddressRequestBuilder {
        private String id;
        private String zipCode;
        private String streetName;
        private Integer streetNumber;

        CustomerAddressRequestBuilder() {
        }

        public CustomerAddressRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CustomerAddressRequestBuilder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public CustomerAddressRequestBuilder streetName(String streetName) {
            this.streetName = streetName;
            return this;
        }

        public CustomerAddressRequestBuilder streetNumber(Integer streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public CustomerAddressRequest build() {
            return new CustomerAddressRequest(this.id, this.zipCode, this.streetName, this.streetNumber);
        }

        public String toString() {
            return "CustomerAddressRequest.CustomerAddressRequestBuilder(id=" + this.id + ", zipCode=" + this.zipCode + ", streetName=" + this.streetName + ", streetNumber=" + this.streetNumber + ")";
        }
    }
}

