/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.mercadopago.android.px.internal.core.ConnectivityStateInterceptor;
import com.mercadopago.android.px.internal.core.TLSSocketFactory;
import com.mercadopago.android.px.internal.core.UserAgentInterceptor;
import java.io.File;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public final class HttpClientUtil {
    private static OkHttpClient client;
    private static OkHttpClient customClient;
    private static final int CACHE_SIZE = 0xA00000;
    private static final String CACHE_DIR_NAME = "PX_OKHTTP_CACHE_SERVICES";
    private static final HttpLoggingInterceptor.Level LOGGING_INTERCEPTOR;

    private HttpClientUtil() {
    }

    public static synchronized OkHttpClient getClient(@NonNull Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        if (HttpClientUtil.customClientSet()) {
            return customClient;
        }
        if (client == null) {
            client = HttpClientUtil.createClient(context, connectTimeout, readTimeout, writeTimeout);
        }
        return client;
    }

    @NonNull
    public static OkHttpClient createClient(int connectTimeout, int readTimeout, int writeTimeout) {
        return HttpClientUtil.createClient(null, connectTimeout, readTimeout, writeTimeout);
    }

    @NonNull
    public static OkHttpClient createClient(@Nullable Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS);
        okHttpClientBuilder.addInterceptor((Interceptor)new UserAgentInterceptor("PX/Android/4.9.1"));
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(LOGGING_INTERCEPTOR);
        okHttpClientBuilder.addInterceptor((Interceptor)interceptor);
        if (context != null) {
            okHttpClientBuilder.addInterceptor(HttpClientUtil.getConnectionInterceptor(context));
            try {
                Cache cache = new Cache(new File(String.format("%s%s", context.getCacheDir().getPath(), CACHE_DIR_NAME)), 0xA00000L);
                okHttpClientBuilder.cache(cache);
            }
            catch (Exception cache) {
                // empty catch block
            }
        }
        OkHttpClient client = okHttpClientBuilder.build();
        if (Build.VERSION.SDK_INT <= 21) {
            try {
                client = TLSSocketFactory.enforceTls(client);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return client;
    }

    @NonNull
    private static Interceptor getConnectionInterceptor(@NonNull Context context) {
        return new ConnectivityStateInterceptor(context);
    }

    @VisibleForTesting
    public static void setCustomClient(OkHttpClient client) {
        customClient = TLSSocketFactory.enforceTls(client);
    }

    @VisibleForTesting
    public static void removeCustomClient() {
        customClient = null;
    }

    private static boolean customClientSet() {
        return customClient != null;
    }

    static {
        LOGGING_INTERCEPTOR = HttpLoggingInterceptor.Level.NONE;
    }
}

