/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.preferences;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.android.px.model.Card;
import com.mercadopago.android.px.model.PayerCost;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.PaymentType;
import com.mercadopago.android.px.model.PaymentTypes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PaymentPreference
implements Serializable {
    @SerializedName(value="installments")
    private Integer maxInstallments;
    private Integer defaultInstallments;
    private List<PaymentMethod> excludedPaymentMethods;
    private List<PaymentType> excludedPaymentTypes;
    @SerializedName(value="default_payment_method_id")
    private String defaultPaymentMethodId;
    @SerializedName(value="default_card_id")
    private String defaultCardId;
    private String defaultPaymentTypeId;

    public void setMaxAcceptedInstallments(Integer installments) {
        this.maxInstallments = installments;
    }

    public void setDefaultInstallments(Integer defaultInstallments) {
        this.defaultInstallments = defaultInstallments;
    }

    public void setExcludedPaymentTypeIds(List<String> excludedPaymentTypeIds) {
        if (excludedPaymentTypeIds != null) {
            this.excludedPaymentTypes = new ArrayList<PaymentType>();
            for (String paymentTypeId : excludedPaymentTypeIds) {
                PaymentType excludedPaymentType = new PaymentType(paymentTypeId);
                this.excludedPaymentTypes.add(excludedPaymentType);
            }
        }
    }

    public void setDefaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
    }

    public void setDefaultPaymentTypeId(String defaultPaymentTypeId) {
        this.defaultPaymentTypeId = defaultPaymentTypeId;
    }

    public Integer getMaxInstallments() {
        return this.maxInstallments;
    }

    @NonNull
    public List<String> getExcludedPaymentMethodIds() {
        if (this.excludedPaymentMethods != null) {
            ArrayList<String> excludedPaymentMethodIds = new ArrayList<String>();
            for (PaymentMethod paymentMethod : this.excludedPaymentMethods) {
                excludedPaymentMethodIds.add(paymentMethod.getId());
            }
            return excludedPaymentMethodIds;
        }
        return new ArrayList<String>();
    }

    public Integer getDefaultInstallments() {
        return this.defaultInstallments;
    }

    public void setExcludedPaymentMethodIds(List<String> excludedPaymentMethodIds) {
        if (excludedPaymentMethodIds != null) {
            this.excludedPaymentMethods = new ArrayList<PaymentMethod>();
            for (String paymentMethodId : excludedPaymentMethodIds) {
                PaymentMethod excludedPaymentMethod = new PaymentMethod(paymentMethodId);
                this.excludedPaymentMethods.add(excludedPaymentMethod);
            }
        }
    }

    @NonNull
    public List<String> getExcludedPaymentTypes() {
        if (this.excludedPaymentTypes != null) {
            ArrayList<String> excludedPaymentTypeIds = new ArrayList<String>();
            for (PaymentType paymentType : this.excludedPaymentTypes) {
                excludedPaymentTypeIds.add(paymentType.getId());
            }
            return excludedPaymentTypeIds;
        }
        return new ArrayList<String>();
    }

    @Nullable
    public String getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    public String getDefaultPaymentTypeId() {
        return this.defaultPaymentTypeId;
    }

    public List<PayerCost> getInstallmentsBelowMax(List<PayerCost> payerCosts) {
        ArrayList<PayerCost> validPayerCosts = new ArrayList<PayerCost>();
        if (this.maxInstallments != null) {
            for (PayerCost currentPayerCost : payerCosts) {
                if (currentPayerCost.getInstallments() > this.maxInstallments) continue;
                validPayerCosts.add(currentPayerCost);
            }
            return validPayerCosts;
        }
        return payerCosts;
    }

    @Nullable
    public PayerCost getDefaultInstallments(List<PayerCost> payerCosts) {
        PayerCost defaultPayerCost = null;
        for (PayerCost currentPayerCost : payerCosts) {
            if (!currentPayerCost.getInstallments().equals(this.defaultInstallments)) continue;
            defaultPayerCost = currentPayerCost;
            break;
        }
        return defaultPayerCost;
    }

    public List<PaymentMethod> getSupportedPaymentMethods(List<PaymentMethod> paymentMethods) {
        ArrayList<PaymentMethod> supportedPaymentMethods = new ArrayList<PaymentMethod>();
        if (paymentMethods != null) {
            for (PaymentMethod paymentMethod : paymentMethods) {
                if (!this.isPaymentMethodSupported(paymentMethod)) continue;
                supportedPaymentMethods.add(paymentMethod);
            }
        }
        return supportedPaymentMethods;
    }

    public boolean isPaymentMethodSupported(PaymentMethod paymentMethod) {
        boolean isSupported = true;
        if (paymentMethod == null) {
            isSupported = false;
        } else {
            List<String> excludedPaymentMethodIds = this.getExcludedPaymentMethodIds();
            List<String> excludedPaymentTypes = this.getExcludedPaymentTypes();
            if (excludedPaymentMethodIds != null && excludedPaymentMethodIds.contains(paymentMethod.getId()) || excludedPaymentTypes != null && excludedPaymentTypes.contains(paymentMethod.getPaymentTypeId())) {
                isSupported = false;
            }
        }
        return isSupported;
    }

    @Nullable
    public PaymentMethod getDefaultPaymentMethod(List<PaymentMethod> paymentMethods) {
        PaymentMethod defaultPaymentMethod = null;
        if (this.defaultPaymentMethodId != null && paymentMethods != null) {
            for (PaymentMethod pm : paymentMethods) {
                if (!pm.getId().equals(this.defaultPaymentMethodId)) continue;
                defaultPaymentMethod = pm;
                break;
            }
        }
        return defaultPaymentMethod;
    }

    public boolean installmentPreferencesValid() {
        return this.validDefaultInstallments() && this.validMaxInstallments();
    }

    public boolean excludedPaymentTypesValid() {
        return this.excludedPaymentTypes == null || this.excludedPaymentTypes.size() < PaymentTypes.getAllPaymentTypes().size();
    }

    public boolean validDefaultInstallments() {
        return this.defaultInstallments == null || this.defaultInstallments > 0;
    }

    public boolean validMaxInstallments() {
        return this.maxInstallments == null || this.maxInstallments > 0;
    }

    public List<Card> getValidCards(List<Card> cards) {
        ArrayList<Card> supportedCards = new ArrayList<Card>();
        if (cards != null) {
            for (Card card : cards) {
                if (!this.isPaymentMethodSupported(card.getPaymentMethod())) continue;
                supportedCards.add(card);
            }
        }
        return supportedCards;
    }

    public void setDefaultCardId(String defaultCardId) {
        this.defaultCardId = defaultCardId;
    }

    @Nullable
    public String getDefaultCardId() {
        return this.defaultCardId;
    }
}

