/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.android.px.model.internal.Action;
import com.mercadopago.android.px.model.internal.Text;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CongratsResponse
implements Parcelable {
    public static final CongratsResponse EMPTY = new CongratsResponse();
    public static final Parcelable.Creator<CongratsResponse> CREATOR = new Parcelable.Creator<CongratsResponse>(){

        public CongratsResponse createFromParcel(Parcel in) {
            return new CongratsResponse(in);
        }

        public CongratsResponse[] newArray(int size) {
            return new CongratsResponse[size];
        }
    };
    @SerializedName(value="mpuntos")
    @Nullable
    private final Score score;
    @SerializedName(value="discounts")
    @Nullable
    private final Discount discount;
    @SerializedName(value="expense_split")
    @Nullable
    private final MoneySplit moneySplit;
    @SerializedName(value="cross_selling")
    private final List<CrossSelling> crossSellings;
    private final Text topTextBox;
    private final Action viewReceipt;
    private final boolean customOrder;

    private CongratsResponse() {
        this.score = null;
        this.discount = null;
        this.moneySplit = null;
        this.crossSellings = Collections.emptyList();
        this.topTextBox = Text.EMPTY;
        this.viewReceipt = null;
        this.customOrder = false;
    }

    CongratsResponse(Parcel in) {
        this.score = (Score)in.readParcelable(Score.class.getClassLoader());
        this.discount = (Discount)in.readParcelable(Discount.class.getClassLoader());
        this.moneySplit = (MoneySplit)in.readParcelable(MoneySplit.class.getClassLoader());
        this.crossSellings = in.createTypedArrayList(CrossSelling.CREATOR);
        this.topTextBox = (Text)in.readParcelable(Text.class.getClassLoader());
        this.viewReceipt = (Action)in.readParcelable(Action.class.getClassLoader());
        this.customOrder = in.readInt() == 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.score, flags);
        dest.writeParcelable((Parcelable)this.discount, flags);
        dest.writeParcelable((Parcelable)this.moneySplit, flags);
        dest.writeTypedList(this.crossSellings);
        dest.writeParcelable((Parcelable)this.topTextBox, flags);
        dest.writeParcelable((Parcelable)this.viewReceipt, flags);
        dest.writeInt(this.customOrder ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    @Nullable
    public Score getScore() {
        return this.score;
    }

    @Nullable
    public Discount getDiscount() {
        return this.discount;
    }

    @Nullable
    public MoneySplit getMoneySplit() {
        return this.moneySplit;
    }

    @NonNull
    public List<CrossSelling> getCrossSellings() {
        return this.crossSellings != null ? this.crossSellings : Collections.emptyList();
    }

    @NonNull
    public Text getTopTextBox() {
        return this.topTextBox != null ? this.topTextBox : Text.EMPTY;
    }

    @Nullable
    public Action getViewReceipt() {
        return this.viewReceipt;
    }

    public boolean hasCustomOrder() {
        return this.customOrder;
    }

    public static final class MoneySplit
    implements Parcelable {
        private final Text title;
        private final Action action;
        private final String imageUrl;
        public static final Parcelable.Creator<MoneySplit> CREATOR = new Parcelable.Creator<MoneySplit>(){

            public MoneySplit createFromParcel(Parcel in) {
                return new MoneySplit(in);
            }

            public MoneySplit[] newArray(int size) {
                return new MoneySplit[size];
            }
        };

        public Text getTitle() {
            return this.title;
        }

        public Action getAction() {
            return this.action;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        MoneySplit(Parcel in) {
            this.title = (Text)in.readParcelable(Text.class.getClassLoader());
            this.action = (Action)in.readParcelable(Action.class.getClassLoader());
            this.imageUrl = in.readString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.title, flags);
            dest.writeParcelable((Parcelable)this.action, flags);
            dest.writeString(this.imageUrl);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static final class AdditionalEdgeInsets
    implements Parcelable {
        public static final Parcelable.Creator<AdditionalEdgeInsets> CREATOR = new Parcelable.Creator<AdditionalEdgeInsets>(){

            public AdditionalEdgeInsets createFromParcel(Parcel in) {
                return new AdditionalEdgeInsets(in);
            }

            public AdditionalEdgeInsets[] newArray(int size) {
                return new AdditionalEdgeInsets[size];
            }
        };
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        AdditionalEdgeInsets(Parcel in) {
            this.top = in.readInt();
            this.left = in.readInt();
            this.bottom = in.readInt();
            this.right = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.top);
            dest.writeInt(this.left);
            dest.writeInt(this.bottom);
            dest.writeInt(this.right);
        }

        public int describeContents() {
            return 0;
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getRight() {
            return this.right;
        }
    }

    public static final class PXBusinessTouchpoint
    implements Parcelable {
        public static final Parcelable.Creator<PXBusinessTouchpoint> CREATOR = new Parcelable.Creator<PXBusinessTouchpoint>(){

            public PXBusinessTouchpoint createFromParcel(Parcel in) {
                return new PXBusinessTouchpoint(in);
            }

            public PXBusinessTouchpoint[] newArray(int size) {
                return new PXBusinessTouchpoint[size];
            }
        };
        private final String id;
        private final String type;
        private final HashMap content;
        @Nullable
        private final HashMap tracking;
        @SerializedName(value="additional_edge_insets")
        @Nullable
        private final AdditionalEdgeInsets additionalEdgeInsets;

        PXBusinessTouchpoint(Parcel in) {
            this.id = in.readString();
            this.type = in.readString();
            this.content = in.readHashMap(HashMap.class.getClassLoader());
            this.tracking = in.readHashMap(HashMap.class.getClassLoader());
            this.additionalEdgeInsets = (AdditionalEdgeInsets)in.readParcelable(AdditionalEdgeInsets.class.getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.id);
            dest.writeString(this.type);
            dest.writeMap((Map)this.content);
            dest.writeMap((Map)this.tracking);
            dest.writeParcelable((Parcelable)this.additionalEdgeInsets, flags);
        }

        public int describeContents() {
            return 0;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public HashMap getContent() {
            return this.content;
        }

        @Nullable
        public HashMap getTracking() {
            return this.tracking;
        }

        @Nullable
        public AdditionalEdgeInsets getAdditionalEdgeInsets() {
            return this.additionalEdgeInsets;
        }
    }

    public static final class CrossSelling
    implements Parcelable {
        public static final Parcelable.Creator<CrossSelling> CREATOR = new Parcelable.Creator<CrossSelling>(){

            public CrossSelling createFromParcel(Parcel in) {
                return new CrossSelling(in);
            }

            public CrossSelling[] newArray(int size) {
                return new CrossSelling[size];
            }
        };
        private final String title;
        private final String icon;
        private final Action action;
        private final String contentId;

        CrossSelling(Parcel in) {
            this.title = in.readString();
            this.icon = in.readString();
            this.action = (Action)in.readParcelable(Action.class.getClassLoader());
            this.contentId = in.readString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.title);
            dest.writeString(this.icon);
            dest.writeParcelable((Parcelable)this.action, flags);
            dest.writeString(this.contentId);
        }

        public int describeContents() {
            return 0;
        }

        public String getTitle() {
            return this.title;
        }

        public String getIcon() {
            return this.icon;
        }

        public Action getAction() {
            return this.action;
        }

        public String getContentId() {
            return this.contentId;
        }
    }

    public static final class Discount
    implements Parcelable {
        public static final Parcelable.Creator<Discount> CREATOR = new Parcelable.Creator<Discount>(){

            public Discount createFromParcel(Parcel in) {
                return new Discount(in);
            }

            public Discount[] newArray(int size) {
                return new Discount[size];
            }
        };
        private final String title;
        private final String subtitle;
        private final Action action;
        @SerializedName(value="action_download")
        private final DownloadApp actionDownload;
        private final PXBusinessTouchpoint touchpoint;
        private final List<Item> items;

        Discount(Parcel in) {
            this.title = in.readString();
            this.subtitle = in.readString();
            this.action = (Action)in.readParcelable(Action.class.getClassLoader());
            this.actionDownload = (DownloadApp)in.readParcelable(DownloadApp.class.getClassLoader());
            this.touchpoint = (PXBusinessTouchpoint)in.readParcelable(PXBusinessTouchpoint.class.getClassLoader());
            this.items = in.createTypedArrayList(Item.CREATOR);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.title);
            dest.writeString(this.subtitle);
            dest.writeParcelable((Parcelable)this.action, flags);
            dest.writeParcelable((Parcelable)this.actionDownload, flags);
            dest.writeParcelable((Parcelable)this.touchpoint, flags);
            dest.writeTypedList(this.items);
        }

        public int describeContents() {
            return 0;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public Action getAction() {
            return this.action;
        }

        public DownloadApp getActionDownload() {
            return this.actionDownload;
        }

        public PXBusinessTouchpoint getTouchpoint() {
            return this.touchpoint;
        }

        @NonNull
        public List<Item> getItems() {
            return this.items != null ? this.items : Collections.emptyList();
        }

        public static final class Item
        implements Parcelable {
            public static final Parcelable.Creator<Item> CREATOR = new Parcelable.Creator<Item>(){

                public Item createFromParcel(Parcel in) {
                    return new Item(in);
                }

                public Item[] newArray(int size) {
                    return new Item[size];
                }
            };
            private final String title;
            private final String subtitle;
            private final String icon;
            private final String target;
            private final String campaignId;

            Item(Parcel in) {
                this.title = in.readString();
                this.subtitle = in.readString();
                this.icon = in.readString();
                this.target = in.readString();
                this.campaignId = in.readString();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.title);
                dest.writeString(this.subtitle);
                dest.writeString(this.icon);
                dest.writeString(this.target);
                dest.writeString(this.campaignId);
            }

            public int describeContents() {
                return 0;
            }

            public String getTitle() {
                return this.title;
            }

            public String getSubtitle() {
                return this.subtitle;
            }

            public String getIcon() {
                return this.icon;
            }

            public String getTarget() {
                return this.target;
            }

            public String getCampaignId() {
                return this.campaignId;
            }
        }

        public static final class DownloadApp
        implements Parcelable {
            public static final Parcelable.Creator<DownloadApp> CREATOR = new Parcelable.Creator<DownloadApp>(){

                public DownloadApp createFromParcel(Parcel in) {
                    return new DownloadApp(in);
                }

                public DownloadApp[] newArray(int size) {
                    return new DownloadApp[size];
                }
            };
            private final String title;
            private final Action action;

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.title);
                dest.writeParcelable((Parcelable)this.action, flags);
            }

            DownloadApp(Parcel in) {
                this.title = in.readString();
                this.action = (Action)in.readParcelable(Action.class.getClassLoader());
            }

            public String getTitle() {
                return this.title;
            }

            public Action getAction() {
                return this.action;
            }
        }
    }

    public static final class Score
    implements Parcelable {
        public static final Parcelable.Creator<Score> CREATOR = new Parcelable.Creator<Score>(){

            public Score createFromParcel(Parcel in) {
                return new Score(in);
            }

            public Score[] newArray(int size) {
                return new Score[size];
            }
        };
        private final Progress progress;
        private final String title;
        private final Action action;

        Score(Parcel in) {
            this.progress = (Progress)in.readParcelable(Progress.class.getClassLoader());
            this.title = in.readString();
            this.action = (Action)in.readParcelable(Action.class.getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.progress, flags);
            dest.writeString(this.title);
            dest.writeParcelable((Parcelable)this.action, flags);
        }

        public int describeContents() {
            return 0;
        }

        public Progress getProgress() {
            return this.progress;
        }

        public String getTitle() {
            return this.title;
        }

        public Action getAction() {
            return this.action;
        }

        public static final class Progress
        implements Parcelable {
            public static final Parcelable.Creator<Progress> CREATOR = new Parcelable.Creator<Progress>(){

                public Progress createFromParcel(Parcel in) {
                    return new Progress(in);
                }

                public Progress[] newArray(int size) {
                    return new Progress[size];
                }
            };
            private final float percentage;
            @SerializedName(value="level_color")
            private final String color;
            @SerializedName(value="level_number")
            private final int level;

            Progress(Parcel in) {
                this.percentage = in.readFloat();
                this.color = in.readString();
                this.level = in.readInt();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeFloat(this.percentage);
                dest.writeString(this.color);
                dest.writeInt(this.level);
            }

            public int describeContents() {
                return 0;
            }

            public float getPercentage() {
                return this.percentage;
            }

            public String getColor() {
                return this.color;
            }

            public int getLevel() {
                return this.level;
            }
        }
    }
}

