/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collection;

public final class ListUtil {
    public static final Matcher<String> CONTAIN_IGNORE_CASE = String::equalsIgnoreCase;

    private ListUtil() {
        throw new AssertionError((Object)"Util classes shouldn't be instantiated.");
    }

    public static boolean isEmpty(@Nullable Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Collection collection) {
        return !ListUtil.isEmpty(collection);
    }

    public static <T> boolean contains(@Nullable Collection<T> list, @Nullable T value, @NonNull Matcher<T> matcher) {
        if (value == null || ListUtil.isEmpty(list)) {
            return false;
        }
        boolean contains = false;
        for (T element : list) {
            contains |= matcher.apply(element, value);
        }
        return contains;
    }

    public static interface Matcher<T> {
        public boolean apply(@NonNull T var1, @NonNull T var2);
    }
}

