/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.mercadopago.android.px.internal.util.ListUtil;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.model.ExitAction;
import com.mercadopago.android.px.model.ExternalFragment;
import com.mercadopago.android.px.model.IParcelablePaymentDescriptor;
import com.mercadopago.android.px.model.IPaymentDescriptorHandler;
import com.mercadopago.android.px.model.internal.PrimaryExitAction;
import com.mercadopago.android.px.model.internal.SecondaryExitAction;
import java.util.Collections;
import java.util.List;

public class BusinessPayment
implements IParcelablePaymentDescriptor {
    @NonNull
    private final String title;
    @NonNull
    private final Decorator decorator;
    @NonNull
    private final String paymentStatus;
    @NonNull
    private final String paymentStatusDetail;
    private final boolean shouldShowPaymentMethod;
    private final int iconId;
    @Nullable
    private final String help;
    @Nullable
    private final ExitAction exitActionPrimary;
    @Nullable
    private final ExitAction exitActionSecondary;
    @Nullable
    private final String statementDescription;
    @Nullable
    private final String receiptId;
    @Nullable
    private final String imageUrl;
    @Nullable
    private final ExternalFragment topFragment;
    @Nullable
    private final ExternalFragment bottomFragment;
    @Nullable
    private final ExternalFragment importantFragment;
    @Nullable
    private final String subtitle;
    @Nullable
    private final String paymentTypeId;
    @Nullable
    private final String paymentMethodId;
    @Nullable
    private final List<String> receiptIdList;
    private final boolean shouldShowReceipt;
    public static final Parcelable.Creator<BusinessPayment> CREATOR = new Parcelable.Creator<BusinessPayment>(){

        public BusinessPayment createFromParcel(Parcel in) {
            return new BusinessPayment(in);
        }

        public BusinessPayment[] newArray(int size) {
            return new BusinessPayment[size];
        }
    };

    BusinessPayment(Builder builder) {
        this.help = builder.help;
        this.title = builder.title;
        this.decorator = builder.decorator;
        this.iconId = builder.iconId;
        this.shouldShowPaymentMethod = builder.shouldShowPaymentMethod;
        this.exitActionPrimary = builder.buttonPrimary;
        this.exitActionSecondary = builder.buttonSecondary;
        this.statementDescription = builder.statementDescription;
        this.receiptId = builder.receiptId;
        this.imageUrl = builder.imageUrl;
        this.topFragment = builder.topFragment;
        this.bottomFragment = builder.bottomFragment;
        this.importantFragment = builder.importantFragment;
        this.paymentStatus = builder.paymentStatus;
        this.paymentStatusDetail = builder.paymentStatusDetail;
        this.subtitle = builder.subtitle;
        this.paymentMethodId = builder.paymentMethodId;
        this.paymentTypeId = builder.paymentTypeId;
        this.receiptIdList = builder.receiptIdList;
        this.shouldShowReceipt = builder.shouldShowReceipt;
    }

    protected BusinessPayment(Parcel in) {
        this.iconId = in.readInt();
        this.title = in.readString();
        this.shouldShowPaymentMethod = in.readByte() != 0;
        this.exitActionPrimary = (ExitAction)in.readParcelable(ExitAction.class.getClassLoader());
        this.exitActionSecondary = (ExitAction)in.readParcelable(ExitAction.class.getClassLoader());
        this.decorator = Decorator.fromName(in.readString());
        this.help = in.readString();
        this.statementDescription = in.readString();
        this.receiptId = in.readString();
        this.imageUrl = in.readString();
        this.topFragment = (ExternalFragment)in.readParcelable(ExternalFragment.class.getClassLoader());
        this.bottomFragment = (ExternalFragment)in.readParcelable(ExternalFragment.class.getClassLoader());
        this.importantFragment = (ExternalFragment)in.readParcelable(ExternalFragment.class.getClassLoader());
        this.paymentStatus = in.readString();
        this.paymentStatusDetail = in.readString();
        this.subtitle = in.readString();
        this.paymentMethodId = in.readString();
        this.paymentTypeId = in.readString();
        this.receiptIdList = in.createStringArrayList();
        this.shouldShowReceipt = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.iconId);
        dest.writeString(this.title);
        dest.writeByte((byte)(this.shouldShowPaymentMethod ? 1 : 0));
        dest.writeParcelable((Parcelable)this.exitActionPrimary, flags);
        dest.writeParcelable((Parcelable)this.exitActionSecondary, flags);
        dest.writeString(this.decorator.name);
        dest.writeString(this.help);
        dest.writeString(this.statementDescription);
        dest.writeString(this.receiptId);
        dest.writeString(this.imageUrl);
        dest.writeParcelable((Parcelable)this.topFragment, 0);
        dest.writeParcelable((Parcelable)this.bottomFragment, 0);
        dest.writeParcelable((Parcelable)this.importantFragment, 0);
        dest.writeString(this.paymentStatus);
        dest.writeString(this.paymentStatusDetail);
        dest.writeString(this.subtitle);
        dest.writeString(this.paymentMethodId);
        dest.writeString(this.paymentTypeId);
        dest.writeStringList(this.receiptIdList);
        dest.writeByte((byte)(this.shouldShowReceipt ? 1 : 0));
    }

    public boolean hasReceipt() {
        return this.getReceipt() != null;
    }

    public boolean hasTopFragment() {
        return this.getTopFragment() != null;
    }

    public boolean hasBottomFragment() {
        return this.getBottomFragment() != null;
    }

    public boolean hasImportantFragment() {
        return this.getImportantFragment() != null;
    }

    @NonNull
    public Decorator getDecorator() {
        return this.decorator;
    }

    public int getIcon() {
        return this.iconId;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public boolean hasHelp() {
        return TextUtil.isNotEmpty(this.help);
    }

    @Nullable
    public ExitAction getSecondaryAction() {
        return this.exitActionSecondary != null ? new SecondaryExitAction(this.exitActionSecondary) : null;
    }

    @Nullable
    public ExitAction getPrimaryAction() {
        return this.exitActionPrimary != null ? new PrimaryExitAction(this.exitActionPrimary) : null;
    }

    @Nullable
    public String getHelp() {
        return this.help;
    }

    public boolean shouldShowPaymentMethod() {
        return this.shouldShowPaymentMethod;
    }

    @Override
    @Nullable
    public Long getId() {
        String receiptId = this.getReceipt();
        return receiptId != null ? Long.valueOf(Long.parseLong(receiptId)) : null;
    }

    @Override
    @Nullable
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Nullable
    public String getReceipt() {
        return ListUtil.isNotEmpty(this.receiptIdList) ? this.receiptIdList.get(0) : this.receiptId;
    }

    @Nullable
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Nullable
    public ExternalFragment getTopFragment() {
        return this.topFragment;
    }

    @Nullable
    public ExternalFragment getBottomFragment() {
        return this.bottomFragment;
    }

    @Nullable
    public ExternalFragment getImportantFragment() {
        return this.importantFragment;
    }

    @Override
    @NonNull
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Override
    @NonNull
    public String getPaymentStatusDetail() {
        return this.paymentStatusDetail;
    }

    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    @Override
    @Nullable
    public String getPaymentTypeId() {
        return this.paymentTypeId;
    }

    @Override
    @Nullable
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Override
    @Nullable
    public List<String> getPaymentIds() {
        return ListUtil.isNotEmpty(this.receiptIdList) ? this.receiptIdList : (TextUtil.isNotEmpty(this.receiptId) ? Collections.singletonList(this.receiptId) : null);
    }

    public boolean shouldShowReceipt() {
        return this.shouldShowReceipt;
    }

    @Override
    public void process(@NonNull IPaymentDescriptorHandler handler) {
        handler.visit(this);
    }

    public static final class Builder {
        @NonNull
        final Decorator decorator;
        @DrawableRes
        final int iconId;
        @NonNull
        final String title;
        @NonNull
        final String paymentStatus;
        @NonNull
        final String paymentStatusDetail;
        @Nullable
        final String paymentMethodId;
        @Nullable
        final String paymentTypeId;
        @Nullable
        String imageUrl;
        boolean shouldShowPaymentMethod;
        @Nullable
        String statementDescription;
        @Nullable
        ExitAction buttonPrimary;
        @Nullable
        ExitAction buttonSecondary;
        @Nullable
        String help;
        @Nullable
        String receiptId;
        @Nullable
        String subtitle;
        @Nullable
        List<String> receiptIdList;
        boolean shouldShowReceipt = true;
        ExternalFragment topFragment;
        ExternalFragment bottomFragment;
        ExternalFragment importantFragment;

        @Deprecated
        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @DrawableRes int iconId, @NonNull String title) {
            this(decorator, paymentStatus, paymentStatusDetail, iconId, title, null, null);
        }

        @Deprecated
        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @NonNull String imageUrl, @NonNull String title) {
            this(decorator, paymentStatus, paymentStatusDetail, imageUrl, title, null, null);
        }

        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @DrawableRes int iconId, @NonNull String title, @NonNull String paymentMethodId, @NonNull String paymentTypeId) {
            this.decorator = decorator;
            this.paymentStatus = paymentStatus;
            this.paymentStatusDetail = paymentStatusDetail;
            this.iconId = iconId;
            this.title = title;
            this.paymentMethodId = paymentMethodId;
            this.paymentTypeId = paymentTypeId;
        }

        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @NonNull String imageUrl, @NonNull String title, @NonNull String paymentMethodId, @NonNull String paymentTypeId) {
            this(decorator, paymentStatus, paymentStatusDetail, 0, title, paymentMethodId, paymentTypeId);
            this.imageUrl = imageUrl;
        }

        public BusinessPayment build() {
            if (this.buttonPrimary == null && this.buttonSecondary == null) {
                throw new IllegalStateException("At least one button should be provided for BusinessPayment");
            }
            return new BusinessPayment(this);
        }

        public Builder setPrimaryButton(@Nullable ExitAction exitAction) {
            this.buttonPrimary = exitAction;
            return this;
        }

        public Builder setSecondaryButton(@Nullable ExitAction exitAction) {
            this.buttonSecondary = exitAction;
            return this;
        }

        public Builder setHelp(@Nullable String help) {
            this.help = help;
            return this;
        }

        public Builder setPaymentMethodVisibility(boolean visible) {
            this.shouldShowPaymentMethod = visible;
            return this;
        }

        public Builder setStatementDescription(String statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder setReceiptId(String receiptId) {
            this.receiptId = receiptId;
            return this;
        }

        public Builder setTopFragment(@NonNull Class<? extends Fragment> zClass, @Nullable Bundle args) {
            this.topFragment = new ExternalFragment(zClass, args);
            return this;
        }

        public Builder setBottomFragment(@NonNull Class<? extends Fragment> zClass, @Nullable Bundle args) {
            this.bottomFragment = new ExternalFragment(zClass, args);
            return this;
        }

        public Builder setImportantFragment(@NonNull Class<? extends Fragment> zClass, @Nullable Bundle args) {
            this.importantFragment = new ExternalFragment(zClass, args);
            return this;
        }

        public Builder setSubtitle(@Nullable String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setReceiptIdList(@NonNull List<String> receiptIdList) {
            this.receiptIdList = receiptIdList;
            return this;
        }

        public Builder setShouldShowReceipt(boolean shouldShowReceipt) {
            this.shouldShowReceipt = shouldShowReceipt;
            return this;
        }
    }

    public static enum Decorator {
        APPROVED("APPROVED"),
        REJECTED("REJECTED"),
        PENDING("PENDING");

        public final String name;

        private Decorator(String name) {
            this.name = name;
        }

        public static Decorator fromName(String text) {
            for (Decorator s : Decorator.values()) {
                if (!s.name.equalsIgnoreCase(text)) continue;
                return s;
            }
            throw new IllegalStateException("Invalid decorator");
        }
    }
}

