/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.internal.core.ConnectivityStateInterceptor;
import com.mercadopago.android.px.internal.core.FlowIdInterceptor;
import com.mercadopago.android.px.internal.core.LanguageInterceptor;
import com.mercadopago.android.px.internal.core.PlatformInterceptor;
import com.mercadopago.android.px.internal.core.ProductIdInterceptor;
import com.mercadopago.android.px.internal.core.RequestIdInterceptor;
import com.mercadopago.android.px.internal.core.ScreenDensityInterceptor;
import com.mercadopago.android.px.internal.core.SessionIdInterceptor;
import com.mercadopago.android.px.internal.core.StrictModeInterceptor;
import com.mercadopago.android.px.internal.core.TLSSocketFactory;
import com.mercadopago.android.px.internal.core.UserAgentInterceptor;
import com.mercadopago.android.px.internal.di.NetworkModule;
import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;

public final class HttpClientUtil {
    private static OkHttpClient client;
    private static final int CACHE_SIZE = 0xA00000;
    private static final String TLS_1_2 = "TLSv1.2";
    private static final String CACHE_DIR_NAME = "PX_OKHTTP_CACHE_SERVICES";
    private static final HttpLoggingInterceptor.Level LOGGING_INTERCEPTOR;

    private HttpClientUtil() {
    }

    public static synchronized OkHttpClient getClient(@NonNull Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        if (client == null) {
            OkHttpClient.Builder baseClient = HttpClientUtil.createBaseClient(context.getApplicationContext(), connectTimeout, readTimeout, writeTimeout);
            client = HttpClientUtil.enableTLS12(baseClient).build();
        }
        return client;
    }

    @NonNull
    public static OkHttpClient.Builder createBaseClient(@Nullable Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        File cacheFile = HttpClientUtil.getCacheDir(context);
        HttpLoggingInterceptor loginInterceptor = new HttpLoggingInterceptor();
        loginInterceptor.setLevel(LOGGING_INTERCEPTOR);
        OkHttpClient.Builder baseClient = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).cache(new Cache(cacheFile, 0xA00000L));
        if (context != null) {
            baseClient.addInterceptor((Interceptor)new ConnectivityStateInterceptor(context));
            baseClient.addInterceptor((Interceptor)new SessionIdInterceptor(NetworkModule.INSTANCE.getSessionIdProvider()));
            baseClient.addInterceptor((Interceptor)new ProductIdInterceptor(NetworkModule.INSTANCE.getProductIdProvider()));
            baseClient.addInterceptor((Interceptor)new ScreenDensityInterceptor(context));
            baseClient.addInterceptor((Interceptor)new PlatformInterceptor(context));
            baseClient.addInterceptor((Interceptor)new FlowIdInterceptor(NetworkModule.INSTANCE.getFlowIdProvider()));
            baseClient.addInterceptor((Interceptor)new LanguageInterceptor(context));
        }
        baseClient.addInterceptor((Interceptor)new StrictModeInterceptor());
        baseClient.addInterceptor((Interceptor)new RequestIdInterceptor());
        baseClient.addInterceptor((Interceptor)new UserAgentInterceptor("PX/Android/4.50.1"));
        baseClient.addInterceptor((Interceptor)loginInterceptor);
        return baseClient;
    }

    public static OkHttpClient.Builder enableTLS12(@NonNull OkHttpClient.Builder clientBuilder) {
        if (Build.VERSION.SDK_INT <= 21) {
            return HttpClientUtil.internalEnableTLS12(clientBuilder);
        }
        return clientBuilder;
    }

    private static OkHttpClient.Builder internalEnableTLS12(OkHttpClient.Builder client) {
        X509TrustManager certificate = HttpClientUtil.certificateTrustManager();
        if (certificate != null) {
            return HttpClientUtil.configureProtocol(client, certificate);
        }
        return client;
    }

    private static X509TrustManager certificateTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return (X509TrustManager)trustManagers[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            return null;
        }
    }

    private static OkHttpClient.Builder configureProtocol(OkHttpClient.Builder client, X509TrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance(TLS_1_2);
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            client.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(sslContext.getSocketFactory()), trustManager);
            return client.connectionSpecs(HttpClientUtil.availableConnectionSpecs());
        }
        catch (Exception exception) {
            return client;
        }
    }

    @NonNull
    private static List<ConnectionSpec> availableConnectionSpecs() {
        ConnectionSpec connectionSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
        ArrayList<ConnectionSpec> connectionSpecsList = new ArrayList<ConnectionSpec>();
        connectionSpecsList.add(connectionSpec);
        connectionSpecsList.add(ConnectionSpec.CLEARTEXT);
        return connectionSpecsList;
    }

    private static File getCacheDir(@Nullable Context context) {
        File cacheDir;
        if (context != null) {
            cacheDir = context.getCacheDir();
            if (cacheDir == null) {
                cacheDir = context.getDir("cache", 0);
            }
        } else {
            cacheDir = new File(Environment.getExternalStorageDirectory(), "MyCache");
        }
        return new File(cacheDir, CACHE_DIR_NAME);
    }

    public static void setCustomClient(OkHttpClient clientCustom) {
        client = clientCustom;
    }

    static {
        LOGGING_INTERCEPTOR = HttpLoggingInterceptor.Level.NONE;
    }
}

