/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.adapters;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.mercadopago.android.px.internal.callbacks.MPCall;
import com.mercadopago.android.px.internal.util.ApiUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ErrorHandlingCallAdapter {
    private ErrorHandlingCallAdapter() {
    }

    static void executeOnMainThread(@NonNull Runnable r) {
        new Handler(Looper.getMainLooper()).post(r);
    }

    static class MPCallAdapter<T>
    implements MPCall<T> {
        private static final int SUCCESS_STATUS_CODE = 200;
        private static final int REDIRECT_STATUS_CODE = 300;
        private final Call<T> call;

        MPCallAdapter(Call<T> call) {
            this.call = call;
        }

        @Override
        public void enqueue(final com.mercadopago.android.px.services.Callback<T> callback) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                    ErrorHandlingCallAdapter.executeOnMainThread(() -> {
                        int code = response.code();
                        if (code >= 200 && code < 300) {
                            Object body = response.body();
                            callback.success(body);
                        } else {
                            callback.failure(ApiUtil.getApiException(response));
                        }
                    });
                }

                public void onFailure(@NonNull Call<T> call, @NonNull Throwable th) {
                    if (++callback.attempts == 3 || th instanceof SocketTimeoutException) {
                        ErrorHandlingCallAdapter.executeOnMainThread(() -> callback.failure(ApiUtil.getApiException(th)));
                    } else {
                        call.clone().enqueue((Callback)this);
                    }
                }
            });
        }
    }

    public static class ErrorHandlingCallAdapterFactory
    extends CallAdapter.Factory {
        public CallAdapter<MPCall<?>, MPCallAdapter> get(@NonNull Type returnType, @NonNull Annotation[] annotations, @NonNull Retrofit retrofit) {
            TypeToken token = TypeToken.get((Type)returnType);
            if (!token.getRawType().equals(MPCall.class)) {
                return null;
            }
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalStateException("MPCall must have generic type (e.g., MPCall<ResponseBody>)");
            }
            final Type responseType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            return new CallAdapter<MPCall<?>, MPCallAdapter>(){

                public Type responseType() {
                    return responseType;
                }

                public MPCallAdapter adapt(@NonNull Call<MPCall<?>> call) {
                    return new MPCallAdapter(call);
                }
            };
        }
    }
}

