/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

public final class ParcelableUtil {
    private ParcelableUtil() {
    }

    @Nullable
    public static BigDecimal getOptionalBigDecimal(Parcel in) {
        if (in.readByte() == 0) {
            return null;
        }
        return new BigDecimal(in.readString());
    }

    @NonNull
    public static BigDecimal getBigDecimal(Parcel in) {
        return new BigDecimal(in.readString());
    }

    @Nullable
    public static Integer getOptionalInteger(Parcel in) {
        if (in.readByte() == 0) {
            return null;
        }
        return in.readInt();
    }

    public static void write(Parcel dest, BigDecimal number) {
        dest.writeString(number.toString());
    }

    public static void writeOptional(Parcel dest, @Nullable BigDecimal number) {
        if (number == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(number.toString());
        }
    }

    public static void writeOptional(Parcel dest, @Nullable Integer number) {
        if (number == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(number.intValue());
        }
    }

    public static <K extends Serializable, V extends Serializable> void writeSerializableMap(Parcel parcel, Map<K, V> map) {
        parcel.writeInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (e.getValue() == null) continue;
            parcel.writeSerializable((Serializable)e.getKey());
            parcel.writeSerializable((Serializable)e.getValue());
        }
    }

    public static <K extends Serializable, V extends Serializable> void readSerializableMap(@NonNull Map<K, V> map, Parcel parcel, @NonNull Class<K> kClass, @NonNull Class<V> vClass) {
        int size = parcel.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(Objects.requireNonNull(kClass.cast(parcel.readSerializable())), Objects.requireNonNull(vClass.cast(parcel.readSerializable())));
        }
    }

    @NonNull
    public static byte[] marshall(@NonNull Parcelable parcelable) {
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    @Nullable
    public static <T> T unmarshall(@NonNull byte[] bytes, @NonNull Parcelable.Creator<T> creator) {
        Parcel parcel = ParcelableUtil.unmarshall(bytes);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }

    @NonNull
    private static Parcel unmarshall(@NonNull byte[] bytes) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        return parcel;
    }
}

