/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mercadopago.android.px.internal.core.ApplicationModule;
import com.mercadopago.android.px.internal.core.SessionIdProvider;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class SessionInterceptor
implements Interceptor {
    private static final String SESSION_ID_HEADER = "X-Session-Id";
    @NonNull
    private final SessionIdProvider sessionIdProvider;

    public SessionInterceptor(@NonNull Context context) {
        this.sessionIdProvider = new ApplicationModule(context).getSessionIdProvider();
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(SESSION_ID_HEADER, this.sessionIdProvider.getSessionId()).build();
        return chain.proceed(request);
    }
}

