/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class PlatformInterceptor
implements Interceptor {
    private static final String HEADER_PLATFORM = "x-platform";
    private static final String PLATFORM_MP = "MP";
    private static final String PLATFORM_ML = "ML";
    private Context context;

    public PlatformInterceptor(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(HEADER_PLATFORM, this.getPlatform(this.context)).build();
        return chain.proceed(request);
    }

    private String getPlatform(Context context) {
        String packageName = context.getApplicationInfo().packageName;
        return packageName.contains("com.mercadolibre") ? PLATFORM_ML : PLATFORM_MP;
    }
}

