/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class ScreenDensityInterceptor
implements Interceptor {
    private static final String HEADER_KEY = "X-Density";
    @NonNull
    private final Context context;

    public ScreenDensityInterceptor(@NonNull Context context) {
        this.context = context;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(HEADER_KEY, this.getDensityName(this.context)).build();
        return chain.proceed(request);
    }

    private String getDensityName(@NonNull Context context) {
        float densityScale = 0.00625f;
        float density = context.getResources().getDisplayMetrics().density / 0.00625f;
        if (density >= 640.0f) {
            return "xxxhdpi";
        }
        if (density >= 480.0f) {
            return "xxhdpi";
        }
        if (density >= 320.0f) {
            return "xhdpi";
        }
        if (density >= 240.0f) {
            return "hdpi";
        }
        if (density >= 160.0f) {
            return "mdpi";
        }
        return "ldpi";
    }
}

