/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.mercadopago.android.px.internal.core.FileManager;
import com.mercadopago.android.px.internal.core.PreferenceComponent;
import com.mercadopago.android.px.internal.core.SessionIdProvider;
import com.mercadopago.android.px.internal.util.JsonUtil;
import com.mercadopago.android.px.internal.util.RetrofitUtil;
import java.io.File;
import retrofit2.Retrofit;

public class ApplicationModule
implements PreferenceComponent {
    private static final String SHARED_PREFERENCE_NAME = "com.mercadopago.checkout.store";
    @NonNull
    private final Context context;

    public ApplicationModule(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public SessionIdProvider getSessionIdProvider() {
        return new SessionIdProvider(this.getSharedPreferences());
    }

    @NonNull
    public SessionIdProvider newSessionProvider(String sessionId) {
        return new SessionIdProvider(this.getSharedPreferences(), sessionId);
    }

    @Override
    public SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
    }

    public JsonUtil getJsonUtil() {
        return JsonUtil.getInstance();
    }

    public FileManager getFileManager() {
        return new FileManager();
    }

    public File getCacheDir() {
        return this.context.getCacheDir();
    }

    public Retrofit getRetrofitClient() {
        return RetrofitUtil.getRetrofitClient(this.context);
    }
}

