/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.UUID;

public final class SessionIdProvider {
    private static final String PREF_SESSION_ID = "PREF_SESSION_ID";
    @NonNull
    private final SharedPreferences sharedPreferences;
    @Nullable
    private String id = UUID.randomUUID().toString();

    public static SessionIdProvider create(@NonNull SharedPreferences sharedPreferences) {
        return new SessionIdProvider(sharedPreferences);
    }

    private SessionIdProvider(@NonNull SharedPreferences sharedPreferences) {
        sharedPreferences.edit().putString(PREF_SESSION_ID, this.id).apply();
        this.sharedPreferences = sharedPreferences;
    }

    @NonNull
    public String getSessionId() {
        if (this.id == null) {
            this.id = this.sharedPreferences.getString(PREF_SESSION_ID, "no-value");
        }
        return this.id;
    }
}

