/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.mercadopago.android.px.internal.util.JsonUtil;
import com.mercadopago.android.px.internal.util.NoConnectivityException;
import com.mercadopago.android.px.model.exceptions.ApiException;
import retrofit2.Response;

public final class ApiUtil {
    private ApiUtil() {
    }

    public static <T> ApiException getApiException(Response<T> response) {
        ApiException apiException = null;
        try {
            String errorString = response.errorBody().string();
            apiException = JsonUtil.getInstance().fromJson(errorString, ApiException.class);
        }
        catch (Exception exception) {
        }
        finally {
            if (apiException == null) {
                apiException = new ApiException();
                apiException.setStatus(response.code());
            }
        }
        return apiException;
    }

    public static ApiException getApiException(Throwable throwable) {
        ApiException apiException = new ApiException();
        if (throwable instanceof NoConnectivityException) {
            apiException.setStatus(-1);
        }
        try {
            apiException.setMessage(throwable.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return apiException;
    }

    public static boolean checkConnection(@NonNull Context context) {
        if (context != null) {
            try {
                boolean haveConnectedWifi = false;
                boolean haveConnectedMobile = false;
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo ni = cm.getActiveNetworkInfo();
                if (ni != null && ni.isConnected()) {
                    if (ni.getType() == 1 && ni.isConnectedOrConnecting()) {
                        haveConnectedWifi = true;
                    }
                    if (ni.getType() == 0 && ni.isConnectedOrConnecting()) {
                        haveConnectedMobile = true;
                    }
                }
                return haveConnectedWifi || haveConnectedMobile;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static final class RequestOrigin {
        public static final String GET_PREFERENCE = "GET_PREFERENCE";
        public static final String PAYMENT_METHOD_SEARCH = "PAYMENT_METHOD_SEARCH";
        public static final String GET_INSTALLMENTS = "GET_INSTALLMENTS";
        public static final String GET_ISSUERS = "GET_ISSUERS";
        public static final String GET_DIRECT_DISCOUNT = "GET_DIRECT_DISCOUNT";
        public static final String GET_MERCHANT_DIRECT_DISCOUNT = "GET_MERCHANT_DIRECT_DISCOUNT";
        public static final String CREATE_PAYMENT = "CREATE_PAYMENT";
        public static final String CREATE_TOKEN = "CREATE_TOKEN";
        public static final String GET_CUSTOMER = "GET_CUSTOMER";
        public static final String GET_CODE_DISCOUNT = "GET_CODE_DISCOUNT";
        public static final String GET_CAMPAIGNS = "GET_CAMPAIGNS";
        public static final String GET_PAYMENT_METHODS = "GET_PAYMENT_METHODS";
        public static final String GET_IDENTIFICATION_TYPES = "GET_IDENTIFICATION_TYPES";
        public static final String GET_BANK_DEALS = "GET_BANK_DEALS";
        public static final String GET_INSTRUCTIONS = "GET_INSTRUCTIONS";

        private RequestOrigin() {
        }
    }

    public static final class StatusCodes {
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int PROCESSING = 499;
        public static final int BAD_REQUEST = 400;
        public static final int NOT_FOUND = 404;
        public static final int NO_CONNECTIVITY_ERROR = -1;
        public static final String INTERNAL_SERVER_ERROR_FIRST_DIGIT = "5";

        private StatusCodes() {
        }
    }
}

