/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.style.RelativeSizeSpan;
import com.mercadopago.android.px.internal.util.SuperscriptSpanAdjuster;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.model.Currency;
import com.mercadopago.android.px.model.Site;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;

public final class CurrenciesUtil {
    private static final String CURRENCY_ARGENTINA = "ARS";
    private static final String CURRENCY_BRAZIL = "BRL";
    private static final String CURRENCY_CHILE = "CLP";
    private static final String CURRENCY_COLOMBIA = "COP";
    private static final String CURRENCY_MEXICO = "MXN";
    private static final String CURRENCY_VENEZUELA = "VES";
    private static final String CURRENCY_USA = "USD";
    private static final String CURRENCY_PERU = "PEN";
    private static final String CURRENCY_URUGUAY = "UYU";
    public static final String ZERO_DECIMAL = "00";
    public static Map<String, Currency> currenciesList = new HashMap<String, Currency>(){
        {
            this.put(CurrenciesUtil.CURRENCY_ARGENTINA, new Currency(CurrenciesUtil.CURRENCY_ARGENTINA, "Peso argentino", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_BRAZIL, new Currency(CurrenciesUtil.CURRENCY_BRAZIL, "Real", "R$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_CHILE, new Currency(CurrenciesUtil.CURRENCY_CHILE, "Peso chileno", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_COLOMBIA, new Currency(CurrenciesUtil.CURRENCY_COLOMBIA, "Peso colombiano", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_MEXICO, new Currency(CurrenciesUtil.CURRENCY_MEXICO, "Peso mexicano", "$", 2, Character.valueOf(".".charAt(0)), Character.valueOf(",".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_VENEZUELA, new Currency(CurrenciesUtil.CURRENCY_VENEZUELA, "Bol\u00edvares Soberanos", "BsS", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_USA, new Currency(CurrenciesUtil.CURRENCY_USA, "Dolar americano", "US$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_PERU, new Currency(CurrenciesUtil.CURRENCY_PERU, "Soles", "S/.", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_URUGUAY, new Currency(CurrenciesUtil.CURRENCY_URUGUAY, "Peso Uruguayo", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
        }
    };

    private CurrenciesUtil() {
    }

    public static String getLocalizedAmountWithCurrencySymbol(@NonNull BigDecimal amount, @NonNull String currencyId, boolean shouldAddSpace) {
        Currency currency = currenciesList.get(currencyId);
        String formattedAmount = CurrenciesUtil.getLocalizedAmount(amount, currency);
        StringBuilder builder = new StringBuilder();
        builder.append(currency.getSymbol());
        if (shouldAddSpace) {
            builder.append(" ");
        }
        builder.append(formattedAmount);
        return builder.toString();
    }

    public static String getLocalizedAmountNoDecimals(BigDecimal truncated, Currency currency) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
        dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(0);
        return df.format(truncated);
    }

    public static String getLocalizedAmount(@NonNull BigDecimal amount, Currency currency) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
        dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(currency.getDecimalPlaces());
        df.setMaximumFractionDigits(currency.getDecimalPlaces());
        return df.format(amount);
    }

    public static String getLocalizedAmountWithCurrencySymbol(BigDecimal amount, Site site) {
        return CurrenciesUtil.getLocalizedAmountWithCurrencySymbol(amount, site.getCurrencyId(), true);
    }

    public static String getLocalizedAmountWithCurrencySymbol(BigDecimal amount, String currencyId) {
        return CurrenciesUtil.getLocalizedAmountWithCurrencySymbol(amount, currencyId, true);
    }

    public static Spanned getSpannedAmountWithCurrencySymbol(BigDecimal amount, String currencyId) {
        return CurrenciesUtil.getSpannedString(amount, currencyId, false, true);
    }

    public static String getSymbol(@NonNull String currencyId) {
        Currency currency = currenciesList.get(currencyId);
        if (currency == null) {
            throw new IllegalStateException("invalid currencyId");
        }
        return currency.getSymbol();
    }

    public static Character getDecimalSeparator(@NonNull String currencyId) {
        return CurrenciesUtil.getCurrency(currencyId).getDecimalSeparator();
    }

    public static String getDecimals(String currencyId, BigDecimal amount) {
        Currency currency = currenciesList.get(currencyId);
        String localizedAmount = CurrenciesUtil.getLocalizedAmount(amount, currency);
        int decimalDivisionIndex = localizedAmount.indexOf(currency.getDecimalSeparator().charValue());
        String decimals = null;
        if (decimalDivisionIndex != -1) {
            decimals = localizedAmount.substring(decimalDivisionIndex + 1, localizedAmount.length());
        }
        return decimals;
    }

    public static Spanned getSpannedString(BigDecimal amount, String currencyId, boolean symbolUp, boolean decimalsUp) {
        String localizedAmount = CurrenciesUtil.getLocalizedAmountWithoutZeroDecimals(currencyId, amount);
        SpannableStringBuilder spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
        if (decimalsUp && !CurrenciesUtil.hasZeroDecimals(currencyId, amount)) {
            int fromDecimals = localizedAmount.indexOf(CurrenciesUtil.getDecimalSeparator(currencyId).charValue()) + 1;
            localizedAmount = localizedAmount.replace(String.valueOf(CurrenciesUtil.getDecimalSeparator(currencyId)), " ");
            spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
            CurrenciesUtil.decimalsUp(currencyId, amount, spannableAmount, fromDecimals);
        }
        if (symbolUp) {
            CurrenciesUtil.symbolUp(currencyId, localizedAmount, spannableAmount);
        }
        return new SpannedString((CharSequence)spannableAmount);
    }

    public static boolean isValidCurrency(String currencyId) {
        return !TextUtil.isEmpty(currencyId) && currenciesList.containsKey(currencyId);
    }

    public static Currency getCurrency(String currencyKey) {
        return currenciesList.get(currencyKey);
    }

    public static String getLocalizedAmountWithoutZeroDecimals(@NonNull String currencyId, @NonNull BigDecimal amount) {
        String localized = CurrenciesUtil.getLocalizedAmountWithCurrencySymbol(amount, currencyId);
        if (CurrenciesUtil.hasZeroDecimals(currencyId, amount)) {
            Character decimalSeparator = currenciesList.get(currencyId).getDecimalSeparator();
            int decimalIndex = localized.indexOf(decimalSeparator.charValue());
            localized = localized.substring(0, decimalIndex);
        }
        return localized;
    }

    public static boolean hasZeroDecimals(String currencyId, BigDecimal amount) {
        String decimals = CurrenciesUtil.getDecimals(currencyId, amount);
        return ZERO_DECIMAL.equals(decimals) || TextUtil.isEmpty(decimals);
    }

    @NonNull
    public static SpannableStringBuilder getSpannableAmountWithSymbolWithoutZeroDecimals(@NonNull String currencyId, @NonNull BigDecimal amount) {
        String localizedAmount = CurrenciesUtil.getLocalizedAmountWithoutZeroDecimals(currencyId, amount);
        SpannableStringBuilder spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
        if (!CurrenciesUtil.hasZeroDecimals(currencyId, amount)) {
            int fromDecimals = localizedAmount.indexOf(CurrenciesUtil.getDecimalSeparator(currencyId).charValue());
            localizedAmount = localizedAmount.replace(String.valueOf(CurrenciesUtil.getDecimalSeparator(currencyId)), "");
            spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
            CurrenciesUtil.decimalsUp(currencyId, amount, spannableAmount, fromDecimals);
        }
        CurrenciesUtil.symbolUp(currencyId, localizedAmount, spannableAmount);
        return spannableAmount;
    }

    private static void symbolUp(@NonNull String currencyId, String localizedAmount, SpannableStringBuilder spannableAmount) {
        int fromSymbolPosition = localizedAmount.indexOf(CurrenciesUtil.getSymbol(currencyId));
        int toSymbolPosition = fromSymbolPosition + CurrenciesUtil.getSymbol(currencyId).length();
        spannableAmount.setSpan((Object)new RelativeSizeSpan(0.5f), fromSymbolPosition, toSymbolPosition, 33);
        spannableAmount.setSpan((Object)new SuperscriptSpanAdjuster(0.65f), fromSymbolPosition, toSymbolPosition, 33);
    }

    private static void decimalsUp(String currencyId, BigDecimal amount, SpannableStringBuilder spannableAmount, int fromDecimals) {
        int toDecimals = fromDecimals + CurrenciesUtil.getDecimals(currencyId, amount).length();
        spannableAmount.setSpan((Object)new RelativeSizeSpan(0.5f), fromDecimals, toDecimals, 33);
        spannableAmount.setSpan((Object)new SuperscriptSpanAdjuster(0.7f), fromDecimals, toDecimals, 33);
    }
}

