/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.services.util;

import com.mercadopago.android.px.services.exceptions.ApiException;
import com.mercadopago.android.px.services.util.JsonUtil;
import retrofit2.Response;

public class ApiUtil {
    public static <T> ApiException getApiException(Response<T> response) {
        ApiException apiException = null;
        try {
            String errorString = response.errorBody().string();
            apiException = JsonUtil.getInstance().fromJson(errorString, ApiException.class);
        }
        catch (Exception exception) {
        }
        finally {
            if (apiException == null) {
                apiException = new ApiException();
                apiException.setStatus(response.code());
            }
        }
        return apiException;
    }

    public static ApiException getApiException(Throwable throwable) {
        ApiException apiException = new ApiException();
        try {
            apiException.setMessage(throwable.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return apiException;
    }

    public class RequestOrigin {
        public static final String GET_PREFERENCE = "GET_PREFERENCE";
        public static final String PAYMENT_METHOD_SEARCH = "PAYMENT_METHOD_SEARCH";
        public static final String GET_INSTALLMENTS = "GET_INSTALLMENTS";
        public static final String GET_ISSUERS = "GET_ISSUERS";
        public static final String GET_DIRECT_DISCOUNT = "GET_DIRECT_DISCOUNT";
        public static final String GET_MERCHANT_DIRECT_DISCOUNT = "GET_MERCHANT_DIRECT_DISCOUNT";
        public static final String CREATE_PAYMENT = "CREATE_PAYMENT";
        public static final String CREATE_TOKEN = "CREATE_TOKEN";
        public static final String GET_CUSTOMER = "GET_CUSTOMER";
        public static final String GET_CODE_DISCOUNT = "GET_CODE_DISCOUNT";
        public static final String GET_CAMPAIGNS = "GET_CAMPAIGNS";
        public static final String GET_PAYMENT_METHODS = "GET_PAYMENT_METHODS";
        public static final String GET_IDENTIFICATION_TYPES = "GET_IDENTIFICATION_TYPES";
        public static final String GET_BANK_DEALS = "GET_BANK_DEALS";
        public static final String GET_INSTRUCTIONS = "GET_INSTRUCTIONS";
    }

    public class StatusCodes {
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int PROCESSING = 499;
        public static final int BAD_REQUEST = 400;
        public static final int NOT_FOUND = 404;
    }
}

