/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.services.core;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.services.util.NoConnectivityException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class ConnectivityStateInterceptor
implements Interceptor {
    @Nullable
    private final ConnectivityManager connectivityManager;

    public ConnectivityStateInterceptor(@Nullable ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    @SuppressLint(value={"MissingPermission"})
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (!(this.connectivityManager == null || this.connectivityManager.getActiveNetworkInfo() != null && this.connectivityManager.getActiveNetworkInfo().isAvailable() && this.connectivityManager.getActiveNetworkInfo().isConnected())) {
            throw new NoConnectivityException();
        }
        return chain.proceed(chain.request());
    }
}

