/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient.model;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public class ResponseContentSupplier
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private int status;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String charset;
    private String content;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient InputStream contentStream;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient CloseableHttpClient httpclient;

    public ResponseContentSupplier(String content, int status) {
        this.content = content;
        this.status = status;
    }

    public ResponseContentSupplier(HttpResponse response) {
        this.status = response.getStatusLine().getStatusCode();
        this.readHeaders(response);
        this.readCharset(response);
        try {
            InputStream entityContent;
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entityContent = entity != null ? entity.getContent() : null;
            if (entityContent != null) {
                byte[] bytes = ByteStreams.toByteArray((InputStream)entityContent);
                this.contentStream = new ByteArrayInputStream(bytes);
                this.content = new String(bytes, Strings.isNullOrEmpty((String)this.charset) ? Charset.defaultCharset().name() : this.charset);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getContent() {
        return this.content;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    @Override
    public void close() throws Exception {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
        if (this.contentStream != null) {
            this.contentStream.close();
        }
    }

    private void readCharset(HttpResponse response) {
        ContentType defaultContentType;
        Charset charset = null;
        ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
        if (contentType != null && (charset = contentType.getCharset()) == null && (defaultContentType = ContentType.getByMimeType((String)contentType.getMimeType())) != null) {
            charset = defaultContentType.getCharset();
        }
        if (charset != null) {
            this.charset = charset.name();
        }
    }

    private void readHeaders(HttpResponse response) {
        Header[] respHeaders;
        for (Header respHeader : respHeaders = response.getAllHeaders()) {
            List<String> hs = this.headers.get(respHeader.getName());
            if (hs == null) {
                hs = new ArrayList<String>();
                this.headers.put(respHeader.getName(), hs);
            }
            hs.add(respHeader.getValue());
        }
    }

    void setHttpClient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }
}

