/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient.model;

import com.alibaba.fastjson.JSON;
import com.meowlomo.jenkins.scm_httpclient.model.CommitInfo;
import hudson.EnvVars;
import java.util.List;
import java.util.Map;

public class JobBuildMessage {
    private String buildId;
    private String scmUrl;
    private String jobName;
    private String scmBranchOrRevision;
    List<CommitInfo> commitInfo;

    public JobBuildMessage() {
    }

    public JobBuildMessage(String buildId, String scmUrl, String jobName, String scmBranchOrRevision, List<CommitInfo> commitInfo) {
        this.buildId = buildId;
        this.scmUrl = scmUrl;
        this.jobName = jobName;
        this.scmBranchOrRevision = scmBranchOrRevision;
        this.commitInfo = commitInfo;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getscmBranchOrRevision() {
        return this.scmBranchOrRevision;
    }

    public void setscmBranchOrRevisionOrRevision(String scmBranchOrRevision) {
        this.scmBranchOrRevision = scmBranchOrRevision;
    }

    public List<CommitInfo> getCommitInfo() {
        return this.commitInfo;
    }

    public void setCommitInfo(List<CommitInfo> commitInfo) {
        this.commitInfo = commitInfo;
    }

    public void doSaveJobBuildMessageWork(EnvVars envVars, List<CommitInfo> commitInfos, Map<String, String> variables) {
        for (Map.Entry entry : envVars.entrySet()) {
            if (((String)entry.getKey()).equals("BUILD_ID")) {
                this.buildId = (String)entry.getValue();
            }
            if (((String)entry.getKey()).equals("JOB_NAME")) {
                this.jobName = (String)entry.getValue();
            }
            if (((String)entry.getKey()).equals("GIT_URL")) {
                this.scmUrl = (String)entry.getValue();
            } else if (((String)entry.getKey()).equals("SVN_URL")) {
                this.scmUrl = (String)entry.getValue();
            }
            if (((String)entry.getKey()).equals("GIT_BRANCH")) {
                this.scmBranchOrRevision = (String)entry.getValue();
                continue;
            }
            if (!((String)entry.getKey()).equals("SVN_REVISION")) continue;
            this.scmBranchOrRevision = (String)entry.getValue();
        }
        this.saveJobBuildMessageToJson(new JobBuildMessage(this.buildId, this.scmUrl, this.jobName, this.scmBranchOrRevision, commitInfos), variables);
    }

    private void saveJobBuildMessageToJson(JobBuildMessage jobBuildMessage, Map<String, String> variables) {
        String jobBuildMessageJson = "";
        if (jobBuildMessage != null) {
            jobBuildMessageJson = JSON.toJSONString((Object)jobBuildMessage);
            variables.put("JOB_BUILD_MESSAGE", jobBuildMessageJson);
        }
    }

    public String toString() {
        return "JobBuildMessage [buildId=" + this.buildId + ", scmUrl=" + this.scmUrl + ", jobName=" + this.jobName + ", scmBranchOrRevision=" + this.scmBranchOrRevision + ", commitInfo=" + this.commitInfo + "]";
    }
}

