/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient.auth;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.meowlomo.jenkins.scm_httpclient.auth.Authenticator;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class CredentialBasicAuthentication
implements Authenticator {
    private static final long serialVersionUID = 8034231374732499786L;
    private final StandardUsernamePasswordCredentials credential;

    public CredentialBasicAuthentication(StandardUsernamePasswordCredentials credential) {
        this.credential = credential;
    }

    @Override
    public String getKeyName() {
        return this.credential.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, PrintStream logger) throws IOException, InterruptedException {
        return CredentialBasicAuthentication.auth(clientBuilder, context, requestBase, this.credential.getUsername(), this.credential.getPassword().getPlainText());
    }

    static CloseableHttpClient auth(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(requestBase.getURI().getHost(), requestBase.getURI().getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(URIUtils.extractHost((URI)requestBase.getURI()), (AuthScheme)new BasicScheme());
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        return clientBuilder.build();
    }
}

