/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient;

import com.alibaba.fastjson.JSON;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.meowlomo.jenkins.scm_httpclient.HttpRequestExcution;
import com.meowlomo.jenkins.scm_httpclient.HttpRequestGlobalConf;
import com.meowlomo.jenkins.scm_httpclient.ScmExcution;
import com.meowlomo.jenkins.scm_httpclient.auth.Authenticator;
import com.meowlomo.jenkins.scm_httpclient.auth.BasicDigestAuthentication;
import com.meowlomo.jenkins.scm_httpclient.constant.HttpMode;
import com.meowlomo.jenkins.scm_httpclient.constant.MimeType;
import com.meowlomo.jenkins.scm_httpclient.model.ResponseContentSupplier;
import com.meowlomo.jenkins.scm_httpclient.util.HttpClientUtil;
import com.meowlomo.jenkins.scm_httpclient.util.HttpRequestNameValuePair;
import com.meowlomo.jenkins.scm_httpclient.util.RequestAction;
import com.meowlomo.jenkins.scm_httpclient.util.UnescapeUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ScmHttpClient
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    Map<String, String> variables = new HashMap<String, String>();
    static HttpRequestGlobalConf hgc = new HttpRequestGlobalConf();
    private boolean saveAffectedPath;
    private boolean saveJobBuildMessage;
    private String regexString = "";
    private String addScmPath;
    private boolean sendHttpRequest;
    @Nonnull
    private String url;
    private String credentialId;
    private HttpMode httpMode;
    private MimeType contentType;
    private String validResponseCodes;
    private String validResponseContent;
    private String requestBody;

    @DataBoundConstructor
    public ScmHttpClient(String url) {
        this.url = url;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild build = (AbstractBuild)run;
        EnvVars envVars = build.getEnvironment(listener);
        PrintStream logger = listener.getLogger();
        new ScmExcution(build, envVars, logger, this.saveAffectedPath, this.saveJobBuildMessage, this.regexString, this.addScmPath, this.variables);
        if (this.sendHttpRequest) {
            HttpRequestExcution httpRequestExcution = new HttpRequestExcution();
            httpRequestExcution.from(this, envVars, run, listener);
            httpRequestExcution.request(this.getLoginToken(this.url, this.credentialId));
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    List<HttpRequestNameValuePair> resolveHeaders(EnvVars envVars) {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        if (this.contentType != null && this.contentType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Content-type", this.contentType.getContentType().toString()));
        }
        return headers;
    }

    String getLoginToken(String url, String authentication) {
        StandardUsernamePasswordCredentials credential;
        Authenticator auth;
        String access_token = "";
        if (authentication != null && !authentication.isEmpty() && (auth = hgc.getAuthentication(authentication)) == null && (credential = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)authentication))) != null) {
            String userName = credential.getUsername();
            String password = credential.getPassword().getPlainText();
            ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
            headers.add(new HttpRequestNameValuePair("content-type", "application/x-www-form-urlencoded"));
            String body = "email=" + userName + "&password=" + password;
            try {
                HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                CloseableHttpClient httpclient = clientBuilder.build();
                HttpClientUtil clientUtil = new HttpClientUtil();
                HttpRequestBase httpRequestBase = clientUtil.createRequestBase(new RequestAction(new URL(url), HttpMode.POST, body, null, headers));
                String authUrl = "http://" + httpRequestBase.getURI().getHost() + "/api/auth/login";
                HttpRequestBase hrb = clientUtil.createRequestBase(new RequestAction(new URL(authUrl), HttpMode.POST, body, null, headers));
                BasicHttpContext context = new BasicHttpContext();
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)hrb, (HttpContext)context);
                ResponseContentSupplier responseContentSupplier = new ResponseContentSupplier((HttpResponse)response);
                if (responseContentSupplier.getStatus() == 200) {
                    String content = responseContentSupplier.getContent();
                    access_token = (String)JSON.parseObject((String)content).get((Object)"access_token");
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return access_token;
    }

    public String resolveBody() {
        return UnescapeUtil.replaceSprcialString(this.requestBody, this.variables);
    }

    public boolean isSendHttpRequest() {
        return this.sendHttpRequest;
    }

    @DataBoundSetter
    public void setSendHttpRequest(Boolean sendHttpRequest) {
        this.sendHttpRequest = sendHttpRequest;
    }

    public boolean isSaveAffectedPath() {
        return this.saveAffectedPath;
    }

    @DataBoundSetter
    public void setSaveAffectedPath(Boolean saveAffectedPath) {
        this.saveAffectedPath = saveAffectedPath;
    }

    public boolean isSaveJobBuildMessage() {
        return this.saveJobBuildMessage;
    }

    @DataBoundSetter
    public void setSaveJobBuildMessage(Boolean saveJobBuildMessage) {
        this.saveJobBuildMessage = saveJobBuildMessage;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public HttpMode getHttpMode() {
        return this.httpMode;
    }

    @DataBoundSetter
    public void setHttpMode(HttpMode httpMode) {
        this.httpMode = httpMode;
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    @DataBoundSetter
    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public String getRegexString() {
        return this.regexString;
    }

    @DataBoundSetter
    public void setRegexString(String regexString) {
        this.regexString = regexString;
    }

    public String getAddScmPath() {
        return this.addScmPath;
    }

    @DataBoundSetter
    public void setAddScmPath(String addScmPath) {
        this.addScmPath = addScmPath;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    @DataBoundSetter
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    @Nonnull
    public String getValidResponseCodes() {
        return this.validResponseCodes;
    }

    @DataBoundSetter
    public void setValidResponseCodes(String validResponseCodes) {
        this.validResponseCodes = validResponseCodes;
    }

    public String getValidResponseContent() {
        return this.validResponseContent;
    }

    @DataBoundSetter
    public void setValidResponseContent(String validResponseContent) {
        this.validResponseContent = validResponseContent;
    }

    @Extension
    @Symbol(value={"scmHttpClient"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String validResponseCodes = "100:399";

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "SCM HttpClient";
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item project, @QueryParameter String url) {
            return DescriptorImpl.fillCredentialIdItems(project, url);
        }

        public static ListBoxModel fillCredentialIdItems(Item project, String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
            for (BasicDigestAuthentication basic : hgc.getBasicDigestAuthentications()) {
                options.add(new ListBoxModel.Option("(deprecated - use Jenkins Credentials) " + basic.getKeyName(), basic.getKeyName()));
            }
            AbstractIdCredentialsListBoxModel items = new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build());
            items.addMissing(options);
            return items;
        }

        public ListBoxModel doFillHttpModeItems() {
            return HttpMode.getFillItems();
        }

        public ListBoxModel doFillContentTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public FormValidation doCheckCredentialId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            return DescriptorImpl.checkCredentialId(project, url, value);
        }

        public static FormValidation checkCredentialId(Item project, String url, String authentication) {
            StandardUsernamePasswordCredentials credential;
            Authenticator auth;
            if (url == null) {
                return FormValidation.ok();
            }
            if (authentication != null && !authentication.isEmpty() && (auth = hgc.getAuthentication(authentication)) == null && (credential = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)authentication))) != null) {
                String userName = credential.getUsername();
                String password = credential.getPassword().getPlainText();
                ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
                headers.add(new HttpRequestNameValuePair("content-type", "application/x-www-form-urlencoded"));
                String body = "email=" + userName + "&password=" + password;
                try {
                    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                    CloseableHttpClient httpclient = clientBuilder.build();
                    HttpClientUtil clientUtil = new HttpClientUtil();
                    HttpRequestBase httpRequestBase = clientUtil.createRequestBase(new RequestAction(new URL(url), HttpMode.POST, body, null, headers));
                    String authUrl = "http://" + httpRequestBase.getURI().getHost() + "/api/auth/login";
                    HttpRequestBase hrb = clientUtil.createRequestBase(new RequestAction(new URL(authUrl), HttpMode.POST, body, null, headers));
                    BasicHttpContext context = new BasicHttpContext();
                    CloseableHttpResponse response = httpclient.execute((HttpUriRequest)hrb, (HttpContext)context);
                    ResponseContentSupplier responseContentSupplier = new ResponseContentSupplier((HttpResponse)response);
                    if (responseContentSupplier.getStatus() != 200) {
                        return FormValidation.error((String)("Authentication failed for '" + authentication + "'.returned status code" + responseContentSupplier.getStatus()));
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Authentication failed for '" + authentication + "'." + e));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckValidResponseCodes(@QueryParameter String value) {
            return DescriptorImpl.checkValidResponseCodes(value);
        }

        public static FormValidation checkValidResponseCodes(String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                DescriptorImpl.parseToRange(value);
            }
            catch (IllegalArgumentException iae) {
                return FormValidation.error((String)("Response codes expected is wrong. " + iae.getMessage()));
            }
            return FormValidation.ok();
        }

        public static List<Range<Integer>> parseToRange(String value) {
            String[] codes;
            ArrayList<Range<Integer>> validRanges = new ArrayList<Range<Integer>>();
            for (String code : codes = value.split(",")) {
                Integer from;
                String[] fromTo = code.trim().split(":");
                Preconditions.checkArgument((fromTo.length <= 2 ? 1 : 0) != 0, (String)"Code %s should be an interval from:to or a single value", (Object[])new Object[]{code});
                try {
                    from = Integer.parseInt(fromTo[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid number " + fromTo[0]);
                }
                Integer to = from;
                if (fromTo.length != 1) {
                    try {
                        to = Integer.parseInt(fromTo[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Invalid number " + fromTo[1]);
                    }
                }
                Preconditions.checkArgument((from <= to ? 1 : 0) != 0, (String)"Interval %s should be FROM less than TO", (Object[])new Object[]{code});
                validRanges.add((Range<Integer>)Ranges.closed((Comparable)from, (Comparable)to));
            }
            return validRanges;
        }
    }
}

