/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient;

import com.meowlomo.jenkins.scm_httpclient.model.CommitInfo;
import com.meowlomo.jenkins.scm_httpclient.model.JobBuildMessage;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import java.io.PrintStream;
import java.util.Map;

public class ScmExcution {
    private PrintStream logger;
    private EnvVars envVars;

    public ScmExcution(AbstractBuild<?, ?> build, EnvVars envVars, PrintStream logger, boolean saveAffectedPath, boolean saveJobBuildMessage, String regexString, String addScmPath, Map<String, String> variables) {
        this.logger = logger;
        this.envVars = envVars;
        this.process(build, saveAffectedPath, saveJobBuildMessage, regexString, addScmPath, variables);
    }

    public void process(AbstractBuild<?, ?> build, boolean saveAffectedPath, boolean saveJobBuildMessage, String regexString, String addScmPath, Map<String, String> variables) {
        if (!build.getChangeSets().isEmpty()) {
            this.logger.println("the scm has changed...");
            CommitInfo commitInfo = new CommitInfo();
            if (saveAffectedPath) {
                commitInfo.doSaveAffectedPathsWork(regexString, addScmPath, build.getChangeSets(), this.logger, variables);
            }
            JobBuildMessage jobBuildMessage = new JobBuildMessage();
            if (saveJobBuildMessage) {
                jobBuildMessage.doSaveJobBuildMessageWork(this.envVars, commitInfo.getCommitInfos(build.getChangeSets()), variables);
            }
        } else {
            this.logger.println("the scm hasn't changed.");
        }
    }
}

