/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient;

import com.meowlomo.jenkins.scm_httpclient.auth.Authenticator;
import com.meowlomo.jenkins.scm_httpclient.auth.BasicDigestAuthentication;
import com.meowlomo.jenkins.scm_httpclient.util.HttpRequestNameValuePair;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.XStream2;
import java.util.ArrayList;
import java.util.List;

public class HttpRequestGlobalConf {
    private List<BasicDigestAuthentication> basicDigestAuthentications = new ArrayList<BasicDigestAuthentication>();
    private static final XStream2 XSTREAM2 = new XStream2();

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
        XSTREAM2.addCompatibilityAlias("jenkins.plugins.http_request.HttpRequest$DescriptorImpl", HttpRequestGlobalConf.class);
        XSTREAM2.addCompatibilityAlias("jenkins.plugins.http_request.util.NameValuePair", HttpRequestNameValuePair.class);
    }

    public List<BasicDigestAuthentication> getBasicDigestAuthentications() {
        return this.basicDigestAuthentications;
    }

    public void setBasicDigestAuthentications(List<BasicDigestAuthentication> basicDigestAuthentications) {
        this.basicDigestAuthentications = basicDigestAuthentications;
    }

    public List<Authenticator> getAuthentications() {
        ArrayList<Authenticator> list = new ArrayList<Authenticator>();
        list.addAll(this.basicDigestAuthentications);
        return list;
    }

    public Authenticator getAuthentication(String keyName) {
        for (Authenticator authenticator : this.getAuthentications()) {
            if (!authenticator.getKeyName().equals(keyName)) continue;
            return authenticator;
        }
        return null;
    }
}

