/*
 * Decompiled with CFR 0.152.
 */
package com.meowlomo.jenkins.scm_httpclient;

import com.google.common.collect.Range;
import com.meowlomo.jenkins.scm_httpclient.ScmHttpClient;
import com.meowlomo.jenkins.scm_httpclient.constant.HttpMode;
import com.meowlomo.jenkins.scm_httpclient.constant.MimeType;
import com.meowlomo.jenkins.scm_httpclient.model.ResponseContentSupplier;
import com.meowlomo.jenkins.scm_httpclient.util.HttpClientUtil;
import com.meowlomo.jenkins.scm_httpclient.util.HttpRequestNameValuePair;
import com.meowlomo.jenkins.scm_httpclient.util.RequestAction;
import com.meowlomo.jenkins.scm_httpclient.util.UnescapeUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpRequestExcution {
    private String url;
    private String credentialId;
    private HttpMode httpMode;
    private String body;
    private MimeType contentType;
    private List<HttpRequestNameValuePair> headers;
    private String validResponseCodes;
    private String validResponseContent;
    private transient PrintStream localLogger;

    public HttpRequestExcution() {
    }

    private HttpRequestExcution(String url, String credentialId, HttpMode httpMode, String body, MimeType contentType, List<HttpRequestNameValuePair> headers, String validResponseCodes, String validResponseContent) {
        this.url = url;
        this.credentialId = credentialId;
        this.httpMode = httpMode;
        this.body = body;
        this.contentType = contentType;
        this.headers = headers;
        this.validResponseCodes = validResponseCodes;
        this.validResponseContent = validResponseContent != null ? validResponseContent : "";
    }

    public HttpRequestExcution from(ScmHttpClient shc, EnvVars envVars, Run<?, ?> run, TaskListener taskListener) {
        this.url = shc.getUrl();
        this.credentialId = shc.getCredentialId();
        this.httpMode = shc.getHttpMode();
        this.body = this.resolveBody(shc.getRequestBody(), shc.variables);
        this.contentType = shc.getContentType();
        this.validResponseCodes = shc.getValidResponseCodes();
        this.validResponseContent = shc.getValidResponseContent();
        List<HttpRequestNameValuePair> headers = this.resolveHeaders(envVars);
        HttpRequestExcution httpExcusion = new HttpRequestExcution(this.url, this.credentialId, this.httpMode, this.body, this.contentType, headers, this.validResponseCodes, this.validResponseContent);
        this.headers = headers;
        this.localLogger = taskListener.getLogger();
        return httpExcusion;
    }

    public ResponseContentSupplier request(String access_token) {
        try {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            CloseableHttpClient httpclient = clientBuilder.build();
            HttpClientUtil clientUtil = new HttpClientUtil();
            this.localLogger.println("URL:" + this.url);
            this.localLogger.println("HttpMethod:" + (Object)((Object)this.httpMode));
            if (!this.body.equals("")) {
                this.localLogger.println("RequestBody:" + this.body);
            }
            if (!access_token.isEmpty()) {
                this.headers.add(new HttpRequestNameValuePair("Authorization", "Bearer " + access_token));
            }
            HttpRequestBase httpRequestBase = clientUtil.createRequestBase(new RequestAction(new URL(this.url), this.httpMode, this.body, null, this.headers));
            BasicHttpContext context = new BasicHttpContext();
            ResponseContentSupplier response = this.executeRequest(httpclient, clientUtil, httpRequestBase, (HttpContext)context);
            this.processResponse(response);
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    List<HttpRequestNameValuePair> resolveHeaders(EnvVars envVars) {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        if (this.contentType != null && this.contentType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Content-type", this.contentType.getContentType().toString()));
        }
        return headers;
    }

    private String resolveBody(String requestBody, Map<String, String> variables) {
        return UnescapeUtil.replaceSprcialString(requestBody, variables);
    }

    private ResponseContentSupplier executeRequest(CloseableHttpClient httpclient, HttpClientUtil clientUtil, HttpRequestBase httpRequestBase, HttpContext context) throws IOException, InterruptedException {
        ResponseContentSupplier responseContentSupplier;
        try {
            HttpResponse response = clientUtil.execute((HttpClient)httpclient, context, httpRequestBase, this.localLogger);
            responseContentSupplier = new ResponseContentSupplier(response);
        }
        catch (UnknownHostException uhe) {
            this.localLogger.println("Treating UnknownHostException(" + uhe.getMessage() + ") as 404 Not Found");
            responseContentSupplier = new ResponseContentSupplier("UnknownHostException as 404 Not Found", 404);
        }
        catch (ConnectException | SocketTimeoutException ce) {
            this.localLogger.println("Treating " + ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout");
            responseContentSupplier = new ResponseContentSupplier(ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout", 408);
        }
        return responseContentSupplier;
    }

    private void processResponse(ResponseContentSupplier response) throws IOException, InterruptedException {
        this.responseCodeIsValid(response);
    }

    private void responseCodeIsValid(ResponseContentSupplier response) throws AbortException {
        List<Range<Integer>> ranges = ScmHttpClient.DescriptorImpl.parseToRange(this.validResponseCodes);
        for (Range<Integer> range : ranges) {
            if (!range.contains((Comparable)Integer.valueOf(response.getStatus()))) continue;
            this.localLogger.println("Success code from " + range);
            return;
        }
        throw new AbortException("Fail: the returned code " + response.getStatus() + " is not in the accepted range: " + ranges);
    }
}

