/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.webservices.interceptors;

import android.util.Log;
import com.meniga.sdk.helpers.LogLevel;
import com.meniga.sdk.helpers.LogType;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class MenigaHttpLogger
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String REQUEST_START = " Request Start ----> ";
    private static final String RESPONSE_START = "Response Start ----> ";
    private static final String REQUEST_END = "<---- Request End ";
    private static final String RESPONSE_END = "<---- Response End ";
    private static final String BODY = "BODY:";
    private static final String NO_BODY = "<NO BODY>";
    private String tag = "Meniga";
    private final LogLevel logLevel;
    private final LogType logType;

    public MenigaHttpLogger(String tag, LogLevel logLevel, LogType logType) {
        if (tag != null && tag.length() > 0) {
            this.tag = tag;
        }
        this.logLevel = logLevel;
        this.logType = logType;
    }

    private String getHeaderString(String name, String value) {
        return "HEADER: Key=" + name + ", Value=" + value;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        if (this.logLevel == LogLevel.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = this.logType == LogType.BODY_ONLY || this.logType == LogType.BODY_AND_HEADERS;
        boolean logHeaders = this.logType == LogType.HEADERS_ONLY || this.logType == LogType.BODY_AND_HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        String reqUrl = request.url().toString();
        String requestStartMessage = request.method() + REQUEST_START + reqUrl;
        if (!logHeaders && hasRequestBody) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.log(requestStartMessage);
        if (logHeaders) {
            if (hasRequestBody) {
                if (requestBody.contentType() != null) {
                    this.log(this.getHeaderString("Content-Type", requestBody.contentType().toString()));
                }
                if (requestBody.contentLength() != -1L) {
                    this.log(this.getHeaderString("Content-Length", Long.toString(requestBody.contentLength())));
                }
            }
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                String name = headers.name(i);
                if ("Content-Type".equalsIgnoreCase(name) || "Content-Length".equalsIgnoreCase(name)) continue;
                this.log(this.getHeaderString(name, headers.value(i)));
            }
        }
        if (!logBody) {
            this.log(REQUEST_END + request.method());
        } else if (!hasRequestBody) {
            this.log(BODY);
            this.log(NO_BODY);
        } else if (this.bodyEncoded(request.headers())) {
            this.log(REQUEST_END + request.method() + " (encoded body omitted)");
        } else {
            Buffer buffer = new Buffer();
            try {
                requestBody.writeTo((BufferedSink)buffer);
            }
            catch (ConcurrentModificationException ex) {
                this.log("Error logging body - got ConcurrentModificationException");
            }
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            this.log(BODY);
            if (MenigaHttpLogger.isPlaintext(buffer)) {
                this.log(buffer.readString(charset));
                this.log(REQUEST_END + request.method() + " (" + requestBody.contentLength() + "-byte body)");
            } else {
                this.log("<" + requestBody.contentLength() + "-BYTE BINARY BODY OMITTED");
                this.log(REQUEST_END + request.method());
            }
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.log("<---- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        this.log(RESPONSE_START + reqUrl);
        this.log("(" + tookMs + "ms" + (!logHeaders ? ", " + bodySize + " body" : "") + ")");
        if (logHeaders) {
            Headers headers = response.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                this.log(this.getHeaderString(headers.name(i), headers.value(i)));
            }
        }
        if (!logBody) {
            this.log(RESPONSE_END);
        } else if (!HttpHeaders.hasBody((Response)response)) {
            this.log(BODY);
            this.log(NO_BODY);
            this.log(RESPONSE_END);
        } else if (this.bodyEncoded(response.headers())) {
            this.log(BODY);
            this.log("<ENCODED BODY OMITTED>");
            this.log(RESPONSE_END);
        } else {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.log(BODY);
                    this.log("<ERROR DECODING BODY; CHARSET IS LIKELY MALFORMED.>");
                    this.log(RESPONSE_END);
                    return response;
                }
            }
            if (!MenigaHttpLogger.isPlaintext(buffer)) {
                this.log(BODY);
                this.log("<BINARY " + buffer.size() + "-BYTE BODY OMITTED>");
                this.log(RESPONSE_END);
                return response;
            }
            if (contentLength != 0L) {
                this.log("BODY: (" + buffer.size() + "-byte body)");
                this.log(buffer.clone().readString(charset));
            }
            this.log(RESPONSE_END);
        }
        return response;
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    static boolean isPlaintext(Buffer buffer) throws EOFException {
        Buffer prefix = new Buffer();
        long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
        buffer.copyTo(prefix, 0L, byteCount);
        for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
            if (!Character.isISOControl(prefix.readUtf8CodePoint())) continue;
            return false;
        }
        return true;
    }

    private void log(String msg) {
        if (msg == null) {
            return;
        }
        switch (this.logLevel) {
            case DEBUG: {
                Log.d((String)this.tag, (String)msg);
                break;
            }
            case NONE: {
                return;
            }
            case WARN: {
                Log.w((String)this.tag, (String)msg);
                break;
            }
            case ERROR: {
                Log.e((String)this.tag, (String)msg);
                break;
            }
            case INFO: {
                Log.i((String)this.tag, (String)msg);
                break;
            }
            default: {
                Log.v((String)this.tag, (String)msg);
            }
        }
    }
}

