/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.webservices;

import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.adapters.TaskAdapter;
import com.meniga.sdk.helpers.KeyVal;
import com.meniga.sdk.helpers.Objects;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.interfaces.PersistenceProvider;
import com.meniga.sdk.models.budget.MenigaBudget;
import com.meniga.sdk.models.budget.MenigaBudgetEntry;
import com.meniga.sdk.models.budget.MenigaBudgetRule;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.models.categories.MenigaUserCategory;
import com.meniga.sdk.models.challenges.MenigaChallenge;
import com.meniga.sdk.models.feed.MenigaFeed;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.feed.MenigaScheduledEvent;
import com.meniga.sdk.models.merchants.MenigaMerchant;
import com.meniga.sdk.models.merchants.MenigaTopMerchant;
import com.meniga.sdk.models.networth.MenigaNetWorth;
import com.meniga.sdk.models.networth.MenigaNetWorthBalance;
import com.meniga.sdk.models.offers.MenigaOffer;
import com.meniga.sdk.models.offers.MenigaOfferMerchantLocationPage;
import com.meniga.sdk.models.offers.MenigaOfferPage;
import com.meniga.sdk.models.offers.MenigaSimilarBrandSpendingDetails;
import com.meniga.sdk.models.offers.redemptions.MenigaRedemptions;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaReimbursementAccount;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaReimbursementAccountPage;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaReimbursementAccountTypePage;
import com.meniga.sdk.models.organizations.MenigaOrganization;
import com.meniga.sdk.models.organizations.MenigaRealmAccount;
import com.meniga.sdk.models.organizations.MenigaRealmAuthResponse;
import com.meniga.sdk.models.serverpublic.MenigaPublicSettings;
import com.meniga.sdk.models.sync.MenigaSync;
import com.meniga.sdk.models.sync.MenigaSyncStatus;
import com.meniga.sdk.models.terms.MenigaTermType;
import com.meniga.sdk.models.terms.MenigaTerms;
import com.meniga.sdk.models.transactions.MenigaComment;
import com.meniga.sdk.models.transactions.MenigaTag;
import com.meniga.sdk.models.transactions.MenigaTransaction;
import com.meniga.sdk.models.transactions.MenigaTransactionPage;
import com.meniga.sdk.models.transactions.MenigaTransactionRule;
import com.meniga.sdk.models.transactions.MenigaTransactionSeries;
import com.meniga.sdk.models.transactions.MenigaTransactionUpdate;
import com.meniga.sdk.models.upcoming.MenigaUpcoming;
import com.meniga.sdk.models.user.MenigaUser;
import com.meniga.sdk.models.user.MenigaUserMetaData;
import com.meniga.sdk.models.user.MenigaUserProfile;
import com.meniga.sdk.models.userevents.MenigaUserEvent;
import com.meniga.sdk.webservices.HttpMethod;
import com.meniga.sdk.webservices.MenigaAPI;
import com.meniga.sdk.webservices.Service;
import com.meniga.sdk.webservices.account.Account;
import com.meniga.sdk.webservices.account.AccountAuthorizationType;
import com.meniga.sdk.webservices.account.AccountBalanceHistory;
import com.meniga.sdk.webservices.account.AccountMetaData;
import com.meniga.sdk.webservices.account.AccountService;
import com.meniga.sdk.webservices.account.AccountType;
import com.meniga.sdk.webservices.account.AccountTypeCategory;
import com.meniga.sdk.webservices.account.UpdateAccount;
import com.meniga.sdk.webservices.account.UpdateAccountMetadata;
import com.meniga.sdk.webservices.budget.BudgetService;
import com.meniga.sdk.webservices.budget.CreateBudget;
import com.meniga.sdk.webservices.budget.CreateBudgetEntries;
import com.meniga.sdk.webservices.budget.CreateBudgetRules;
import com.meniga.sdk.webservices.budget.GetBudget;
import com.meniga.sdk.webservices.budget.GetBudgetEntries;
import com.meniga.sdk.webservices.budget.GetBudgetEntryById;
import com.meniga.sdk.webservices.budget.GetBudgetRules;
import com.meniga.sdk.webservices.budget.GetBudgets;
import com.meniga.sdk.webservices.budget.UpdateBudget;
import com.meniga.sdk.webservices.budget.UpdateBudgetEntry;
import com.meniga.sdk.webservices.challenge.AcceptChallenge;
import com.meniga.sdk.webservices.challenge.ChallengeService;
import com.meniga.sdk.webservices.challenge.CreateChallenge;
import com.meniga.sdk.webservices.challenge.DeleteChallenge;
import com.meniga.sdk.webservices.challenge.GetChallenge;
import com.meniga.sdk.webservices.challenge.GetChallengeHistory;
import com.meniga.sdk.webservices.challenge.GetChallenges;
import com.meniga.sdk.webservices.challenge.UpdateChallenge;
import com.meniga.sdk.webservices.eventtracking.EventTrackingService;
import com.meniga.sdk.webservices.eventtracking.TrackEvent;
import com.meniga.sdk.webservices.offers.OffersService;
import com.meniga.sdk.webservices.requests.AcceptOffersTermsAndConditions;
import com.meniga.sdk.webservices.requests.AcceptTerms;
import com.meniga.sdk.webservices.requests.ActivateOfferById;
import com.meniga.sdk.webservices.requests.ActivateOfferByToken;
import com.meniga.sdk.webservices.requests.AddComments;
import com.meniga.sdk.webservices.requests.AddRealmAccountsToMeniga;
import com.meniga.sdk.webservices.requests.CreateComment;
import com.meniga.sdk.webservices.requests.CreateNetWorthAccount;
import com.meniga.sdk.webservices.requests.CreateNetWorthBalanceHistory;
import com.meniga.sdk.webservices.requests.CreateReimbursementAccount;
import com.meniga.sdk.webservices.requests.CreateTransaction;
import com.meniga.sdk.webservices.requests.CreateTransactionRule;
import com.meniga.sdk.webservices.requests.CreateUpcoming;
import com.meniga.sdk.webservices.requests.CreateUserCategory;
import com.meniga.sdk.webservices.requests.DeclineOffer;
import com.meniga.sdk.webservices.requests.DeclineTerms;
import com.meniga.sdk.webservices.requests.DeleteAccount;
import com.meniga.sdk.webservices.requests.DeleteComment;
import com.meniga.sdk.webservices.requests.DeleteNetWorthAccount;
import com.meniga.sdk.webservices.requests.DeleteNetWorthBalance;
import com.meniga.sdk.webservices.requests.DeleteTransaction;
import com.meniga.sdk.webservices.requests.DeleteTransactionRule;
import com.meniga.sdk.webservices.requests.DeleteTransactions;
import com.meniga.sdk.webservices.requests.DeleteUpcoming;
import com.meniga.sdk.webservices.requests.DeleteUpcomingSeries;
import com.meniga.sdk.webservices.requests.DeleteUserCategory;
import com.meniga.sdk.webservices.requests.DisableOffers;
import com.meniga.sdk.webservices.requests.EnableOffers;
import com.meniga.sdk.webservices.requests.ForgotPassword;
import com.meniga.sdk.webservices.requests.GetAccount;
import com.meniga.sdk.webservices.requests.GetAccountBalanceHistory;
import com.meniga.sdk.webservices.requests.GetAccountMetadata;
import com.meniga.sdk.webservices.requests.GetAccountMetadataKeyVal;
import com.meniga.sdk.webservices.requests.GetAccountTypes;
import com.meniga.sdk.webservices.requests.GetAccounts;
import com.meniga.sdk.webservices.requests.GetAuthorizationTypes;
import com.meniga.sdk.webservices.requests.GetCategories;
import com.meniga.sdk.webservices.requests.GetCategoryById;
import com.meniga.sdk.webservices.requests.GetEvent;
import com.meniga.sdk.webservices.requests.GetFeed;
import com.meniga.sdk.webservices.requests.GetMerchant;
import com.meniga.sdk.webservices.requests.GetMerchantLocationsByOfferId;
import com.meniga.sdk.webservices.requests.GetMerchants;
import com.meniga.sdk.webservices.requests.GetNetWorth;
import com.meniga.sdk.webservices.requests.GetNetWorthFirstBalanceEntry;
import com.meniga.sdk.webservices.requests.GetNetWorthTypes;
import com.meniga.sdk.webservices.requests.GetNetWorths;
import com.meniga.sdk.webservices.requests.GetOfferById;
import com.meniga.sdk.webservices.requests.GetOfferByToken;
import com.meniga.sdk.webservices.requests.GetOffers;
import com.meniga.sdk.webservices.requests.GetOrganizations;
import com.meniga.sdk.webservices.requests.GetPublicSettings;
import com.meniga.sdk.webservices.requests.GetRealmAccounts;
import com.meniga.sdk.webservices.requests.GetRealmAuthMethod;
import com.meniga.sdk.webservices.requests.GetRedemptions;
import com.meniga.sdk.webservices.requests.GetRedemptionsByOfferId;
import com.meniga.sdk.webservices.requests.GetReimbursementAccountById;
import com.meniga.sdk.webservices.requests.GetReimbursementAccountTypes;
import com.meniga.sdk.webservices.requests.GetReimbursementAccounts;
import com.meniga.sdk.webservices.requests.GetScheduledEvent;
import com.meniga.sdk.webservices.requests.GetSimilarBrandSpendingDetails;
import com.meniga.sdk.webservices.requests.GetSplitTransactions;
import com.meniga.sdk.webservices.requests.GetSync;
import com.meniga.sdk.webservices.requests.GetTag;
import com.meniga.sdk.webservices.requests.GetTags;
import com.meniga.sdk.webservices.requests.GetTerm;
import com.meniga.sdk.webservices.requests.GetTermTypes;
import com.meniga.sdk.webservices.requests.GetTerms;
import com.meniga.sdk.webservices.requests.GetTopMerchants;
import com.meniga.sdk.webservices.requests.GetTransaction;
import com.meniga.sdk.webservices.requests.GetTransactionRule;
import com.meniga.sdk.webservices.requests.GetTransactionRules;
import com.meniga.sdk.webservices.requests.GetTransactionSeries;
import com.meniga.sdk.webservices.requests.GetTransactions;
import com.meniga.sdk.webservices.requests.GetUpcoming;
import com.meniga.sdk.webservices.requests.GetUpcomingById;
import com.meniga.sdk.webservices.requests.GetUserEvents;
import com.meniga.sdk.webservices.requests.GetUserMetaData;
import com.meniga.sdk.webservices.requests.GetUserProfile;
import com.meniga.sdk.webservices.requests.GetUsers;
import com.meniga.sdk.webservices.requests.MarkOfferAsSeen;
import com.meniga.sdk.webservices.requests.QueryRequestObject;
import com.meniga.sdk.webservices.requests.RecategorizeTransactions;
import com.meniga.sdk.webservices.requests.ReconcileUpcoming;
import com.meniga.sdk.webservices.requests.RegisterUser;
import com.meniga.sdk.webservices.requests.ResetPasswordWithToken;
import com.meniga.sdk.webservices.requests.SaveMetaData;
import com.meniga.sdk.webservices.requests.SetCulture;
import com.meniga.sdk.webservices.requests.SetSubscription;
import com.meniga.sdk.webservices.requests.SetSubscriptionSettings;
import com.meniga.sdk.webservices.requests.SplitTransaction;
import com.meniga.sdk.webservices.requests.StartRealmSync;
import com.meniga.sdk.webservices.requests.StartSync;
import com.meniga.sdk.webservices.requests.UpdateComment;
import com.meniga.sdk.webservices.requests.UpdateHistoryBalance;
import com.meniga.sdk.webservices.requests.UpdateSplits;
import com.meniga.sdk.webservices.requests.UpdateTransaction;
import com.meniga.sdk.webservices.requests.UpdateTransactionRule;
import com.meniga.sdk.webservices.requests.UpdateTransactions;
import com.meniga.sdk.webservices.requests.UpdateUpcoming;
import com.meniga.sdk.webservices.requests.UpdateUserCategory;
import com.meniga.sdk.webservices.requests.UpdatedNetWorthAccount;
import com.meniga.sdk.webservices.user.ChangePassword;
import com.meniga.sdk.webservices.user.UpdateEmail;
import com.meniga.sdk.webservices.user.UsersService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PersistenceDelegate {
    private Map<Service, ?> services = Collections.emptyMap();
    private PersistenceProvider provider;

    public void setApis(Map<Service, ?> clients) {
        this.services = Collections.unmodifiableMap(Objects.requireNonNull(clients));
    }

    public void setProvider(PersistenceProvider provider) {
        this.provider = provider;
    }

    private <E> Result<E> persist(final QueryRequestObject key, Call<E> call) {
        return MenigaSDK.getMenigaSettings().getTaskAdapter().adapt(call, new Callback<E>(){

            public void onResponse(Call<E> call, Response<E> response) {
                if (!call.isCanceled() && response.isSuccessful()) {
                    PersistenceDelegate.this.provider.save(key, response.body());
                }
            }

            public void onFailure(Call<E> call, Throwable t) {
            }
        });
    }

    private <E> Result<E> call(Call<E> call) {
        return MenigaSDK.getMenigaSettings().getTaskAdapter().adapt(call, null);
    }

    private <T> Result<T> createTask(Object value) {
        return MenigaSDK.getMenigaSettings().getTaskAdapter().adapt(value);
    }

    public Result<MenigaMerchant> getMerchant(GetMerchant req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.MERCHANTS).getMerchant(req.id));
    }

    public Result<List<MenigaMerchant>> getMerchants(GetMerchants req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.MERCHANTS).getMerchants(req.toQueryMap()));
    }

    public Result<List<MenigaTopMerchant>> getTopMerchants(GetTopMerchants req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.MERCHANTS).getTopMerchants(req));
    }

    public Result<List<Account>> getAccounts(GetAccounts req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccounts(req.toQueryMap()));
    }

    public Result<Account> getAccount(GetAccount req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccount(req.accountId));
    }

    public Result<List<AccountType>> getAccountTypes(GetAccountTypes req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccountTypes());
    }

    public Result<List<AccountAuthorizationType>> getAccountAuthorizationTypes(GetAuthorizationTypes req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccountAuthorizationTypes());
    }

    public Result<List<AccountTypeCategory>> getAccountCategories() {
        return this.call(this.getService(AccountService.class).getAccountCategories());
    }

    public Result<List<AccountMetaData>> getAccountMetadata(GetAccountMetadata req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccountMetadata(req.id));
    }

    public Result<AccountMetaData> updateAccountMetadata(long accountId, UpdateAccountMetadata req) {
        return this.persist(req, this.getService(AccountService.class).updateAccountMetadata(accountId, req));
    }

    public Result<AccountMetaData> getAccountMetadataKeyVal(GetAccountMetadataKeyVal req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccountMetadataKeyVal(req.id, req.name));
    }

    public Result<List<AccountBalanceHistory>> getAccountBalanceHistory(GetAccountBalanceHistory req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(AccountService.class).getAccountBalanceHistory(req.id, req.toQueryMap()));
    }

    public Result<Void> updateAccount(UpdateAccount req) {
        return this.persist(req, this.getService(AccountService.class).updateAccount(req.getId(), req));
    }

    public Result<Void> deleteAccount(DeleteAccount req) {
        return this.persist(req, this.getService(AccountService.class).deleteAccount(req.accountId));
    }

    public Result<List<MenigaTag>> getTags() {
        GetTags req = new GetTags();
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TAGS).getTags());
    }

    public Result<MenigaTag> getTag(GetTag req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TAGS).getTag(req.id));
    }

    public Result<MenigaTransactionPage> getTransactions(GetTransactions req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).getTransactions(req.toQueryMap()));
    }

    public Result<MenigaTransaction> createTransaction(CreateTransaction req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).createTransaction(req));
    }

    public Result<MenigaTransaction> getTransaction(GetTransaction req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).getTransaction(req.id));
    }

    public Result<MenigaTransactionUpdate> updateTransaction(UpdateTransaction req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).updateTransaction(req.transactionId, req));
    }

    public Result<MenigaTransactionUpdate> updateTransactions(UpdateTransactions req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).updateTransactions(req.toQueryMap(), req));
    }

    public Result<MenigaSync> startSync(StartSync req) {
        TaskAdapter taskAdapter = MenigaSDK.getMenigaSettings().getTaskAdapter();
        return taskAdapter.adapt(this.getClient(Service.SYNC).startSync(req), null);
    }

    public Result<MenigaSync> startRealmSync(StartRealmSync req) {
        TaskAdapter taskAdapter = MenigaSDK.getMenigaSettings().getTaskAdapter();
        return taskAdapter.adapt(this.getClient(Service.SYNC).startRealmSync(req, req.realmUserId), null);
    }

    public Result<MenigaSyncStatus> getSyncStatus() {
        TaskAdapter taskAdapter = MenigaSDK.getMenigaSettings().getTaskAdapter();
        return taskAdapter.adapt(this.getClient(Service.SYNC).getSyncStatus(), null);
    }

    public Result<MenigaRealmAuthResponse> performBankAuthenticationStep(GetRealmAuthMethod req) {
        return this.persist(req, this.getClient(Service.SYNC).getRealmAuthMethod(req.id, req));
    }

    public Result<List<MenigaRealmAccount>> getRealmAccounts(GetRealmAccounts req) {
        return this.persist(req, this.getClient(Service.SYNC).getRealmAccounts(req.realmUserId, req.toQueryMap()));
    }

    public Result<List<MenigaRealmAccount>> addRealmAccountsToMeniga(AddRealmAccountsToMeniga req) {
        return this.persist(req, this.getClient(Service.SYNC).addRealmAccountsToMeniga(req.realmUserId, req.realmAccounts, req.toQueryMap()));
    }

    public Result<List<MenigaUserEvent>> getUserEvents() {
        GetUserEvents req = new GetUserEvents();
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.USER_EVENTS).getUserEvents());
    }

    public Result<Void> setSubscription(SetSubscription req) {
        return this.persist(req, this.getClient(Service.USER_EVENTS).setSubscription(req));
    }

    public Result<Void> updateSettings(SetSubscriptionSettings req) {
        return this.persist(req, this.getClient(Service.USER_EVENTS).updateSettings(req));
    }

    public Result<MenigaSync> getSync(GetSync req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.SYNC).getSync(req.syncHistoryId));
    }

    public Result<List<MenigaTransaction>> fetchSplitTransactions(GetSplitTransactions req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).fetchSplitTransactions(req.parentId));
    }

    public Result<List<MenigaTransaction>> splitTransaction(SplitTransaction req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).splitTransaction(req.transactionId, req));
    }

    public Result<List<MenigaTransaction>> updateSplits(long id, List<UpdateSplits> req) {
        return this.persist(req.get(0), this.getClient(Service.TRANSACTIONS).updateSplits(id, req));
    }

    public Result<Void> deleteTransaction(DeleteTransaction req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).deleteTransaction(req.transactionId));
    }

    public Result<Void> deleteTransactions(DeleteTransactions req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).deleteTransactions(req.toQueryMap()));
    }

    public Result<List<MenigaTransactionSeries>> getTransactionSeries(GetTransactionSeries req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).getTransactionSeries(req));
    }

    public Result<MenigaComment> createComment(CreateComment req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).createComment(req.transactionId, req));
    }

    public Result<Void> updateComment(UpdateComment req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).updateComment(req.transactionId, req.commentId, req));
    }

    public Result<Void> deleteComment(DeleteComment req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).deleteComment(req.transactionId, req.commentId));
    }

    public Result<List<MenigaComment>> addComments(AddComments req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).addComments(req));
    }

    public Result<Void> recategorizeTransactions(RecategorizeTransactions req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).recategorizeTransactions(req));
    }

    public Result<List<MenigaTransactionRule>> getTransactionRules(GetTransactionRules req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).getTransactionRules());
    }

    public Result<MenigaTransactionRule> createTransactionRule(CreateTransactionRule req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).createTransactionRule(req.toQueryMap(), req));
    }

    public Result<Void> deleteTransactionRule(DeleteTransactionRule req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).deleteTransactionRule(req.id));
    }

    public Result<MenigaTransactionRule> getTransactionRule(GetTransactionRule req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TRANSACTIONS).getTransactionRule(req.id));
    }

    public Result<Void> updateTransactionRule(UpdateTransactionRule req) {
        return this.persist(req, this.getClient(Service.TRANSACTIONS).updateTransactionRule(req.id, req.toQueryMap(), req));
    }

    public Result<MenigaFeed> getFeed(GetFeed req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.FEED).getFeed(req.toQueryMap()));
    }

    public Result<MenigaScheduledEvent> getScheduledEvent(GetScheduledEvent req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.FEED).getScheduledEvent(req.type, req.id));
    }

    public Result<MenigaFeedItem> getEvent(GetEvent req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.USER_EVENTS).getEvent(req.id));
    }

    public Result<List<MenigaCategory>> getCategories(GetCategories req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.CATEGORIES).getCategories(req.toQueryMap()));
    }

    public Result<MenigaCategory> getCategoryById(GetCategoryById req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.CATEGORIES).getCategoryById(req.categoryId, req.toQueryMap()));
    }

    public Result<MenigaUserCategory> createUserCategory(CreateUserCategory req) {
        return this.persist(req, this.getClient(Service.CATEGORIES).createUserCategory(req));
    }

    public Result<Void> deleteCategory(DeleteUserCategory req) {
        return this.persist(req, this.getClient(Service.CATEGORIES).deleteCategory(req.id, req.toQueryMap()));
    }

    public Result<Void> updateUserCategory(UpdateUserCategory req) {
        return this.persist(req, this.getClient(Service.CATEGORIES).updateUserCategory(req.id, req));
    }

    public Result<MenigaUserProfile> getUserProfile() {
        GetUserProfile req = new GetUserProfile();
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(UsersService.class).getUserProfile());
    }

    public Result<List<MenigaUser>> getUsers(GetUsers req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(UsersService.class).getUsers());
    }

    public Result<Void> setCulture(SetCulture req) {
        return this.persist(req, this.getService(UsersService.class).setCulture(req.toQueryMap()));
    }

    public Result<MenigaUser> registerUser(RegisterUser req) {
        return this.persist(req, this.getService(UsersService.class).registerUser(req));
    }

    public Result<Void> forgotPassword(ForgotPassword req) {
        return this.persist(req, this.getService(UsersService.class).forgotPassword(req));
    }

    public Result<List<MenigaUserMetaData>> getUserMetaData(GetUserMetaData req) {
        return this.persist(req, this.getService(UsersService.class).getUserMetaData(req.toQueryMap()));
    }

    public Result<MenigaUserMetaData> saveUserMetaData(SaveMetaData req) {
        return this.persist(req, this.getService(UsersService.class).saveUserMetaData(req));
    }

    public Result<Void> resetPassword(ResetPasswordWithToken req) {
        return this.persist(req, this.getService(UsersService.class).resetPassword(req));
    }

    public Result<Void> updateEmail(UpdateEmail req) {
        return this.persist(req, this.getService(UsersService.class).updateEmail(req));
    }

    public Result<Void> changePassword(ChangePassword req) {
        return this.persist(req, this.getService(UsersService.class).changePassword(req));
    }

    public Result<Void> deleteUser() {
        return this.call(this.getService(UsersService.class).delete());
    }

    public Result<MenigaOfferPage> getOffers(GetOffers req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getOffers(req.toQueryMap()));
    }

    public Result<MenigaOffer> getOfferByToken(GetOfferByToken req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getOffer(req.token));
    }

    public Result<MenigaOffer> getOfferById(GetOfferById req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getOffer(req.id));
    }

    public Result<MenigaRedemptions> getRedemptions(GetRedemptions req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getRedemptions(req.toQueryMap()));
    }

    public Result<Void> activateOfferById(ActivateOfferById req) {
        return this.persist(req, this.getService(OffersService.class).activateOfferById(req.id));
    }

    public Result<Void> activateOfferByToken(ActivateOfferByToken req) {
        return this.persist(req, this.getService(OffersService.class).activateOfferByToken(req.validationToken));
    }

    public Result<Void> declineOffer(DeclineOffer req) {
        return this.persist(req, this.getService(OffersService.class).declineOffer(req.id));
    }

    public Result<Void> acceptTermsAndConditions(AcceptOffersTermsAndConditions req) {
        return this.persist(req, this.getService(OffersService.class).acceptTermsAndConditions());
    }

    public Result<Void> enableOffers(EnableOffers req) {
        return this.persist(req, this.getService(OffersService.class).enableOffers());
    }

    public Result<Void> disableOffers(DisableOffers req) {
        return this.persist(req, this.getService(OffersService.class).disableOffers());
    }

    public Result<Void> markOfferAsSeen(MarkOfferAsSeen req) {
        return this.persist(req, this.getService(OffersService.class).markOfferAsSeen(req.id));
    }

    public Result<MenigaSimilarBrandSpendingDetails> getSimilarBrandSpendingDetails(GetSimilarBrandSpendingDetails req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getSimilarBrandSpeningDetails(req.id));
    }

    public Result<MenigaRedemptions> getRedemptionsByOfferId(GetRedemptionsByOfferId req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getRedemptionsByOfferId(req.offerId));
    }

    public Result<MenigaOfferMerchantLocationPage> getMerchantLocationsByOfferId(GetMerchantLocationsByOfferId req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(OffersService.class).getMerchantLocationByOfferId(req.offerId, req.toQueryMap()));
    }

    public Result<MenigaReimbursementAccount> addReimbursementAccount(CreateReimbursementAccount req) {
        return this.persist(req, this.getService(OffersService.class).addReimbursementAccount(req));
    }

    public Result<MenigaReimbursementAccountPage> getReimbursementAccounts(GetReimbursementAccounts req) {
        return this.persist(req, this.getService(OffersService.class).getReimbursementAccounts(req.toQueryMap()));
    }

    public Result<MenigaReimbursementAccountTypePage> getReimbursementAccountTypes(GetReimbursementAccountTypes req) {
        return this.persist(req, this.getService(OffersService.class).getReimbursementAccountTypes(req.toQueryMap()));
    }

    public Result<MenigaReimbursementAccount> getReimbursementAccountById(GetReimbursementAccountById req) {
        return this.persist(req, this.getService(OffersService.class).getReimbursementAccountById(req.id));
    }

    public Result<List<MenigaNetWorth>> getNetWorth(GetNetWorths req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.NET_WORTH).getNetWorths(req.toQueryMap()));
    }

    public Result<MenigaNetWorth> getNetWorth(GetNetWorth req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.NET_WORTH).getNetWorth(req.id));
    }

    public Result<Void> updateBalance(UpdateHistoryBalance req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).updateBalance(req.accountId, req.balanceId, req));
    }

    public Result<Void> deleteBalance(DeleteNetWorthBalance req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).deleteBalance(req.accountId, req.id));
    }

    public Result<MenigaNetWorthBalance> getNetWorthFirstBalanceEntry(GetNetWorthFirstBalanceEntry req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).getNetWorthFirstBalanceEntry(req.toQueryMap()));
    }

    public Result<MenigaNetWorth> createNetWorthAccount(CreateNetWorthAccount req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).createNetWorthAccount(req));
    }

    public Result<Void> deleteNetWorthAccount(DeleteNetWorthAccount req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).deleteNetWorthAccount(req.id));
    }

    public Result<Void> updateNetWorthAccount(UpdatedNetWorthAccount req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).updateNetWorthAccount(req.id, req));
    }

    public Result<MenigaNetWorthBalance> createNetWorthBalanceHistory(CreateNetWorthBalanceHistory req) {
        return this.persist(req, this.getClient(Service.NET_WORTH).createNetWorthBalanceHistory(req.id, req));
    }

    public Result<List<KeyVal<Long, String>>> getNetWorthTypes(GetNetWorthTypes req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.NET_WORTH).getNetWorthTypes());
    }

    public Result<List<MenigaUpcoming>> getUpcoming(GetUpcoming req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.UPCOMING).getUpcoming(req.toQueryMap()));
    }

    public Result<MenigaUpcoming> getUpcoming(GetUpcomingById req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.UPCOMING).getUpcoming(req.id));
    }

    public Result<List<MenigaUpcoming>> createUpcoming(CreateUpcoming req) {
        return this.persist(req, this.getClient(Service.UPCOMING).createUpcoming(req));
    }

    public Result<Void> updateUpcoming(UpdateUpcoming req) {
        return this.persist(req, this.getClient(Service.UPCOMING).updateUpcoming(req.id, req, req.toQueryMap()));
    }

    public Result<Void> deleteUpcoming(DeleteUpcoming req) {
        return this.persist(req, this.getClient(Service.UPCOMING).deleteUpcoming(req.id));
    }

    public Result<Void> deleteUpcomingSeries(DeleteUpcomingSeries req) {
        return this.persist(req, this.getClient(Service.UPCOMING).deleteUpcomingSeries(req.id));
    }

    public Result<Void> reconcileUpcoming(ReconcileUpcoming req) {
        return this.persist(req, this.getClient(Service.UPCOMING).reconcileUpcoming(req.id, req.entityType, req.entityId));
    }

    public Result<List<MenigaChallenge>> getChallenges(GetChallenges req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(ChallengeService.class).getChallenges(req.toQueryMap()));
    }

    public Result<MenigaChallenge> getChallenge(GetChallenge req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(ChallengeService.class).getChallenge(req.id.toString()));
    }

    public Result<MenigaChallenge> acceptChallenge(AcceptChallenge req) {
        return this.persist(req, this.getService(ChallengeService.class).acceptChallenge(req, req.id.toString()));
    }

    public Result<Void> disableChallenge(UUID id) {
        return this.call(this.getService(ChallengeService.class).disableChallenge(id.toString()));
    }

    public Result<Void> enableChallenge(UUID id) {
        return this.call(this.getService(ChallengeService.class).enableChallenge(id.toString()));
    }

    public Result<Void> deleteChallenge(DeleteChallenge req) {
        return this.persist(req, this.getService(ChallengeService.class).deleteChallenge(req.id.toString()));
    }

    public Result<MenigaChallenge> createChallenge(CreateChallenge req) {
        return this.persist(req, this.getService(ChallengeService.class).createChallenge(req));
    }

    public Result<Void> updateChallenge(UpdateChallenge req) {
        return this.persist(req, this.getService(ChallengeService.class).updateChallenge(req.id.toString(), req));
    }

    public Result<List<MenigaChallenge>> getChallengeHistory(GetChallengeHistory req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(ChallengeService.class).getChallengeHistory(req.id.toString(), req.toQueryMap()));
    }

    public Result<List<MenigaBudget>> getBudgets(GetBudgets req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(BudgetService.class).getBudgets(req.toQueryMap()));
    }

    public Result<MenigaBudget> getBudget(GetBudget parameters) {
        if (this.provider.hasKey(parameters)) {
            return this.createTask(this.provider.fetch(parameters));
        }
        return this.persist(parameters, this.getService(BudgetService.class).getBudget(Long.toString(parameters.getId()), parameters.toQueryMap()));
    }

    public Result<List<MenigaBudgetEntry>> getBudgetEntries(GetBudgetEntries req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getService(BudgetService.class).getBudgetEntries(Long.toString(req.getId()), req.toQueryMap()));
    }

    public Result<List<MenigaBudgetEntry>> createBudgetEntries(long budgetId, CreateBudgetEntries parameters) {
        return this.persist(parameters, this.getService(BudgetService.class).createBudgetEntries(Long.toString(budgetId), parameters));
    }

    public Result<Void> deleteBudgetEntry(long budgetId, long entryId) {
        return this.call(this.getService(BudgetService.class).deleteBudgetEntry(Long.toString(budgetId), Long.toString(entryId)));
    }

    public Result<MenigaBudgetEntry> getBudgetEntry(GetBudgetEntryById request) {
        if (this.provider.hasKey(request)) {
            return this.createTask(this.provider.fetch(request));
        }
        return this.persist(request, this.getService(BudgetService.class).getBudgetEntry(Long.toString(request.getBudgetId()), Long.toString(request.getEntryId())));
    }

    public Result<MenigaBudgetEntry> updateBudgetEntry(long budgetId, long entryId, UpdateBudgetEntry updateBudgetEntry) {
        return this.persist(updateBudgetEntry, this.getService(BudgetService.class).updateBudgetEntries(Long.toString(budgetId), Long.toString(entryId), updateBudgetEntry));
    }

    public Result<MenigaBudget> createBudget(CreateBudget req) {
        return this.persist(req, this.getService(BudgetService.class).createBudget(req));
    }

    public Result<MenigaBudget> updateBudget(long budgetId, UpdateBudget parameters) {
        return this.persist(parameters, this.getService(BudgetService.class).updateBudget(Long.toString(budgetId), parameters));
    }

    public Result<List<MenigaBudgetRule>> getBudgetRules(GetBudgetRules filter) {
        return this.persist(filter, this.getService(BudgetService.class).getBudgetRules(Long.toString(filter.getId()), filter.toQueryMap()));
    }

    public Result<List<MenigaBudgetRule>> createBudgetRules(long budgetId, CreateBudgetRules req) {
        return this.call(this.getService(BudgetService.class).createBudgetRules(Long.toString(budgetId), req));
    }

    public Result<Void> deleteBudgetRule(long budgetId, long ruleId) {
        return this.call(this.getService(BudgetService.class).deleteBudgetRule(Long.toString(budgetId), Long.toString(ruleId)));
    }

    public Result<Void> deleteBudget(long budgetId) {
        return this.call(this.getService(BudgetService.class).deleteBudget(Long.toString(budgetId)));
    }

    public Result<Void> resetBudget(long budgetId) {
        return this.call(this.getService(BudgetService.class).resetBudget(Long.toString(budgetId)));
    }

    public Result<List<MenigaOrganization>> getOrganizations() {
        return this.persist(new GetOrganizations(), this.getClient(Service.ORGANIZATIONS).getOrganizations());
    }

    public Result<List<MenigaTerms>> getTerms(GetTerms req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TERMS).getTerms(req.culture));
    }

    public Result<MenigaTerms> getTerm(GetTerm req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TERMS).getTerm(req.culture, req.typeId));
    }

    public Result<List<MenigaTermType>> getTermTypes(GetTermTypes req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.TERMS).getTermTypes(req.culture));
    }

    public Result<Void> acceptTerms(AcceptTerms req) {
        return this.persist(req, this.getClient(Service.TERMS).acceptTerms(req.typeId));
    }

    public Result<Void> declineTerms(DeclineTerms req) {
        return this.persist(req, this.getClient(Service.TERMS).declineTerms(req.typeId));
    }

    public Result<Void> trackEvent(TrackEvent req) {
        return this.persist(req, this.getService(EventTrackingService.class).trackEvent(req));
    }

    Result<Object> genericRequest(@Nonnull HttpMethod method, @Nonnull String path, @Nonnull Map<String, String> headers, Object body, @Nonnull Map<String, String> query) {
        TaskAdapter taskAdapter = MenigaSDK.getMenigaSettings().getTaskAdapter();
        switch (method) {
            case HEAD: {
                return taskAdapter.adapt(this.getClient(Service.BYPASS).genericHead(path, headers, query), null);
            }
            case OPTIONS: {
                return taskAdapter.adapt(this.getClient(Service.BYPASS).genericOptions(path, headers, query), null);
            }
            case POST: {
                return taskAdapter.adapt(this.getClient(Service.BYPASS).genericPost(path, headers, body, query), null);
            }
            case PUT: {
                return taskAdapter.adapt(this.getClient(Service.BYPASS).genericPut(path, headers, body, query), null);
            }
            case DELETE: {
                return taskAdapter.adapt(this.getClient(Service.BYPASS).genericDelete(path, headers, query), null);
            }
        }
        return taskAdapter.adapt(this.getClient(Service.BYPASS).genericGet(path, headers, query), null);
    }

    public Result<MenigaPublicSettings> getPublicSettings(GetPublicSettings req) {
        if (this.provider.hasKey(req)) {
            return this.createTask(this.provider.fetch(req));
        }
        return this.persist(req, this.getClient(Service.PUBLIC).getPublicSettings());
    }

    private MenigaAPI getClient(Service forService) {
        return !this.services.containsKey((Object)forService) ? (MenigaAPI)this.services.get((Object)Service.ALL) : (MenigaAPI)this.services.get((Object)forService);
    }

    private <T> T getService(Class<T> serviceClass) {
        return (T)this.services.get((Object)Service.from(serviceClass));
    }

    Map<Service, ?> getApis() {
        return this.services;
    }
}

