/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.providers.tasks;

import android.util.Log;
import com.meniga.sdk.providers.tasks.Task;
import com.meniga.sdk.webservices.MenigaWebException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TaskCompletionSource<TResult> {
    private final Task<TResult> task = new Task();
    private final Call<TResult> call;

    public TaskCompletionSource() {
        this.call = null;
    }

    public TaskCompletionSource(Call<TResult> callIn) {
        this.call = callIn;
    }

    public Task<TResult> getTask() {
        return this.task;
    }

    boolean trySetCancelled() {
        if (this.call != null) {
            try {
                this.call.cancel();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.task.trySetCancelled();
    }

    public boolean trySetResult(TResult result) {
        return this.task.trySetResult(result);
    }

    private boolean trySetError(Exception error) {
        return this.task.trySetError(error);
    }

    public void setCancelled() {
        if (!this.trySetCancelled()) {
            Log.e((String)"Meniga", (String)"Cannot cancel a completed task.");
        }
    }

    public void setResult(TResult result) {
        if (!this.trySetResult(result)) {
            Log.e((String)"Meniga", (String)"Cannot set the result of a completed task.");
        }
    }

    public void setError(Exception error) {
        if (!this.trySetError(error)) {
            Log.e((String)"Meniga", (String)"Cannot set the error on a completed task.");
        }
    }

    public <E> Task<E> createTask(Call<E> call) {
        final TaskCompletionSource<E> src = new TaskCompletionSource<E>(call);
        final Task<E> task2 = src.getTask();
        call.enqueue(new Callback<E>(){

            public void onResponse(Call<E> call, Response<E> response) {
                if (call.isCanceled()) {
                    TaskCompletionSource.this.setCancelled();
                } else if (response.isSuccessful()) {
                    src.setResult(response.body());
                } else {
                    TaskCompletionSource.this.setError(new MenigaWebException(response.message(), response.code()));
                }
            }

            public void onFailure(Call<E> call, Throwable t) {
                if (t == null && !task2.isCancelled()) {
                    TaskCompletionSource.this.setError(new Exception("[No error message provided]"));
                } else if (call.isCanceled() && !task2.isCompleted()) {
                    TaskCompletionSource.this.setCancelled();
                } else if (!task2.isCompleted() && t != null) {
                    TaskCompletionSource.this.setError(new MenigaWebException(t.getMessage(), -1));
                }
            }
        });
        return task2;
    }
}

