/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.providers;

import android.util.Base64;
import com.meniga.sdk.ErrorHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class BasicAuthenticator
implements Authenticator {
    private String basicAuthenticationHeader;

    public void setUserNameAndPassword(String username, String password) {
        String encodedHeader = this.encode(username, password);
        this.basicAuthenticationHeader = "Basic " + encodedHeader;
    }

    private String encode(String username, String password) {
        String comb = username + ":" + password;
        byte[] data = null;
        try {
            data = comb.trim().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ErrorHandler.reportAndHandle(e);
        }
        return Base64.encodeToString((byte[])data, (int)0);
    }

    public Request authenticate(Route route, Response response) throws IOException {
        return response.request().newBuilder().header("Authorization", this.basicAuthenticationHeader.trim()).header("X-XSRF-Header", "true").build();
    }
}

