/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.userevents.enums;

public enum UserEventType {
    ACCOUNTS("accounts"),
    TRANSACTIONS("transactions"),
    SCHEDULED_USER_EVENT("scheduled_user_event"),
    CASHBACK_OFFER("cashback_offer"),
    DIALOG("dialog"),
    CHALLENGE("challenge"),
    LIFE_GOAL("life_goal"),
    UPCOMING("upcoming"),
    ACCOUNTS_AVAILABLE_AMOUNT("accounts_available_amount"),
    SCHEDULED_MONTHLY_TRANSACTION_REPORT("scheduled_monthly_transaction_report"),
    SCHEDULED_WEEKLY_TRANSACTION_REPORT("scheduled_weekly_transaction_report"),
    TRANSACTIONS_MERCHANT_COUNT("transactions_merchant_count"),
    TRANSACTIONS_CATEGORY_BUDGET_WATCH("transactions_category_budget_watch"),
    TRANSACTIONS_THRESHOLD_DEPOSIT("transactions_threshold_deposit"),
    TRANSACTIONS_THRESHOLD_EXPENSES("transactions_threshold_expenses"),
    TRANSACTIONS_UNUSUAL_SPENDING("transactions_unusual_spending"),
    CASHBACK_OFFER_REDEMPTION("cashback_offer_redemption"),
    CHALLENGE_STARTED("challenge_started"),
    CHALLENGE_PROGRESS("challenge_progress"),
    CHALLENGE_COMPLETED("challenge_completed"),
    CASHBACK_OFFER_AVAILABLE("cashback_offer_available"),
    CASHBACK_OFFER_DAYS_LEFT("cashback_offer_days_left"),
    CASHBACK_REPAYMENT("cashback_repayment"),
    DIALOG_MESSAGE("dialog_message"),
    LIFE_GOAL_REACHED("life_goal_reached"),
    LIFE_GOAL_PROGRESS("life_goal_progress"),
    UPCOMING_AVAILABLE_PROJECTED_BALANCE("upcoming_available_projected_balance"),
    UNKNOWN("unknown");

    private String tag;

    private UserEventType(String tagIn) {
        this.tag = tagIn;
    }

    public String toString() {
        return this.tag;
    }

    public static UserEventType parse(String userEventTypeIdentifier) {
        for (UserEventType type2 : UserEventType.values()) {
            if (!type2.tag.toLowerCase().equals(userEventTypeIdentifier.toLowerCase())) continue;
            return type2;
        }
        UserEventType unknownType = UNKNOWN;
        unknownType.tag = userEventTypeIdentifier;
        return unknownType;
    }
}

