/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.user;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.user.enums.ApartmentType;
import com.meniga.sdk.models.user.enums.Gender;
import com.meniga.sdk.models.user.operators.MenigaUserProfileOperations;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class MenigaUserProfile
implements Serializable,
Parcelable,
Cloneable {
    public static final Parcelable.Creator<MenigaUserProfile> CREATOR = new Parcelable.Creator<MenigaUserProfile>(){

        public MenigaUserProfile createFromParcel(Parcel source) {
            return new MenigaUserProfile(source);
        }

        public MenigaUserProfile[] newArray(int size) {
            return new MenigaUserProfile[size];
        }
    };
    protected static MenigaUserProfileOperations apiOperator;
    protected Gender gender;
    protected LocalDate birthYear;
    protected DateTime created;
    protected Boolean hasSavedProfile;
    protected Integer incomeId;
    protected Integer numberInFamily;
    protected Integer numberOfCars;
    protected Integer numberOfKids;
    protected Integer apartmentRooms;
    protected Integer apartmentSize;
    protected Integer apartmentSizeKey;
    protected ApartmentType apartmentType;
    protected String postalCode;
    protected long personId;
    protected String currencyCode;

    protected MenigaUserProfile() {
    }

    protected MenigaUserProfile(Parcel in) {
        int tmpGender = in.readInt();
        this.gender = tmpGender == -1 ? null : Gender.values()[tmpGender];
        this.birthYear = (LocalDate)in.readSerializable();
        this.created = (DateTime)in.readSerializable();
        this.hasSavedProfile = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.incomeId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.numberInFamily = (Integer)in.readValue(Integer.class.getClassLoader());
        this.numberOfCars = (Integer)in.readValue(Integer.class.getClassLoader());
        this.numberOfKids = (Integer)in.readValue(Integer.class.getClassLoader());
        this.apartmentRooms = (Integer)in.readValue(Integer.class.getClassLoader());
        this.apartmentSize = (Integer)in.readValue(Integer.class.getClassLoader());
        this.apartmentSizeKey = (Integer)in.readValue(Integer.class.getClassLoader());
        int tmpApartmentType = in.readInt();
        this.apartmentType = tmpApartmentType == -1 ? null : ApartmentType.values()[tmpApartmentType];
        this.postalCode = in.readString();
        this.personId = in.readLong();
        this.currencyCode = in.readString();
    }

    public static void setOperator(MenigaUserProfileOperations operator) {
        apiOperator = operator;
    }

    protected MenigaUserProfile clone() throws CloneNotSupportedException {
        return (MenigaUserProfile)super.clone();
    }

    public Gender getGender() {
        return this.gender;
    }

    public LocalDate getBirthYear() {
        return this.birthYear;
    }

    public long getPersonId() {
        return this.personId;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.gender == null ? -1 : this.gender.ordinal());
        dest.writeSerializable((Serializable)this.birthYear);
        dest.writeSerializable((Serializable)this.created);
        dest.writeValue((Object)this.hasSavedProfile);
        dest.writeValue((Object)this.incomeId);
        dest.writeValue((Object)this.numberInFamily);
        dest.writeValue((Object)this.numberOfCars);
        dest.writeValue((Object)this.numberOfKids);
        dest.writeValue((Object)this.apartmentRooms);
        dest.writeValue((Object)this.apartmentSize);
        dest.writeValue((Object)this.apartmentSizeKey);
        dest.writeInt(this.apartmentType == null ? -1 : this.apartmentType.ordinal());
        dest.writeString(this.postalCode);
        dest.writeLong(this.personId);
        dest.writeString(this.currencyCode);
    }

    public static Result<MenigaUserProfile> fetch() {
        return apiOperator.getUserProfile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaUserProfile that = (MenigaUserProfile)o;
        if (this.personId != that.personId) {
            return false;
        }
        if (this.gender != that.gender) {
            return false;
        }
        if (this.birthYear != null ? !this.birthYear.equals((Object)that.birthYear) : that.birthYear != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals((Object)that.created) : that.created != null) {
            return false;
        }
        if (this.hasSavedProfile != null ? !this.hasSavedProfile.equals(that.hasSavedProfile) : that.hasSavedProfile != null) {
            return false;
        }
        if (this.incomeId != null ? !this.incomeId.equals(that.incomeId) : that.incomeId != null) {
            return false;
        }
        if (this.numberInFamily != null ? !this.numberInFamily.equals(that.numberInFamily) : that.numberInFamily != null) {
            return false;
        }
        if (this.numberOfCars != null ? !this.numberOfCars.equals(that.numberOfCars) : that.numberOfCars != null) {
            return false;
        }
        if (this.numberOfKids != null ? !this.numberOfKids.equals(that.numberOfKids) : that.numberOfKids != null) {
            return false;
        }
        if (this.apartmentRooms != null ? !this.apartmentRooms.equals(that.apartmentRooms) : that.apartmentRooms != null) {
            return false;
        }
        if (this.apartmentSize != null ? !this.apartmentSize.equals(that.apartmentSize) : that.apartmentSize != null) {
            return false;
        }
        if (this.apartmentSizeKey != null ? !this.apartmentSizeKey.equals(that.apartmentSizeKey) : that.apartmentSizeKey != null) {
            return false;
        }
        if (this.apartmentType != that.apartmentType) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        return this.currencyCode != null ? this.currencyCode.equals(that.currencyCode) : that.currencyCode == null;
    }

    public int hashCode() {
        int result = this.gender != null ? this.gender.hashCode() : 0;
        result = 31 * result + (this.birthYear != null ? this.birthYear.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.hasSavedProfile != null ? this.hasSavedProfile.hashCode() : 0);
        result = 31 * result + (this.incomeId != null ? this.incomeId.hashCode() : 0);
        result = 31 * result + (this.numberInFamily != null ? this.numberInFamily.hashCode() : 0);
        result = 31 * result + (this.numberOfCars != null ? this.numberOfCars.hashCode() : 0);
        result = 31 * result + (this.numberOfKids != null ? this.numberOfKids.hashCode() : 0);
        result = 31 * result + (this.apartmentRooms != null ? this.apartmentRooms.hashCode() : 0);
        result = 31 * result + (this.apartmentSize != null ? this.apartmentSize.hashCode() : 0);
        result = 31 * result + (this.apartmentSizeKey != null ? this.apartmentSizeKey.hashCode() : 0);
        result = 31 * result + (this.apartmentType != null ? this.apartmentType.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (int)(this.personId ^ this.personId >>> 32);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        return result;
    }
}

