/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.upcoming;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.upcoming.enums.PaymentStatus;
import java.io.Serializable;
import org.joda.time.DateTime;

public class MenigaUpcomingInvoice
implements Serializable,
Parcelable,
Cloneable {
    protected long id;
    protected String identifier;
    protected String bankReference;
    protected String invoiceText;
    protected MenigaDecimal amountInCurrency;
    protected MenigaDecimal feeAmount;
    protected MenigaDecimal vatAmount;
    protected String currencyCode;
    protected DateTime issuedDate;
    protected DateTime dueDate;
    protected DateTime finalDueDate;
    protected DateTime bookingDate;
    protected PaymentStatus paymentStatus;
    protected String parsedData;
    protected Boolean isReceivable;
    protected String issuerName;
    protected String issuerIdentifier;
    protected String issuerAccIdentifier;
    protected String issuerReferenceText;
    protected String counterpartyName;
    protected String counterpartyIdentifier;
    protected String counterpartyAccIdentifier;
    protected String counterpartyReferenceText;
    public static final Parcelable.Creator<MenigaUpcomingInvoice> CREATOR = new Parcelable.Creator<MenigaUpcomingInvoice>(){

        public MenigaUpcomingInvoice createFromParcel(Parcel source) {
            return new MenigaUpcomingInvoice(source);
        }

        public MenigaUpcomingInvoice[] newArray(int size) {
            return new MenigaUpcomingInvoice[size];
        }
    };

    protected MenigaUpcomingInvoice() {
    }

    public MenigaUpcomingInvoice clone() throws CloneNotSupportedException {
        return (MenigaUpcomingInvoice)super.clone();
    }

    public long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBankReference() {
        return this.bankReference;
    }

    public String getInvoiceText() {
        return this.invoiceText;
    }

    public MenigaDecimal getAmountInCurrency() {
        return this.amountInCurrency;
    }

    public MenigaDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public MenigaDecimal getVatAmount() {
        return this.vatAmount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public DateTime getIssuedDate() {
        return this.issuedDate;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }

    public DateTime getFinalDueDate() {
        return this.finalDueDate;
    }

    public DateTime getBookingDate() {
        return this.bookingDate;
    }

    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getParsedData() {
        return this.parsedData;
    }

    public Boolean getReceivable() {
        return this.isReceivable;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getIssuerIdentifier() {
        return this.issuerIdentifier;
    }

    public String getIssuerAccIdentifier() {
        return this.issuerAccIdentifier;
    }

    public String getIssuerReferenceText() {
        return this.issuerReferenceText;
    }

    public String getCounterpartyName() {
        return this.counterpartyName;
    }

    public String getCounterpartyIdentifier() {
        return this.counterpartyIdentifier;
    }

    public String getCounterpartyAccIdentifier() {
        return this.counterpartyAccIdentifier;
    }

    public String getCounterpartyReferenceText() {
        return this.counterpartyReferenceText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaUpcomingInvoice that = (MenigaUpcomingInvoice)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.bankReference != null ? !this.bankReference.equals(that.bankReference) : that.bankReference != null) {
            return false;
        }
        if (this.invoiceText != null ? !this.invoiceText.equals(that.invoiceText) : that.invoiceText != null) {
            return false;
        }
        if (this.amountInCurrency != null ? !this.amountInCurrency.equals(that.amountInCurrency) : that.amountInCurrency != null) {
            return false;
        }
        if (this.feeAmount != null ? !this.feeAmount.equals(that.feeAmount) : that.feeAmount != null) {
            return false;
        }
        if (this.vatAmount != null ? !this.vatAmount.equals(that.vatAmount) : that.vatAmount != null) {
            return false;
        }
        if (this.currencyCode != null ? !this.currencyCode.equals(that.currencyCode) : that.currencyCode != null) {
            return false;
        }
        if (this.issuedDate != null ? !this.issuedDate.equals((Object)that.issuedDate) : that.issuedDate != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals((Object)that.dueDate) : that.dueDate != null) {
            return false;
        }
        if (this.finalDueDate != null ? !this.finalDueDate.equals((Object)that.finalDueDate) : that.finalDueDate != null) {
            return false;
        }
        if (this.bookingDate != null ? !this.bookingDate.equals((Object)that.bookingDate) : that.bookingDate != null) {
            return false;
        }
        if (this.paymentStatus != that.paymentStatus) {
            return false;
        }
        if (this.parsedData != null ? !this.parsedData.equals(that.parsedData) : that.parsedData != null) {
            return false;
        }
        if (this.isReceivable != null ? !this.isReceivable.equals(that.isReceivable) : that.isReceivable != null) {
            return false;
        }
        if (this.issuerName != null ? !this.issuerName.equals(that.issuerName) : that.issuerName != null) {
            return false;
        }
        if (this.issuerIdentifier != null ? !this.issuerIdentifier.equals(that.issuerIdentifier) : that.issuerIdentifier != null) {
            return false;
        }
        if (this.issuerAccIdentifier != null ? !this.issuerAccIdentifier.equals(that.issuerAccIdentifier) : that.issuerAccIdentifier != null) {
            return false;
        }
        if (this.issuerReferenceText != null ? !this.issuerReferenceText.equals(that.issuerReferenceText) : that.issuerReferenceText != null) {
            return false;
        }
        if (this.counterpartyName != null ? !this.counterpartyName.equals(that.counterpartyName) : that.counterpartyName != null) {
            return false;
        }
        if (this.counterpartyIdentifier != null ? !this.counterpartyIdentifier.equals(that.counterpartyIdentifier) : that.counterpartyIdentifier != null) {
            return false;
        }
        if (this.counterpartyAccIdentifier != null ? !this.counterpartyAccIdentifier.equals(that.counterpartyAccIdentifier) : that.counterpartyAccIdentifier != null) {
            return false;
        }
        return this.counterpartyReferenceText != null ? this.counterpartyReferenceText.equals(that.counterpartyReferenceText) : that.counterpartyReferenceText == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.bankReference != null ? this.bankReference.hashCode() : 0);
        result = 31 * result + (this.invoiceText != null ? this.invoiceText.hashCode() : 0);
        result = 31 * result + (this.amountInCurrency != null ? this.amountInCurrency.hashCode() : 0);
        result = 31 * result + (this.feeAmount != null ? this.feeAmount.hashCode() : 0);
        result = 31 * result + (this.vatAmount != null ? this.vatAmount.hashCode() : 0);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        result = 31 * result + (this.issuedDate != null ? this.issuedDate.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.finalDueDate != null ? this.finalDueDate.hashCode() : 0);
        result = 31 * result + (this.bookingDate != null ? this.bookingDate.hashCode() : 0);
        result = 31 * result + (this.paymentStatus != null ? this.paymentStatus.hashCode() : 0);
        result = 31 * result + (this.parsedData != null ? this.parsedData.hashCode() : 0);
        result = 31 * result + (this.isReceivable != null ? this.isReceivable.hashCode() : 0);
        result = 31 * result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
        result = 31 * result + (this.issuerIdentifier != null ? this.issuerIdentifier.hashCode() : 0);
        result = 31 * result + (this.issuerAccIdentifier != null ? this.issuerAccIdentifier.hashCode() : 0);
        result = 31 * result + (this.issuerReferenceText != null ? this.issuerReferenceText.hashCode() : 0);
        result = 31 * result + (this.counterpartyName != null ? this.counterpartyName.hashCode() : 0);
        result = 31 * result + (this.counterpartyIdentifier != null ? this.counterpartyIdentifier.hashCode() : 0);
        result = 31 * result + (this.counterpartyAccIdentifier != null ? this.counterpartyAccIdentifier.hashCode() : 0);
        result = 31 * result + (this.counterpartyReferenceText != null ? this.counterpartyReferenceText.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.identifier);
        dest.writeString(this.bankReference);
        dest.writeString(this.invoiceText);
        dest.writeSerializable((Serializable)this.amountInCurrency);
        dest.writeSerializable((Serializable)this.feeAmount);
        dest.writeSerializable((Serializable)this.vatAmount);
        dest.writeString(this.currencyCode);
        dest.writeSerializable((Serializable)this.issuedDate);
        dest.writeSerializable((Serializable)this.dueDate);
        dest.writeSerializable((Serializable)this.finalDueDate);
        dest.writeSerializable((Serializable)this.bookingDate);
        dest.writeInt(this.paymentStatus == null ? -1 : this.paymentStatus.ordinal());
        dest.writeString(this.parsedData);
        dest.writeValue((Object)this.isReceivable);
        dest.writeString(this.issuerName);
        dest.writeString(this.issuerIdentifier);
        dest.writeString(this.issuerAccIdentifier);
        dest.writeString(this.issuerReferenceText);
        dest.writeString(this.counterpartyName);
        dest.writeString(this.counterpartyIdentifier);
        dest.writeString(this.counterpartyAccIdentifier);
        dest.writeString(this.counterpartyReferenceText);
    }

    protected MenigaUpcomingInvoice(Parcel in) {
        this.id = in.readLong();
        this.identifier = in.readString();
        this.bankReference = in.readString();
        this.invoiceText = in.readString();
        this.amountInCurrency = (MenigaDecimal)in.readSerializable();
        this.feeAmount = (MenigaDecimal)in.readSerializable();
        this.vatAmount = (MenigaDecimal)in.readSerializable();
        this.currencyCode = in.readString();
        this.issuedDate = (DateTime)in.readSerializable();
        this.dueDate = (DateTime)in.readSerializable();
        this.finalDueDate = (DateTime)in.readSerializable();
        this.bookingDate = (DateTime)in.readSerializable();
        int tmpPaymentStatus = in.readInt();
        this.paymentStatus = tmpPaymentStatus == -1 ? null : PaymentStatus.values()[tmpPaymentStatus];
        this.parsedData = in.readString();
        this.isReceivable = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.issuerName = in.readString();
        this.issuerIdentifier = in.readString();
        this.issuerAccIdentifier = in.readString();
        this.issuerReferenceText = in.readString();
        this.counterpartyName = in.readString();
        this.counterpartyIdentifier = in.readString();
        this.counterpartyAccIdentifier = in.readString();
        this.counterpartyReferenceText = in.readString();
    }
}

