/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.upcoming;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.upcoming.MenigaUpcomingComment;
import com.meniga.sdk.models.upcoming.MenigaUpcomingDetails;
import com.meniga.sdk.models.upcoming.MenigaUpcomingReconcileScore;
import com.meniga.sdk.models.upcoming.MenigaUpcomingRecurringPattern;
import com.meniga.sdk.models.upcoming.enums.PaymentStatus;
import com.meniga.sdk.models.upcoming.enums.ReconcileEntityType;
import com.meniga.sdk.models.upcoming.operators.MenigaUpcomingOperations;
import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaUpcoming
implements Serializable,
Parcelable,
Cloneable {
    protected long id;
    protected String bankReference;
    protected String text;
    protected MenigaDecimal amount;
    protected MenigaDecimal amountInCurrency;
    protected String currencyCode;
    protected DateTime date;
    protected PaymentStatus paymentStatus;
    protected Boolean isFlagged;
    protected Boolean isWatched;
    protected Long accountId;
    protected Long transactionId;
    protected Long invoiceId;
    protected Long scheduledPaymentId;
    protected Long categoryId;
    protected MenigaUpcomingRecurringPattern recurringPattern;
    protected List<MenigaUpcomingComment> comments;
    protected List<MenigaUpcomingReconcileScore> reconcileScores;
    protected MenigaUpcomingDetails details;
    private static MenigaUpcomingOperations apiOperator;
    public static final Parcelable.Creator<MenigaUpcoming> CREATOR;

    protected MenigaUpcoming() {
    }

    protected MenigaUpcoming(Parcel in) {
        this.id = in.readLong();
        this.bankReference = in.readString();
        this.text = in.readString();
        this.amount = (MenigaDecimal)in.readSerializable();
        this.amountInCurrency = (MenigaDecimal)in.readSerializable();
        this.currencyCode = in.readString();
        this.date = (DateTime)in.readSerializable();
        int tmpPaymentStatus = in.readInt();
        this.paymentStatus = tmpPaymentStatus == -1 ? null : PaymentStatus.values()[tmpPaymentStatus];
        this.isFlagged = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.isWatched = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.accountId = (Long)in.readValue(Long.class.getClassLoader());
        this.transactionId = (Long)in.readValue(Long.class.getClassLoader());
        this.invoiceId = (Long)in.readValue(Long.class.getClassLoader());
        this.scheduledPaymentId = (Long)in.readValue(Long.class.getClassLoader());
        this.categoryId = (Long)in.readValue(Long.class.getClassLoader());
        this.recurringPattern = (MenigaUpcomingRecurringPattern)in.readParcelable(MenigaUpcomingRecurringPattern.class.getClassLoader());
        this.comments = in.createTypedArrayList(MenigaUpcomingComment.CREATOR);
        this.reconcileScores = in.createTypedArrayList(MenigaUpcomingReconcileScore.CREATOR);
        this.details = (MenigaUpcomingDetails)in.readParcelable(MenigaUpcomingDetails.class.getClassLoader());
    }

    public String toString() {
        return this.text + " (" + this.id + "): " + this.amount.doubleValue() + " (" + (Object)((Object)this.paymentStatus) + ")";
    }

    public long getId() {
        return this.id;
    }

    public String getBankReference() {
        return this.bankReference;
    }

    public String getText() {
        return this.text;
    }

    public MenigaDecimal getAmount() {
        return this.amount;
    }

    public MenigaDecimal getAmountInCurrency() {
        return this.amountInCurrency;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public DateTime getDate() {
        return this.date;
    }

    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public Boolean getFlagged() {
        return this.isFlagged;
    }

    public Boolean getWatched() {
        return this.isWatched;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public Long getInvoiceId() {
        return this.invoiceId;
    }

    public Long getScheduledPaymentId() {
        return this.scheduledPaymentId;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public MenigaUpcomingRecurringPattern getRecurringPattern() {
        return this.recurringPattern;
    }

    public List<MenigaUpcomingComment> getComments() {
        return this.comments;
    }

    public List<MenigaUpcomingReconcileScore> getReconcileScores() {
        return this.reconcileScores;
    }

    public MenigaUpcomingDetails getDetails() {
        return this.details;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAmountInCurrency(MenigaDecimal amountInCurrency) {
        this.amountInCurrency = amountInCurrency;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public void setPaymentStatus(PaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public void setFlagged(boolean isFlagged) {
        this.isFlagged = isFlagged;
    }

    public void setIsWatched(boolean isWatched) {
        this.isWatched = isWatched;
    }

    public void setRecurringPattern(MenigaUpcomingRecurringPattern recurringPattern) {
        this.recurringPattern = recurringPattern;
    }

    public static void setOperator(MenigaUpcomingOperations operator) {
        apiOperator = operator;
    }

    public MenigaUpcoming clone() throws CloneNotSupportedException {
        return (MenigaUpcoming)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaUpcoming that = (MenigaUpcoming)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.bankReference != null ? !this.bankReference.equals(that.bankReference) : that.bankReference != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(that.amount) : that.amount != null) {
            return false;
        }
        if (this.amountInCurrency != null ? !this.amountInCurrency.equals(that.amountInCurrency) : that.amountInCurrency != null) {
            return false;
        }
        if (this.currencyCode != null ? !this.currencyCode.equals(that.currencyCode) : that.currencyCode != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.paymentStatus != that.paymentStatus) {
            return false;
        }
        if (this.isFlagged != null ? !this.isFlagged.equals(that.isFlagged) : that.isFlagged != null) {
            return false;
        }
        if (this.isWatched != null ? !this.isWatched.equals(that.isWatched) : that.isWatched != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.transactionId != null ? !this.transactionId.equals(that.transactionId) : that.transactionId != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.scheduledPaymentId != null ? !this.scheduledPaymentId.equals(that.scheduledPaymentId) : that.scheduledPaymentId != null) {
            return false;
        }
        if (this.categoryId != null ? !this.categoryId.equals(that.categoryId) : that.categoryId != null) {
            return false;
        }
        if (this.recurringPattern != null ? !this.recurringPattern.equals(that.recurringPattern) : that.recurringPattern != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.reconcileScores != null ? !this.reconcileScores.equals(that.reconcileScores) : that.reconcileScores != null) {
            return false;
        }
        return this.details != null ? this.details.equals(that.details) : that.details == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.bankReference != null ? this.bankReference.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.amountInCurrency != null ? this.amountInCurrency.hashCode() : 0);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.paymentStatus != null ? this.paymentStatus.hashCode() : 0);
        result = 31 * result + (this.isFlagged != null ? this.isFlagged.hashCode() : 0);
        result = 31 * result + (this.isWatched != null ? this.isWatched.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.transactionId != null ? this.transactionId.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.scheduledPaymentId != null ? this.scheduledPaymentId.hashCode() : 0);
        result = 31 * result + (this.categoryId != null ? this.categoryId.hashCode() : 0);
        result = 31 * result + (this.recurringPattern != null ? this.recurringPattern.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.reconcileScores != null ? this.reconcileScores.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.bankReference);
        dest.writeString(this.text);
        dest.writeSerializable((Serializable)this.amount);
        dest.writeSerializable((Serializable)this.amountInCurrency);
        dest.writeString(this.currencyCode);
        dest.writeSerializable((Serializable)this.date);
        dest.writeInt(this.paymentStatus == null ? -1 : this.paymentStatus.ordinal());
        dest.writeValue((Object)this.isFlagged);
        dest.writeValue((Object)this.isWatched);
        dest.writeValue((Object)this.accountId);
        dest.writeValue((Object)this.transactionId);
        dest.writeValue((Object)this.invoiceId);
        dest.writeValue((Object)this.scheduledPaymentId);
        dest.writeValue((Object)this.categoryId);
        dest.writeParcelable((Parcelable)this.recurringPattern, flags);
        dest.writeTypedList(this.comments);
        dest.writeTypedList(this.reconcileScores);
        dest.writeParcelable((Parcelable)this.details, flags);
    }

    public static Result<List<MenigaUpcoming>> fetch(DateTime from, DateTime to) {
        return apiOperator.getUpcoming(from, to);
    }

    public static Result<MenigaUpcoming> fetch(long id) {
        return apiOperator.getUpcoming(id);
    }

    public static Result<List<MenigaUpcoming>> create(String text, MenigaDecimal amountInCurrency, String currencyCode, DateTime date, Long accountId, Long categoryId, Boolean isFlagged, Boolean isWatched, MenigaUpcomingRecurringPattern recurringPattern) {
        return apiOperator.createUpcoming(text, amountInCurrency, currencyCode, date, accountId, categoryId, isFlagged, isWatched, recurringPattern);
    }

    public Result<Void> update(boolean updateWholeSeries) {
        Result<Void> task2 = apiOperator.updateUpcoming(this, updateWholeSeries);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<Void>(){

            @Override
            public void onFinished(Void result, boolean failed) {
                if (failed) {
                    return;
                }
                Result<MenigaUpcoming> task2 = MenigaUpcoming.fetch(MenigaUpcoming.this.id);
                MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaUpcoming>(){

                    @Override
                    public void onFinished(MenigaUpcoming result, boolean failed) {
                        if (!failed && result != null) {
                            MenigaUpcoming.this.amount = result.amount;
                            MenigaUpcoming.this.amountInCurrency = result.amountInCurrency;
                        }
                    }
                });
            }
        });
    }

    public Result<Void> delete(boolean deleteSeries) {
        return apiOperator.deleteUpcoming(this, deleteSeries);
    }

    public Result<Void> reconcile(ReconcileEntityType entityType, long entityId) {
        return MenigaUpcoming.reconcile(this.id, entityType, entityId);
    }

    public static Result<Void> reconcile(long upcomingId, ReconcileEntityType entityType, long entityId) {
        return apiOperator.reconcileUpcoming(upcomingId, entityType, entityId);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaUpcoming>(){

            public MenigaUpcoming createFromParcel(Parcel source) {
                return new MenigaUpcoming(source);
            }

            public MenigaUpcoming[] newArray(int size) {
                return new MenigaUpcoming[size];
            }
        };
    }
}

