/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.Gson;
import com.meniga.sdk.ErrorHandler;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.interfaces.ValueHashable;
import com.meniga.sdk.models.accounts.MenigaAccount;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.models.categories.enums.CategoryType;
import com.meniga.sdk.models.transactions.enums.SeriesOrderBy;
import com.meniga.sdk.models.transactions.enums.TransactionSortField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TransactionsFilter
implements Serializable,
Parcelable,
Cloneable,
ValueHashable {
    protected final String type;
    protected final String orderBy;
    protected final transient Integer skip;
    protected final transient Integer take;
    protected final MenigaDecimal amountTo;
    protected final MenigaDecimal amountFrom;
    protected final List<Long> categoryIds;
    protected final List<Long> accountIds;
    protected final List<Long> accountTypeIds;
    protected final List<String> accountIdentifiers;
    protected final List<Long> merchantIds;
    protected final List<String> merchantTexts;
    protected final String searchText;
    protected final List<String> tags;
    protected final DateTime periodTo;
    protected final DateTime periodFrom;
    protected final List<Long> ids;
    protected final Boolean onlyUnread;
    protected final Boolean onlyUncertain;
    protected final Boolean onlyFlagged;
    protected final Boolean useExactMerchantTexts;
    protected final Boolean uncertainOrFlagged;
    protected final Boolean useAbsoluteAmountSearch;
    protected final Boolean useAccentInsensitiveSearch;
    protected final Boolean useAmountInCurrencySearch;
    protected final Boolean useAndSearchForTags;
    protected final Boolean useEqualsSearchForBankId;
    protected final Boolean useExactDescription;
    protected final Boolean useParentMerchantIds;
    protected final Boolean onlyUncategorized;
    protected final Boolean ascendingOrder;
    protected final Boolean hideExcluded;
    protected final List<String> bankIds;
    protected final List<CategoryType> categoryTypes;
    protected final String comment;
    protected final List<String> counterpartyAccountIdentifiers;
    protected final String description;
    protected final List<Integer> excludeMerchantIds;
    protected final List<String> excludeMerchantTexts;
    protected final List<String> fields;
    protected final DateTime insertedBefore;
    protected final DateTime originalPeriodFrom;
    protected final DateTime originalPeriodTo;
    protected final String parsedData;
    protected final List<String> parsedDataExactKeys;
    protected final String parsedDataNameToOrderBy;
    protected final String sort;
    protected final Boolean onlyUncleared;
    protected transient boolean includeAccounts;
    protected transient boolean includeMerchants;
    protected final transient boolean isFiltering;
    public static final Parcelable.Creator<TransactionsFilter> CREATOR = new Parcelable.Creator<TransactionsFilter>(){

        public TransactionsFilter createFromParcel(Parcel source) {
            return new TransactionsFilter(source);
        }

        public TransactionsFilter[] newArray(int size) {
            return new TransactionsFilter[size];
        }
    };

    private TransactionsFilter(Builder builder) {
        this.type = builder.type;
        this.orderBy = builder.orderBy;
        this.take = builder.take;
        this.skip = builder.skip;
        this.searchText = builder.searchText;
        this.amountFrom = builder.amountFrom;
        this.amountTo = builder.amountTo;
        this.categoryIds = builder.categoryIds;
        this.accountIds = builder.accountIds;
        this.accountTypeIds = builder.accountTypeIds;
        this.merchantIds = builder.merchantIds;
        this.merchantTexts = builder.merchantTexts;
        this.tags = builder.tags;
        this.periodFrom = builder.periodFrom;
        this.periodTo = builder.periodTo;
        this.ids = builder.ids;
        this.onlyUnread = builder.onlyUnread;
        this.onlyUncertain = builder.onlyUncertain;
        this.onlyFlagged = builder.onlyFlagged;
        this.useExactMerchantTexts = builder.useExactMerchantTexts;
        this.ascendingOrder = builder.ascendingOrder;
        this.accountIdentifiers = builder.accountIdentifiers;
        this.bankIds = builder.bankIds;
        this.categoryTypes = builder.categoryTypes;
        this.comment = builder.comment;
        this.counterpartyAccountIdentifiers = builder.counterpartyAccountIdentifiers;
        this.description = builder.description;
        this.excludeMerchantIds = builder.excludeMerchantIds;
        this.excludeMerchantTexts = builder.excludeMerchantTexts;
        this.fields = builder.fields;
        this.hideExcluded = builder.hideExcluded;
        this.uncertainOrFlagged = builder.uncertainOrFlagged;
        this.onlyUncategorized = builder.onlyUncategorized;
        this.useAbsoluteAmountSearch = builder.useAbsoluteAmountSearch;
        this.useAccentInsensitiveSearch = builder.useAccentInsensitiveSearch;
        this.useAmountInCurrencySearch = builder.useAmountInCurrencySearch;
        this.useAndSearchForTags = builder.useAndSearchForTags;
        this.useEqualsSearchForBankId = builder.useEqualsSearchForBankId;
        this.useExactDescription = builder.useExactDescription;
        this.useParentMerchantIds = builder.useParentMerchantIds;
        this.insertedBefore = builder.insertedBefore;
        this.originalPeriodFrom = builder.originalPeriodFrom;
        this.originalPeriodTo = builder.originalPeriodTo;
        this.parsedData = builder.parsedData;
        this.parsedDataExactKeys = builder.parsedDataExactKeys;
        this.parsedDataNameToOrderBy = builder.parsedDataNameToOrderBy;
        this.includeAccounts = builder.includeAccounts;
        this.includeMerchants = builder.includeMerchants;
        this.sort = builder.sort;
        this.onlyUncleared = builder.onlyUncleared;
        this.isFiltering = builder.isFiltering;
    }

    protected TransactionsFilter(Parcel in) {
        this.type = in.readString();
        this.orderBy = in.readString();
        this.take = (Integer)in.readValue(Integer.class.getClassLoader());
        this.skip = (Integer)in.readValue(Integer.class.getClassLoader());
        this.amountTo = (MenigaDecimal)in.readSerializable();
        this.amountFrom = (MenigaDecimal)in.readSerializable();
        this.categoryIds = new ArrayList<Long>();
        in.readList(this.categoryIds, Long.class.getClassLoader());
        this.accountIds = new ArrayList<Long>();
        in.readList(this.accountIds, Long.class.getClassLoader());
        boolean isNull = in.readInt() == 0;
        this.accountTypeIds = new ArrayList<Long>();
        in.readList(this.accountTypeIds, Long.class.getClassLoader());
        this.accountIdentifiers = in.createStringArrayList();
        this.merchantIds = new ArrayList<Long>();
        in.readList(this.merchantIds, Long.class.getClassLoader());
        this.merchantTexts = in.createStringArrayList();
        this.searchText = in.readString();
        this.tags = in.createStringArrayList();
        this.periodTo = (DateTime)in.readSerializable();
        this.periodFrom = (DateTime)in.readSerializable();
        this.ids = new ArrayList<Long>();
        in.readList(this.ids, Long.class.getClassLoader());
        this.onlyUnread = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.onlyUncertain = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.onlyFlagged = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useExactMerchantTexts = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.uncertainOrFlagged = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useAbsoluteAmountSearch = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useAccentInsensitiveSearch = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useAmountInCurrencySearch = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useAndSearchForTags = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useEqualsSearchForBankId = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useExactDescription = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.useParentMerchantIds = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.onlyUncategorized = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.ascendingOrder = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.hideExcluded = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.bankIds = in.createStringArrayList();
        this.categoryTypes = new ArrayList<CategoryType>();
        in.readList(this.categoryTypes, CategoryType.class.getClassLoader());
        this.comment = in.readString();
        this.counterpartyAccountIdentifiers = in.createStringArrayList();
        this.description = in.readString();
        this.excludeMerchantIds = new ArrayList<Integer>();
        in.readList(this.excludeMerchantIds, Integer.class.getClassLoader());
        this.excludeMerchantTexts = in.createStringArrayList();
        this.fields = in.createStringArrayList();
        this.insertedBefore = (DateTime)in.readSerializable();
        this.originalPeriodFrom = (DateTime)in.readSerializable();
        this.originalPeriodTo = (DateTime)in.readSerializable();
        this.parsedData = in.readString();
        this.parsedDataExactKeys = in.createStringArrayList();
        this.parsedDataNameToOrderBy = in.readString();
        this.sort = in.readString();
        this.onlyUncleared = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.isFiltering = in.readInt() == 1;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        dest.writeString(this.orderBy);
        dest.writeValue((Object)this.take);
        dest.writeValue((Object)this.skip);
        dest.writeSerializable((Serializable)this.amountTo);
        dest.writeSerializable((Serializable)this.amountFrom);
        dest.writeList(this.categoryIds);
        dest.writeList(this.accountIds);
        dest.writeInt(this.accountTypeIds == null ? 0 : 1);
        dest.writeList(this.accountTypeIds);
        dest.writeStringList(this.accountIdentifiers);
        dest.writeList(this.merchantIds);
        dest.writeStringList(this.merchantTexts);
        dest.writeString(this.searchText);
        dest.writeStringList(this.tags);
        dest.writeSerializable((Serializable)this.periodTo);
        dest.writeSerializable((Serializable)this.periodFrom);
        dest.writeList(this.ids);
        dest.writeValue((Object)this.onlyUnread);
        dest.writeValue((Object)this.onlyUncertain);
        dest.writeValue((Object)this.onlyFlagged);
        dest.writeValue((Object)this.useExactMerchantTexts);
        dest.writeValue((Object)this.uncertainOrFlagged);
        dest.writeValue((Object)this.useAbsoluteAmountSearch);
        dest.writeValue((Object)this.useAccentInsensitiveSearch);
        dest.writeValue((Object)this.useAmountInCurrencySearch);
        dest.writeValue((Object)this.useAndSearchForTags);
        dest.writeValue((Object)this.useEqualsSearchForBankId);
        dest.writeValue((Object)this.useExactDescription);
        dest.writeValue((Object)this.useParentMerchantIds);
        dest.writeValue((Object)this.onlyUncategorized);
        dest.writeValue((Object)this.ascendingOrder);
        dest.writeValue((Object)this.hideExcluded);
        dest.writeStringList(this.bankIds);
        dest.writeList(this.categoryTypes);
        dest.writeString(this.comment);
        dest.writeStringList(this.counterpartyAccountIdentifiers);
        dest.writeString(this.description);
        dest.writeList(this.excludeMerchantIds);
        dest.writeStringList(this.excludeMerchantTexts);
        dest.writeStringList(this.fields);
        dest.writeSerializable((Serializable)this.insertedBefore);
        dest.writeSerializable((Serializable)this.originalPeriodFrom);
        dest.writeSerializable((Serializable)this.originalPeriodTo);
        dest.writeString(this.parsedData);
        dest.writeStringList(this.parsedDataExactKeys);
        dest.writeString(this.parsedDataNameToOrderBy);
        dest.writeString(this.sort);
        dest.writeValue((Object)this.onlyUncleared);
        dest.writeInt(this.isFiltering ? 1 : 0);
    }

    public Integer getNumItemsPerPage() {
        return this.take;
    }

    public Integer getPage() {
        return this.skip;
    }

    protected TransactionsFilter clone() throws CloneNotSupportedException {
        return (TransactionsFilter)super.clone();
    }

    public Map<String, String> toQueryMap() {
        Field[] allFields;
        ArrayList<Field> mappableFields = new ArrayList<Field>();
        for (Field field : allFields = TransactionsFilter.class.getDeclaredFields()) {
            if (!Modifier.isPrivate(field.getModifiers()) && !Modifier.isProtected(field.getModifiers())) continue;
            mappableFields.add(field);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Field skipField = null;
        Field takeField = null;
        ArrayList sortBy = new ArrayList();
        for (Field member : mappableFields) {
            if (member.getName().equals("isFiltering") || member.getName().equals("includeMerchants")) continue;
            if (member.getName().equals("includeAccounts") && (this.includeMerchants || this.includeAccounts)) {
                map.put("include", this.constructInclude());
                continue;
            }
            if (member.getName().equals("skip")) {
                skipField = member;
                continue;
            }
            if (member.getName().equals("take")) {
                takeField = member;
                continue;
            }
            this.addToMap(member, map);
        }
        if (skipField != null) {
            this.addToMap(skipField, map);
        }
        if (takeField != null) {
            this.addToMap(takeField, map);
        }
        sortBy.size();
        return map;
    }

    private String constructInclude() {
        String include = "";
        if (this.includeAccounts) {
            include = include + "Account";
        }
        if (this.includeMerchants) {
            if (include.length() > 0) {
                include = include + ",";
            }
            include = include + "Merchant";
        }
        return include;
    }

    private void addToMap(Field member, Map<String, String> map) {
        try {
            Object value = member.get(this);
            if (value != null && !member.getName().startsWith("$")) {
                if (value instanceof ArrayList && ((ArrayList)value).size() == 0) {
                    return;
                }
                map.put(member.getName(), this.fieldTypeToString(value));
            }
        }
        catch (IllegalAccessException ex) {
            ErrorHandler.reportAndHandle(ex);
        }
    }

    private String fieldTypeToString(Object fieldValue) {
        if (fieldValue instanceof MenigaDecimal) {
            return Double.toString(((MenigaDecimal)fieldValue).doubleValue());
        }
        if (fieldValue instanceof List) {
            StringBuilder bld = new StringBuilder();
            for (int i = 0; i < ((List)fieldValue).size(); ++i) {
                if (i > 0) {
                    bld.append(",");
                }
                Object item = ((List)fieldValue).get(i);
                bld.append(item);
            }
            return bld.toString();
        }
        if (fieldValue instanceof DateTime) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            return fmt.print((ReadableInstant)((DateTime)fieldValue));
        }
        if (fieldValue instanceof Boolean) {
            return Boolean.toString((Boolean)fieldValue);
        }
        return fieldValue.toString();
    }

    @Override
    public long getValueHash() {
        Gson gson2 = new Gson();
        String json = gson2.toJson((Object)this);
        return json.hashCode();
    }

    public String getType() {
        return this.type;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public Integer getTake() {
        return this.take;
    }

    public MenigaDecimal getAmountTo() {
        return this.amountTo;
    }

    public MenigaDecimal getAmountFrom() {
        return this.amountFrom;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public List<Long> getAccountIds() {
        return this.accountIds;
    }

    public List<Long> getAccountTypeIds() {
        return this.accountTypeIds;
    }

    public List<String> getAccountIdentifiers() {
        return this.accountIdentifiers;
    }

    public List<Long> getMerchantIds() {
        return this.merchantIds;
    }

    public List<String> getMerchantTexts() {
        return this.merchantTexts;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public DateTime getPeriodTo() {
        return this.periodTo;
    }

    public DateTime getPeriodFrom() {
        return this.periodFrom;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public Boolean getOnlyUnread() {
        return this.onlyUnread;
    }

    public Boolean getOnlyUncertain() {
        return this.onlyUncertain;
    }

    public Boolean getOnlyFlagged() {
        return this.onlyFlagged;
    }

    public Boolean getUseExactMerchantTexts() {
        return this.useExactMerchantTexts;
    }

    public Boolean getUncertainOrFlagged() {
        return this.uncertainOrFlagged;
    }

    public Boolean getUseAbsoluteAmountSearch() {
        return this.useAbsoluteAmountSearch;
    }

    public Boolean getUseAccentInsensitiveSearch() {
        return this.useAccentInsensitiveSearch;
    }

    public Boolean getUseAmountInCurrencySearch() {
        return this.useAmountInCurrencySearch;
    }

    public Boolean getUseAndSearchForTags() {
        return this.useAndSearchForTags;
    }

    public Boolean getUseEqualsSearchForBankId() {
        return this.useEqualsSearchForBankId;
    }

    public Boolean getUseExactDescription() {
        return this.useExactDescription;
    }

    public Boolean getUseParentMerchantIds() {
        return this.useParentMerchantIds;
    }

    public Boolean getOnlyUncategorized() {
        return this.onlyUncategorized;
    }

    public Boolean getAscendingOrder() {
        return this.ascendingOrder;
    }

    public Boolean getHideExcluded() {
        return this.hideExcluded;
    }

    public List<String> getBankIds() {
        return this.bankIds;
    }

    public List<CategoryType> getCategoryTypes() {
        return this.categoryTypes;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getCounterpartyAccountIdentifiers() {
        return this.counterpartyAccountIdentifiers;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Integer> getExcludeMerchantIds() {
        return this.excludeMerchantIds;
    }

    public List<String> getExcludeMerchantTexts() {
        return this.excludeMerchantTexts;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public DateTime getInsertedBefore() {
        return this.insertedBefore;
    }

    public DateTime getOriginalPeriodFrom() {
        return this.originalPeriodFrom;
    }

    public DateTime getOriginalPeriodTo() {
        return this.originalPeriodTo;
    }

    public String getParsedData() {
        return this.parsedData;
    }

    public List<String> getParsedDataExactKeys() {
        return this.parsedDataExactKeys;
    }

    public String getParsedDataNameToOrderBy() {
        return this.parsedDataNameToOrderBy;
    }

    public boolean getIncludeAccounts() {
        return this.includeAccounts;
    }

    public boolean getIncludeMerchants() {
        return this.includeMerchants;
    }

    public boolean getIsFiltering() {
        return this.isFiltering;
    }

    public List<String> getSort() {
        return Arrays.asList(this.sort.split(","));
    }

    @Nullable
    public Boolean getOnlyUncleared() {
        return this.onlyUncleared;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsFilter that = (TransactionsFilter)o;
        if (this.isFiltering != that.isFiltering) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.skip != null ? !this.skip.equals(that.skip) : that.skip != null) {
            return false;
        }
        if (this.take != null ? !this.take.equals(that.take) : that.take != null) {
            return false;
        }
        if (this.amountTo != null ? !this.amountTo.equals(that.amountTo) : that.amountTo != null) {
            return false;
        }
        if (this.amountFrom != null ? !this.amountFrom.equals(that.amountFrom) : that.amountFrom != null) {
            return false;
        }
        if (this.categoryIds != null ? !this.categoryIds.equals(that.categoryIds) : that.categoryIds != null) {
            return false;
        }
        if (this.accountIds != null ? !this.accountIds.equals(that.accountIds) : that.accountIds != null) {
            return false;
        }
        if (this.accountTypeIds != null ? !this.accountTypeIds.equals(that.accountTypeIds) : that.accountTypeIds != null) {
            return false;
        }
        if (this.accountIdentifiers != null ? !this.accountIdentifiers.equals(that.accountIdentifiers) : that.accountIdentifiers != null) {
            return false;
        }
        if (this.merchantIds != null ? !this.merchantIds.equals(that.merchantIds) : that.merchantIds != null) {
            return false;
        }
        if (this.merchantTexts != null ? !this.merchantTexts.equals(that.merchantTexts) : that.merchantTexts != null) {
            return false;
        }
        if (this.searchText != null ? !this.searchText.equals(that.searchText) : that.searchText != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.periodTo != null ? !this.periodTo.equals((Object)that.periodTo) : that.periodTo != null) {
            return false;
        }
        if (this.periodFrom != null ? !this.periodFrom.equals((Object)that.periodFrom) : that.periodFrom != null) {
            return false;
        }
        if (this.ids != null ? !this.ids.equals(that.ids) : that.ids != null) {
            return false;
        }
        if (this.onlyUnread != null ? !this.onlyUnread.equals(that.onlyUnread) : that.onlyUnread != null) {
            return false;
        }
        if (this.onlyUncertain != null ? !this.onlyUncertain.equals(that.onlyUncertain) : that.onlyUncertain != null) {
            return false;
        }
        if (this.onlyFlagged != null ? !this.onlyFlagged.equals(that.onlyFlagged) : that.onlyFlagged != null) {
            return false;
        }
        if (this.useExactMerchantTexts != null ? !this.useExactMerchantTexts.equals(that.useExactMerchantTexts) : that.useExactMerchantTexts != null) {
            return false;
        }
        if (this.uncertainOrFlagged != null ? !this.uncertainOrFlagged.equals(that.uncertainOrFlagged) : that.uncertainOrFlagged != null) {
            return false;
        }
        if (this.useAbsoluteAmountSearch != null ? !this.useAbsoluteAmountSearch.equals(that.useAbsoluteAmountSearch) : that.useAbsoluteAmountSearch != null) {
            return false;
        }
        if (this.useAccentInsensitiveSearch != null ? !this.useAccentInsensitiveSearch.equals(that.useAccentInsensitiveSearch) : that.useAccentInsensitiveSearch != null) {
            return false;
        }
        if (this.useAmountInCurrencySearch != null ? !this.useAmountInCurrencySearch.equals(that.useAmountInCurrencySearch) : that.useAmountInCurrencySearch != null) {
            return false;
        }
        if (this.useAndSearchForTags != null ? !this.useAndSearchForTags.equals(that.useAndSearchForTags) : that.useAndSearchForTags != null) {
            return false;
        }
        if (this.useEqualsSearchForBankId != null ? !this.useEqualsSearchForBankId.equals(that.useEqualsSearchForBankId) : that.useEqualsSearchForBankId != null) {
            return false;
        }
        if (this.useExactDescription != null ? !this.useExactDescription.equals(that.useExactDescription) : that.useExactDescription != null) {
            return false;
        }
        if (this.useParentMerchantIds != null ? !this.useParentMerchantIds.equals(that.useParentMerchantIds) : that.useParentMerchantIds != null) {
            return false;
        }
        if (this.onlyUncategorized != null ? !this.onlyUncategorized.equals(that.onlyUncategorized) : that.onlyUncategorized != null) {
            return false;
        }
        if (this.ascendingOrder != null ? !this.ascendingOrder.equals(that.ascendingOrder) : that.ascendingOrder != null) {
            return false;
        }
        if (this.hideExcluded != null ? !this.hideExcluded.equals(that.hideExcluded) : that.hideExcluded != null) {
            return false;
        }
        if (this.bankIds != null ? !this.bankIds.equals(that.bankIds) : that.bankIds != null) {
            return false;
        }
        if (this.categoryTypes != null ? !this.categoryTypes.equals(that.categoryTypes) : that.categoryTypes != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) {
            return false;
        }
        if (this.counterpartyAccountIdentifiers != null ? !this.counterpartyAccountIdentifiers.equals(that.counterpartyAccountIdentifiers) : that.counterpartyAccountIdentifiers != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.excludeMerchantIds != null ? !this.excludeMerchantIds.equals(that.excludeMerchantIds) : that.excludeMerchantIds != null) {
            return false;
        }
        if (this.excludeMerchantTexts != null ? !this.excludeMerchantTexts.equals(that.excludeMerchantTexts) : that.excludeMerchantTexts != null) {
            return false;
        }
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        if (this.insertedBefore != null ? !this.insertedBefore.equals((Object)that.insertedBefore) : that.insertedBefore != null) {
            return false;
        }
        if (this.originalPeriodFrom != null ? !this.originalPeriodFrom.equals((Object)that.originalPeriodFrom) : that.originalPeriodFrom != null) {
            return false;
        }
        if (this.originalPeriodTo != null ? !this.originalPeriodTo.equals((Object)that.originalPeriodTo) : that.originalPeriodTo != null) {
            return false;
        }
        if (this.parsedData != null ? !this.parsedData.equals(that.parsedData) : that.parsedData != null) {
            return false;
        }
        if (this.parsedDataExactKeys != null ? !this.parsedDataExactKeys.equals(that.parsedDataExactKeys) : that.parsedDataExactKeys != null) {
            return false;
        }
        if (this.parsedDataNameToOrderBy != null ? !this.parsedDataNameToOrderBy.equals(that.parsedDataNameToOrderBy) : that.parsedDataNameToOrderBy != null) {
            return false;
        }
        if (this.includeAccounts != that.includeAccounts) {
            return false;
        }
        if (this.includeMerchants != that.includeMerchants) {
            return false;
        }
        if (this.sort != null ? !this.sort.equals(that.sort) : that.sort != null) {
            return false;
        }
        return this.onlyUncleared == that.onlyUncleared;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.skip != null ? this.skip.hashCode() : 0);
        result = 31 * result + (this.take != null ? this.take.hashCode() : 0);
        result = 31 * result + (this.amountTo != null ? this.amountTo.hashCode() : 0);
        result = 31 * result + (this.amountFrom != null ? this.amountFrom.hashCode() : 0);
        result = 31 * result + (this.categoryIds != null ? this.categoryIds.hashCode() : 0);
        result = 31 * result + (this.accountIds != null ? this.accountIds.hashCode() : 0);
        result = 31 * result + (this.accountTypeIds != null ? this.accountTypeIds.hashCode() : 0);
        result = 31 * result + (this.accountIdentifiers != null ? this.accountIdentifiers.hashCode() : 0);
        result = 31 * result + (this.merchantIds != null ? this.merchantIds.hashCode() : 0);
        result = 31 * result + (this.merchantTexts != null ? this.merchantTexts.hashCode() : 0);
        result = 31 * result + (this.searchText != null ? this.searchText.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.periodTo != null ? this.periodTo.hashCode() : 0);
        result = 31 * result + (this.periodFrom != null ? this.periodFrom.hashCode() : 0);
        result = 31 * result + (this.ids != null ? this.ids.hashCode() : 0);
        result = 31 * result + (this.onlyUnread != null ? this.onlyUnread.hashCode() : 0);
        result = 31 * result + (this.onlyUncertain != null ? this.onlyUncertain.hashCode() : 0);
        result = 31 * result + (this.onlyFlagged != null ? this.onlyFlagged.hashCode() : 0);
        result = 31 * result + (this.useExactMerchantTexts != null ? this.useExactMerchantTexts.hashCode() : 0);
        result = 31 * result + (this.uncertainOrFlagged != null ? this.uncertainOrFlagged.hashCode() : 0);
        result = 31 * result + (this.useAbsoluteAmountSearch != null ? this.useAbsoluteAmountSearch.hashCode() : 0);
        result = 31 * result + (this.useAccentInsensitiveSearch != null ? this.useAccentInsensitiveSearch.hashCode() : 0);
        result = 31 * result + (this.useAmountInCurrencySearch != null ? this.useAmountInCurrencySearch.hashCode() : 0);
        result = 31 * result + (this.useAndSearchForTags != null ? this.useAndSearchForTags.hashCode() : 0);
        result = 31 * result + (this.useEqualsSearchForBankId != null ? this.useEqualsSearchForBankId.hashCode() : 0);
        result = 31 * result + (this.useExactDescription != null ? this.useExactDescription.hashCode() : 0);
        result = 31 * result + (this.useParentMerchantIds != null ? this.useParentMerchantIds.hashCode() : 0);
        result = 31 * result + (this.onlyUncategorized != null ? this.onlyUncategorized.hashCode() : 0);
        result = 31 * result + (this.ascendingOrder != null ? this.ascendingOrder.hashCode() : 0);
        result = 31 * result + (this.hideExcluded != null ? this.hideExcluded.hashCode() : 0);
        result = 31 * result + (this.bankIds != null ? this.bankIds.hashCode() : 0);
        result = 31 * result + (this.categoryTypes != null ? this.categoryTypes.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.counterpartyAccountIdentifiers != null ? this.counterpartyAccountIdentifiers.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.excludeMerchantIds != null ? this.excludeMerchantIds.hashCode() : 0);
        result = 31 * result + (this.excludeMerchantTexts != null ? this.excludeMerchantTexts.hashCode() : 0);
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        result = 31 * result + (this.insertedBefore != null ? this.insertedBefore.hashCode() : 0);
        result = 31 * result + (this.originalPeriodFrom != null ? this.originalPeriodFrom.hashCode() : 0);
        result = 31 * result + (this.originalPeriodTo != null ? this.originalPeriodTo.hashCode() : 0);
        result = 31 * result + (this.parsedData != null ? this.parsedData.hashCode() : 0);
        result = 31 * result + (this.parsedDataExactKeys != null ? this.parsedDataExactKeys.hashCode() : 0);
        result = 31 * result + (this.parsedDataNameToOrderBy != null ? this.parsedDataNameToOrderBy.hashCode() : 0);
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + (this.onlyUncleared != null ? this.onlyUncleared.hashCode() : 0);
        result = 31 * result + (this.includeAccounts ? 1 : 0);
        result = 31 * result + (this.includeMerchants ? 1 : 0);
        result = 31 * result + (this.isFiltering ? 1 : 0);
        return result;
    }

    public static class Builder {
        private String type;
        private String orderBy;
        private Integer take = 50;
        private Integer skip = 0;
        private MenigaDecimal amountTo;
        private MenigaDecimal amountFrom;
        private List<Long> categoryIds;
        private List<Long> accountIds;
        private List<Long> accountTypeIds;
        private List<String> accountIdentifiers;
        private List<Long> merchantIds;
        private List<String> merchantTexts;
        private String searchText;
        private List<String> tags;
        private DateTime periodTo;
        private DateTime periodFrom;
        private List<Long> ids;
        private Boolean onlyUnread;
        private Boolean onlyUncertain;
        private Boolean onlyFlagged;
        private Boolean useExactMerchantTexts;
        private Boolean uncertainOrFlagged;
        private Boolean useAbsoluteAmountSearch;
        private Boolean useAccentInsensitiveSearch;
        private Boolean useAmountInCurrencySearch;
        private Boolean useAndSearchForTags;
        private Boolean useEqualsSearchForBankId;
        private Boolean useExactDescription;
        private Boolean useParentMerchantIds;
        private Boolean onlyUncategorized;
        private Boolean ascendingOrder;
        private Boolean hideExcluded;
        private List<String> bankIds;
        private List<CategoryType> categoryTypes;
        private String comment;
        private List<String> counterpartyAccountIdentifiers;
        private String description;
        private List<Integer> excludeMerchantIds;
        private List<String> excludeMerchantTexts;
        private List<String> fields;
        private DateTime insertedBefore;
        private DateTime originalPeriodFrom;
        private DateTime originalPeriodTo;
        private String parsedData;
        private List<String> parsedDataExactKeys;
        private String parsedDataNameToOrderBy;
        private boolean includeAccounts = true;
        private boolean includeMerchants = true;
        private String sort;
        private Boolean onlyUncleared;
        private boolean isFiltering;

        public Builder() {
        }

        public Builder(TransactionsFilter filter) {
            this.consumeExistingFilter(filter);
        }

        public static Builder createBuilderFromExistingFilter(TransactionsFilter filterToCopy) {
            return new Builder(filterToCopy);
        }

        private void consumeExistingFilter(TransactionsFilter filter) {
            if (filter != null) {
                this.type = filter.type;
                this.orderBy = filter.orderBy;
                this.take = filter.take;
                this.skip = filter.skip;
                this.searchText = this.preserveNonNull(filter.searchText, this.searchText);
                this.amountFrom = this.preserveNonNull(filter.amountFrom, this.amountFrom);
                this.amountTo = this.preserveNonNull(filter.amountTo, this.amountTo);
                this.categoryIds = this.preserveNonNull(filter.categoryIds, this.categoryIds);
                this.accountIds = this.preserveNonNull(filter.accountIds, this.accountIds);
                this.accountTypeIds = this.preserveNonNull(filter.accountTypeIds, this.accountTypeIds);
                this.merchantIds = this.preserveNonNull(filter.merchantIds, this.merchantIds);
                this.merchantTexts = this.preserveNonNull(filter.merchantTexts, this.merchantTexts);
                this.tags = this.preserveNonNull(filter.tags, this.tags);
                this.periodFrom = this.preserveNonNull(filter.periodFrom, this.periodFrom);
                this.periodTo = this.preserveNonNull(filter.periodTo, this.periodTo);
                this.ids = this.preserveNonNull(filter.ids, this.ids);
                this.onlyUnread = this.preserveNonNull(filter.onlyUnread, this.onlyUnread);
                this.onlyUncertain = this.preserveNonNull(filter.onlyUncertain, this.onlyUncertain);
                this.onlyFlagged = this.preserveNonNull(filter.onlyFlagged, this.onlyFlagged);
                this.useExactMerchantTexts = this.preserveNonNull(filter.useExactMerchantTexts, this.useExactMerchantTexts);
                this.ascendingOrder = this.preserveNonNull(filter.ascendingOrder, this.ascendingOrder);
                this.accountIdentifiers = this.preserveNonNull(filter.accountIdentifiers, this.accountIdentifiers);
                this.bankIds = this.preserveNonNull(filter.bankIds, this.bankIds);
                this.categoryTypes = this.preserveNonNull(filter.categoryTypes, this.categoryTypes);
                this.comment = this.preserveNonNull(filter.comment, this.comment);
                this.counterpartyAccountIdentifiers = this.preserveNonNull(filter.counterpartyAccountIdentifiers, this.counterpartyAccountIdentifiers);
                this.description = this.preserveNonNull(filter.description, this.description);
                this.excludeMerchantIds = this.preserveNonNull(filter.excludeMerchantIds, this.excludeMerchantIds);
                this.excludeMerchantTexts = this.preserveNonNull(filter.excludeMerchantTexts, this.excludeMerchantTexts);
                this.fields = this.preserveNonNull(filter.fields, this.fields);
                this.hideExcluded = this.preserveNonNull(filter.hideExcluded, this.hideExcluded);
                this.uncertainOrFlagged = this.preserveNonNull(filter.uncertainOrFlagged, this.uncertainOrFlagged);
                this.onlyUncategorized = this.preserveNonNull(filter.onlyUncategorized, this.onlyUncategorized);
                this.useAbsoluteAmountSearch = this.preserveNonNull(filter.useAbsoluteAmountSearch, this.useAbsoluteAmountSearch);
                this.useAccentInsensitiveSearch = this.preserveNonNull(filter.useAccentInsensitiveSearch, this.useAccentInsensitiveSearch);
                this.useAmountInCurrencySearch = this.preserveNonNull(filter.useAmountInCurrencySearch, this.useAmountInCurrencySearch);
                this.useAndSearchForTags = this.preserveNonNull(filter.useAndSearchForTags, this.useAndSearchForTags);
                this.useEqualsSearchForBankId = this.preserveNonNull(filter.useEqualsSearchForBankId, this.useEqualsSearchForBankId);
                this.useExactDescription = this.preserveNonNull(filter.useExactDescription, this.useExactDescription);
                this.useParentMerchantIds = this.preserveNonNull(filter.useParentMerchantIds, this.useParentMerchantIds);
                this.insertedBefore = this.preserveNonNull(filter.insertedBefore, this.insertedBefore);
                this.originalPeriodFrom = this.preserveNonNull(filter.originalPeriodFrom, this.originalPeriodFrom);
                this.originalPeriodTo = this.preserveNonNull(filter.originalPeriodTo, this.originalPeriodTo);
                this.parsedData = this.preserveNonNull(filter.parsedData, this.parsedData);
                this.parsedDataExactKeys = this.preserveNonNull(filter.parsedDataExactKeys, this.parsedDataExactKeys);
                this.parsedDataNameToOrderBy = this.preserveNonNull(filter.parsedDataNameToOrderBy, this.parsedDataNameToOrderBy);
                this.includeAccounts = this.preserveNonNull(filter.includeAccounts, this.includeAccounts);
                this.includeMerchants = this.preserveNonNull(filter.includeMerchants, this.includeMerchants);
                this.isFiltering = this.preserveNonNull(filter.isFiltering, this.isFiltering);
                this.sort = this.preserveNonNull(filter.sort, this.sort);
                this.onlyUncleared = this.preserveNonNull(filter.onlyUncleared, this.onlyUncleared);
            }
        }

        private <T> T preserveNonNull(T otherField, T myField) {
            return otherField == null && myField != null ? myField : otherField;
        }

        public Builder type(String type2) {
            this.type = type2;
            this.isFiltering = true;
            return this;
        }

        public Builder orderBy(SeriesOrderBy order) {
            this.orderBy = order.toString();
            this.isFiltering = true;
            return this;
        }

        public Builder ascendingOrder(boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            this.isFiltering = true;
            return this;
        }

        public Builder page(int numPerPage, int pageIndex) {
            this.take = numPerPage;
            this.skip = numPerPage * pageIndex;
            this.isFiltering = true;
            return this;
        }

        public Builder searchText(String searchText) {
            this.searchText = searchText;
            this.isFiltering = true;
            return this;
        }

        public Builder hideExcluded(boolean hideExcluded) {
            this.hideExcluded = hideExcluded;
            this.isFiltering = true;
            return this;
        }

        public Builder useExactMerchantTexts(boolean useExactMerchantTexts) {
            this.useExactMerchantTexts = useExactMerchantTexts;
            this.isFiltering = true;
            return this;
        }

        public Builder uncertainOrFlagged(boolean uncertainOrFlagged) {
            this.uncertainOrFlagged = uncertainOrFlagged;
            this.isFiltering = true;
            return this;
        }

        public Builder useAbsoluteAmountSearch(boolean useAbsoluteAmountSearch) {
            this.useAbsoluteAmountSearch = useAbsoluteAmountSearch;
            this.isFiltering = true;
            return this;
        }

        public Builder useAccentInsensitiveSearch(boolean useAccentInsensitiveSearch) {
            this.useAccentInsensitiveSearch = useAccentInsensitiveSearch;
            this.isFiltering = true;
            return this;
        }

        public Builder useAmountInCurrencySearch(boolean useAmountInCurrencySearch) {
            this.useAmountInCurrencySearch = useAmountInCurrencySearch;
            this.isFiltering = true;
            return this;
        }

        public Builder useAndSearchForTags(boolean useAndSearchForTags) {
            this.useAndSearchForTags = useAndSearchForTags;
            this.isFiltering = true;
            return this;
        }

        public Builder useEqualsSearchForBankId(boolean useEqualsSearchForBankId) {
            this.useEqualsSearchForBankId = useEqualsSearchForBankId;
            this.isFiltering = true;
            return this;
        }

        public Builder useExactDescription(boolean useExactDescription) {
            this.useExactDescription = useExactDescription;
            this.isFiltering = true;
            return this;
        }

        public Builder useParentMerchantIds(boolean useParentMerchantIds) {
            this.useParentMerchantIds = useParentMerchantIds;
            this.isFiltering = true;
            return this;
        }

        public Builder onlyUncategorized(boolean onlyUncategorized) {
            this.onlyUncategorized = onlyUncategorized;
            this.isFiltering = true;
            return this;
        }

        public Builder amounts(MenigaDecimal from, MenigaDecimal to) {
            this.amountFrom = from;
            this.amountTo = to;
            this.isFiltering = true;
            return this;
        }

        public Builder categories(List<Long> categoryIds) {
            this.categoryIds = categoryIds;
            this.isFiltering = true;
            return this;
        }

        public Builder categories(ArrayList<MenigaCategory> categories) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            for (MenigaCategory category : categories) {
                categoryIds.add(category.getId());
            }
            this.categoryIds = categoryIds;
            this.isFiltering = true;
            return this;
        }

        public Builder category(long categoryId) {
            this.categoryIds = new ArrayList<Long>();
            this.categoryIds.add(categoryId);
            this.isFiltering = true;
            return this;
        }

        public Builder bankIds(List<String> bankIds) {
            this.bankIds = bankIds;
            this.isFiltering = true;
            return this;
        }

        public Builder categoryTypes(List<CategoryType> categoryTypes) {
            this.categoryTypes = categoryTypes;
            this.isFiltering = true;
            return this;
        }

        public Builder categoryType(CategoryType categoryType) {
            ArrayList<CategoryType> list = new ArrayList<CategoryType>();
            list.add(categoryType);
            this.categoryTypes = list;
            this.isFiltering = true;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.isFiltering = true;
            return this;
        }

        public Builder counterpartyAccountIdentifiers(List<String> counterpartyAccountIdentifiers) {
            this.counterpartyAccountIdentifiers = counterpartyAccountIdentifiers;
            this.isFiltering = true;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.isFiltering = true;
            return this;
        }

        public Builder excludeMerchantIds(List<Integer> excludeMerchantIds) {
            this.excludeMerchantIds = excludeMerchantIds;
            this.isFiltering = true;
            return this;
        }

        public Builder excludeMerchantTexts(List<String> excludeMerchantTexts) {
            this.excludeMerchantTexts = excludeMerchantTexts;
            this.isFiltering = true;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            this.isFiltering = true;
            return this;
        }

        public Builder insertedBefore(DateTime insertedBefore) {
            this.insertedBefore = insertedBefore;
            this.isFiltering = true;
            return this;
        }

        public Builder accountIds(List<Long> accountIds) {
            this.accountIds = accountIds;
            this.isFiltering = true;
            return this;
        }

        public Builder accountTypeIds(List<Long> accountTypeIds) {
            this.accountTypeIds = accountTypeIds;
            this.isFiltering = true;
            return this;
        }

        public Builder accounts(List<MenigaAccount> accounts) {
            this.accountIds = new ArrayList<Long>();
            for (MenigaAccount acc : accounts) {
                this.accountIds.add(acc.getId());
            }
            this.isFiltering = true;
            return this;
        }

        public Builder account(long accountId) {
            this.accountIds = new ArrayList<Long>();
            this.accountIds.add(accountId);
            this.isFiltering = true;
            return this;
        }

        public Builder accountIdentifiers(List<String> accountIdentifiers) {
            this.accountIdentifiers = accountIdentifiers;
            this.isFiltering = true;
            return this;
        }

        public Builder merchantIds(List<Long> merchantIds) {
            this.merchantIds = merchantIds;
            this.isFiltering = true;
            return this;
        }

        public Builder merchantId(long merchantId) {
            this.merchantIds = new ArrayList<Long>();
            this.merchantIds.add(merchantId);
            this.isFiltering = true;
            return this;
        }

        public Builder merchantTexts(List<String> merchantTexts) {
            this.merchantTexts = merchantTexts;
            this.isFiltering = true;
            return this;
        }

        public Builder disableSkipTake() {
            this.skip = null;
            this.take = null;
            this.isFiltering = true;
            return this;
        }

        public Builder merchantText(String merchantText) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(merchantText);
            this.merchantTexts = list;
            this.isFiltering = true;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.isFiltering = true;
            return this;
        }

        public Builder tag(String tag) {
            this.tags = new ArrayList<String>();
            this.tags.add(tag);
            this.isFiltering = true;
            return this;
        }

        public Builder period(DateTime periodFrom, DateTime periodTo) {
            this.periodFrom = periodFrom;
            this.periodTo = periodTo;
            this.isFiltering = true;
            return this;
        }

        public Builder periodFrom(DateTime periodFrom) {
            this.periodFrom = periodFrom;
            this.isFiltering = true;
            return this;
        }

        public Builder periodTo(DateTime periodTo) {
            this.periodTo = periodTo;
            this.isFiltering = true;
            return this;
        }

        public Builder originalPeriod(DateTime originalPeriodFrom, DateTime originalPeriodTo) {
            this.originalPeriodFrom = originalPeriodFrom;
            this.originalPeriodTo = originalPeriodTo;
            this.isFiltering = true;
            return this;
        }

        public Builder parsedData(String parsedData) {
            this.parsedData = parsedData;
            this.isFiltering = true;
            return this;
        }

        public Builder parsedDataExactKeys(List<String> parsedDataExactKeys) {
            this.parsedDataExactKeys = parsedDataExactKeys;
            this.isFiltering = true;
            return this;
        }

        public Builder parsedDataNameToOrderBy(String parsedDataNameToOrderBy) {
            this.parsedDataNameToOrderBy = parsedDataNameToOrderBy;
            this.isFiltering = true;
            return this;
        }

        public Builder includeAccounts(boolean includeAccounts) {
            this.includeAccounts = includeAccounts;
            return this;
        }

        public Builder includeMerchants(boolean includeMerchants) {
            this.includeMerchants = includeMerchants;
            return this;
        }

        public Builder transactions(List<Long> transactionIds) {
            this.ids = transactionIds;
            this.isFiltering = true;
            return this;
        }

        public Builder onlyUnread(boolean onlyUnread) {
            this.onlyUnread = onlyUnread;
            this.isFiltering = true;
            return this;
        }

        public Builder onlyFlagged(boolean onlyFlagged) {
            this.onlyFlagged = onlyFlagged;
            this.isFiltering = true;
            return this;
        }

        public Builder onlyUncertain(boolean onlyUncertain) {
            this.onlyUncertain = onlyUncertain;
            this.isFiltering = true;
            return this;
        }

        public Builder addSortAscending(@Nonnull TransactionSortField field) {
            this.addSort(field.toString());
            return this;
        }

        public Builder addSortAscending(@Nonnull String field) {
            this.addSort(field);
            return this;
        }

        public Builder sortAscending(@Nullable List<TransactionSortField> fields) {
            if (fields == null) {
                this.sort = null;
            } else {
                this.sort = "";
                for (TransactionSortField field : fields) {
                    this.addSort(field.toString());
                }
            }
            return this;
        }

        public Builder addSortDescending(@Nonnull TransactionSortField field) {
            this.addSort("-" + field.toString());
            return this;
        }

        public Builder addSortDescending(@Nonnull String field) {
            this.addSort("-" + field);
            return this;
        }

        public Builder sortDescending(@Nullable List<TransactionSortField> fields) {
            if (fields == null) {
                this.sort = null;
            } else {
                this.sort = "";
                for (TransactionSortField field : fields) {
                    this.addSort("-" + field.toString());
                }
            }
            return this;
        }

        private void addSort(String field) {
            if (this.sort == null) {
                this.sort = "";
            }
            if (this.sort.length() > 0) {
                this.sort = this.sort + ",";
            }
            this.sort = this.sort + field;
        }

        public Builder onlyUncleared(boolean onlyUncleared) {
            this.onlyUncleared = onlyUncleared;
            return this;
        }

        public Builder mergeFilters(TransactionsFilter filter1, TransactionsFilter filter2) {
            this.consumeExistingFilter(filter1);
            this.consumeExistingFilter(filter2);
            return this;
        }

        public TransactionsFilter build() {
            return new TransactionsFilter(this);
        }
    }
}

