/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.models.transactions.enums.TimeResolution;
import java.io.Serializable;

public class Options
implements Serializable,
Parcelable {
    public static final Parcelable.Creator<Options> CREATOR = new Parcelable.Creator<Options>(){

        public Options createFromParcel(Parcel source) {
            return new Options(source);
        }

        public Options[] newArray(int size) {
            return new Options[size];
        }
    };
    protected TimeResolution timeResolution;
    protected boolean overTime = true;
    protected Boolean includeTransactions;
    protected Boolean includeTransactionIds;

    public Options(TimeResolution tr, boolean overTime) {
        this(tr, overTime, null, null);
    }

    public Options(TimeResolution tr, boolean overTime, Boolean includeTransactions) {
        this(tr, overTime, includeTransactions, null);
    }

    public Options(TimeResolution tr, boolean overTime, Boolean includeTransactions, Boolean includeTransactionIds) {
        this.timeResolution = tr;
        this.overTime = overTime;
        this.includeTransactions = includeTransactions;
        this.includeTransactionIds = includeTransactionIds;
    }

    protected Options(Parcel in) {
        int tmpTimeResolution = in.readInt();
        this.timeResolution = tmpTimeResolution == -1 ? null : TimeResolution.values()[tmpTimeResolution];
        this.overTime = in.readByte() != 0;
        this.includeTransactions = in.readByte() != 0;
        this.includeTransactionIds = in.readByte() != 0;
    }

    public TimeResolution getTimeResolution() {
        return this.timeResolution;
    }

    public boolean isOverTime() {
        return this.overTime;
    }

    public boolean isIncludeTransactions() {
        return this.includeTransactions;
    }

    public boolean isIncludeTransactionIds() {
        return this.includeTransactionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        if (this.overTime != options.overTime) {
            return false;
        }
        if (this.includeTransactions != options.includeTransactions) {
            return false;
        }
        if (this.includeTransactionIds != options.includeTransactionIds) {
            return false;
        }
        return this.timeResolution == options.timeResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.timeResolution == null ? -1 : this.timeResolution.ordinal());
        dest.writeByte(this.overTime ? (byte)1 : 0);
        dest.writeByte(this.includeTransactions != false ? (byte)1 : 0);
        dest.writeByte(this.includeTransactionIds != false ? (byte)1 : 0);
    }

    public int hashCode() {
        int result = this.timeResolution != null ? this.timeResolution.hashCode() : 0;
        result = 31 * result + (this.overTime ? 1 : 0);
        result = 31 * result + (this.includeTransactions != null ? this.includeTransactions.hashCode() : 0);
        result = 31 * result + (this.includeTransactionIds != null ? this.includeTransactionIds.hashCode() : 0);
        return result;
    }
}

