/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.transactions.MenigaTransaction;
import com.meniga.sdk.models.transactions.Options;
import com.meniga.sdk.models.transactions.SeriesSelector;
import com.meniga.sdk.models.transactions.Statistics;
import com.meniga.sdk.models.transactions.TransactionsFilter;
import com.meniga.sdk.models.transactions.Value;
import com.meniga.sdk.models.transactions.enums.TimeResolution;
import com.meniga.sdk.models.transactions.operators.MenigaTransactionSeriesOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenigaTransactionSeries
implements Serializable,
Parcelable,
Cloneable {
    public static final Parcelable.Creator<MenigaTransactionSeries> CREATOR = new Parcelable.Creator<MenigaTransactionSeries>(){

        public MenigaTransactionSeries createFromParcel(Parcel source) {
            return new MenigaTransactionSeries(source);
        }

        public MenigaTransactionSeries[] newArray(int size) {
            return new MenigaTransactionSeries[size];
        }
    };
    protected static MenigaTransactionSeriesOperations apiOperator;
    protected TimeResolution timeResolution;
    protected Statistics statistics;
    protected List<Value> values;
    protected List<MenigaTransaction> transactions;
    protected List<Long> transactionIds;

    protected MenigaTransactionSeries() {
    }

    protected MenigaTransactionSeries(Parcel in) {
        int tmpTimeResolution = in.readInt();
        this.timeResolution = tmpTimeResolution == -1 ? null : TimeResolution.values()[tmpTimeResolution];
        this.statistics = (Statistics)in.readParcelable(Statistics.class.getClassLoader());
        this.values = in.createTypedArrayList(Value.CREATOR);
        this.transactions = in.createTypedArrayList(MenigaTransaction.CREATOR);
        this.transactionIds = new ArrayList<Long>();
        in.readList(this.transactionIds, Long.class.getClassLoader());
    }

    public static void setOperator(MenigaTransactionSeriesOperations operator) {
        apiOperator = operator;
    }

    public int describeContents() {
        return 0;
    }

    protected MenigaTransactionSeries clone() throws CloneNotSupportedException {
        return (MenigaTransactionSeries)super.clone();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.timeResolution == null ? -1 : this.timeResolution.ordinal());
        dest.writeParcelable((Parcelable)this.statistics, flags);
        dest.writeTypedList(this.values);
        dest.writeTypedList(this.transactions);
        dest.writeList(this.transactionIds);
    }

    public MenigaDecimal getSumNettoValues() {
        MenigaDecimal sum = new MenigaDecimal(0);
        for (Value val : this.values) {
            sum = sum.add(val.getNettoAmount());
        }
        return sum;
    }

    public TimeResolution getTimeResolution() {
        return this.timeResolution;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public List<MenigaTransaction> getTransactions() {
        return this.transactions;
    }

    public List<Long> getTransactionIds() {
        return this.transactionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaTransactionSeries that = (MenigaTransactionSeries)o;
        if (this.timeResolution != that.timeResolution) {
            return false;
        }
        if (this.statistics != null ? !this.statistics.equals(that.statistics) : that.statistics != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (this.transactions != null ? !this.transactions.equals(that.transactions) : that.transactions != null) {
            return false;
        }
        return this.transactionIds != null ? this.transactionIds.equals(that.transactionIds) : that.transactionIds == null;
    }

    public int hashCode() {
        int result = this.timeResolution != null ? this.timeResolution.hashCode() : 0;
        result = 31 * result + (this.statistics != null ? this.statistics.hashCode() : 0);
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        result = 31 * result + (this.transactions != null ? this.transactions.hashCode() : 0);
        result = 31 * result + (this.transactionIds != null ? this.transactionIds.hashCode() : 0);
        return result;
    }

    public static Result<List<MenigaTransactionSeries>> fetch(TransactionsFilter filter, Options options, List<SeriesSelector> seriesSelectors) {
        return apiOperator.getTransactionSeries(filter, options, seriesSelectors);
    }
}

