/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.transactions.operators.MenigaCommentOperations;
import java.io.Serializable;
import org.joda.time.DateTime;

public class MenigaComment
implements Parcelable,
Serializable,
Cloneable {
    public static final Parcelable.Creator<MenigaComment> CREATOR = new Parcelable.Creator<MenigaComment>(){

        public MenigaComment createFromParcel(Parcel source) {
            return new MenigaComment(source);
        }

        public MenigaComment[] newArray(int size) {
            return new MenigaComment[size];
        }
    };
    protected static MenigaCommentOperations apiOperator;
    protected long id;
    protected long transactionId;
    protected long personId;
    protected String comment;
    protected DateTime createdDate;

    protected MenigaComment() {
    }

    protected MenigaComment(Parcel in) {
        this.id = in.readLong();
        this.personId = in.readLong();
        this.comment = in.readString();
        this.createdDate = new DateTime(in.readLong());
    }

    public static void setOperator(MenigaCommentOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public long getPersonId() {
        return this.personId;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public MenigaComment clone() throws CloneNotSupportedException {
        return (MenigaComment)super.clone();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.personId);
        dest.writeString(this.comment);
        dest.writeLong(this.createdDate.getMillis());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaComment that = (MenigaComment)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.personId != that.personId) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) {
            return false;
        }
        return this.createdDate != null ? this.createdDate.equals((Object)that.createdDate) : that.createdDate == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.personId ^ this.personId >>> 32);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        return result;
    }

    public Result<Void> update() {
        return apiOperator.updateComment(this);
    }

    public Result<Void> delete() {
        return apiOperator.deleteComment(this.transactionId, this.id);
    }

    public static Result<MenigaComment> create(final long transactionId, String comment) {
        Result<MenigaComment> task2 = apiOperator.createComment(transactionId, comment);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaComment>(){

            @Override
            public void onFinished(MenigaComment result, boolean failed) {
                if (!failed && result != null) {
                    result.transactionId = transactionId;
                }
            }
        });
    }
}

