/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.sync;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.sync.AccountSyncResult;
import java.io.Serializable;
import org.joda.time.DateTime;

public class AccountSyncStatus
implements Serializable,
Parcelable {
    protected long accountId;
    protected Integer transactionsProcessed;
    protected MenigaDecimal balance;
    protected MenigaDecimal limit;
    protected Integer totalTransactions;
    protected DateTime startDate;
    protected DateTime endDate;
    protected String accountStatus;
    protected AccountSyncResult status;
    public static final Parcelable.Creator<AccountSyncStatus> CREATOR = new Parcelable.Creator<AccountSyncStatus>(){

        public AccountSyncStatus createFromParcel(Parcel source) {
            return new AccountSyncStatus(source);
        }

        public AccountSyncStatus[] newArray(int size) {
            return new AccountSyncStatus[size];
        }
    };

    protected AccountSyncStatus() {
    }

    protected AccountSyncStatus(Parcel in) {
        this.accountId = in.readLong();
        this.transactionsProcessed = (Integer)in.readValue(Integer.class.getClassLoader());
        this.balance = (MenigaDecimal)in.readSerializable();
        this.limit = (MenigaDecimal)in.readSerializable();
        this.totalTransactions = (Integer)in.readValue(Integer.class.getClassLoader());
        this.startDate = (DateTime)in.readSerializable();
        this.endDate = (DateTime)in.readSerializable();
        this.accountStatus = in.readString();
        int tmpStatus = in.readInt();
        this.status = tmpStatus == -1 ? null : AccountSyncResult.values()[tmpStatus];
    }

    public Integer getTransactionsProcessed() {
        return this.transactionsProcessed;
    }

    public MenigaDecimal getBalance() {
        return this.balance;
    }

    public MenigaDecimal getLimit() {
        return this.limit;
    }

    public Integer getTotalTransactions() {
        return this.totalTransactions;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public String getAccountStatus() {
        return this.accountStatus;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public AccountSyncResult getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSyncStatus that = (AccountSyncStatus)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (this.transactionsProcessed != null ? !this.transactionsProcessed.equals(that.transactionsProcessed) : that.transactionsProcessed != null) {
            return false;
        }
        if (this.balance != null ? !this.balance.equals(that.balance) : that.balance != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.totalTransactions != null ? !this.totalTransactions.equals(that.totalTransactions) : that.totalTransactions != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals((Object)that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals((Object)that.endDate) : that.endDate != null) {
            return false;
        }
        if (this.accountStatus != null ? !this.accountStatus.equals(that.accountStatus) : that.accountStatus != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.transactionsProcessed != null ? this.transactionsProcessed.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.totalTransactions != null ? this.totalTransactions.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.accountStatus != null ? this.accountStatus.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.accountId);
        dest.writeValue((Object)this.transactionsProcessed);
        dest.writeSerializable((Serializable)this.balance);
        dest.writeSerializable((Serializable)this.limit);
        dest.writeValue((Object)this.totalTransactions);
        dest.writeSerializable((Serializable)this.startDate);
        dest.writeSerializable((Serializable)this.endDate);
        dest.writeString(this.accountStatus);
        dest.writeInt(this.status == null ? -1 : this.status.ordinal());
    }
}

