/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.serverpublic;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.serverpublic.operators.MenigaPublicSettingsOperations;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class MenigaPublicSettings
implements Serializable,
Parcelable,
Cloneable {
    public static final Parcelable.Creator<MenigaPublicSettings> CREATOR = new Parcelable.Creator<MenigaPublicSettings>(){

        public MenigaPublicSettings createFromParcel(Parcel source) {
            return new MenigaPublicSettings(source);
        }

        public MenigaPublicSettings[] newArray(int size) {
            return new MenigaPublicSettings[size];
        }
    };
    private static final String DEFAULT_NUMBER_FORMAT = "#,##0.00";
    protected static MenigaPublicSettingsOperations apiOperator;
    protected String defaultCultureName;
    protected String systemCurrency;
    protected String numberFormat;
    protected String currencyFormat;
    protected String currencyFormatUsingCode;
    protected String clusterNodeName;
    protected int currencyRoundOff;
    protected int currencyDecimalDigits;
    protected List<MenigaCurrency> currencies;
    protected String currentCulture;
    protected String currencyGroupSymbol;
    protected String currencyDecimalSymbol;

    protected MenigaPublicSettings() {
    }

    protected MenigaPublicSettings(Parcel in) {
        this.defaultCultureName = in.readString();
        this.systemCurrency = in.readString();
        this.numberFormat = in.readString();
        this.currencyFormat = in.readString();
        this.currencyFormatUsingCode = in.readString();
        this.clusterNodeName = in.readString();
        this.currencyRoundOff = in.readInt();
        this.currencyDecimalDigits = in.readInt();
        this.currencies = in.createTypedArrayList(MenigaCurrency.CREATOR);
        this.currentCulture = in.readString();
        this.currencyGroupSymbol = in.readString();
        this.currencyDecimalSymbol = in.readString();
    }

    protected MenigaPublicSettings clone() throws CloneNotSupportedException {
        return (MenigaPublicSettings)super.clone();
    }

    public static void setOperator(MenigaPublicSettingsOperations operator) {
        apiOperator = operator;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.defaultCultureName);
        dest.writeString(this.systemCurrency);
        dest.writeString(this.numberFormat);
        dest.writeString(this.currencyFormat);
        dest.writeString(this.currencyFormatUsingCode);
        dest.writeString(this.clusterNodeName);
        dest.writeInt(this.currencyRoundOff);
        dest.writeInt(this.currencyDecimalDigits);
        dest.writeTypedList(this.currencies);
        dest.writeString(this.currentCulture);
        dest.writeString(this.currencyGroupSymbol);
        dest.writeString(this.currencyDecimalSymbol);
    }

    public String getDefaultCultureName() {
        return this.defaultCultureName;
    }

    public String getSystemCurrency() {
        return this.systemCurrency;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public String getCurrencyFormat() {
        return this.currencyFormat;
    }

    public String getCurrencyFormatUsingCode() {
        return this.currencyFormatUsingCode;
    }

    public String getClusterNodeName() {
        return this.clusterNodeName;
    }

    public int getCurrencyRoundOff() {
        return this.currencyRoundOff;
    }

    public int getCurrencyDecimalDigits() {
        return this.currencyDecimalDigits;
    }

    public List<MenigaCurrency> getCurrencies() {
        return this.currencies;
    }

    public String getCurrentCulture() {
        return this.currentCulture;
    }

    public String getCurrencyGroupSymbol() {
        return this.currencyGroupSymbol;
    }

    public String getCurrencyDecimalSymbol() {
        return this.currencyDecimalSymbol;
    }

    public String getNumberFormat(String currencyCode) {
        MenigaCurrency currency = this.findCurrency(currencyCode);
        String format = this.numberFormat;
        if (currency != null) {
            format = currency.getFormat();
        }
        if (format == null) {
            return DEFAULT_NUMBER_FORMAT;
        }
        return format;
    }

    public String getCurrencySymbol(String currencyCode) {
        MenigaCurrency currency = this.findCurrency(currencyCode);
        String format = this.currencyFormat;
        if (currency != null) {
            format = currency.getCurrencyFormat();
        }
        if (format == null) {
            if (this.systemCurrency != null) {
                return this.systemCurrency;
            }
            if (currencyCode != null) {
                return currencyCode;
            }
            return "";
        }
        String symbol = format.replace(" ", "");
        for (int i = 0; i < 11; ++i) {
            symbol = symbol.replace("{" + i + "}", "");
        }
        return symbol;
    }

    public String getJavaFormatForCurrency(String currencyCode, boolean useCurrencyCode) {
        MenigaCurrency currency = this.findCurrency(currencyCode);
        String format = this.currencyFormat;
        if (currency != null) {
            format = useCurrencyCode ? currency.getCurrencyFormatUsingCode() : currency.getCurrencyFormat();
        } else if (useCurrencyCode) {
            if (this.currencyFormatUsingCode == null || this.currencyFormatUsingCode.length() == 0) {
                this.currencyFormatUsingCode = this.currencyFormat.replace(this.getCurrencySymbol(currencyCode), currencyCode);
            }
            format = this.currencyFormatUsingCode;
        }
        if (format == null) {
            if (currency != null && currency.getCode() != null) {
                return "{1}" + currency.getCode() + "{0}";
            }
            if (this.systemCurrency != null) {
                return "{1}" + this.systemCurrency + "{0}";
            }
            return "{1}{0}";
        }
        if (!format.contains("{1}")) {
            format = format.replace("{0}", "{1}{0}");
        }
        format = format.replace("{0}", "%2$s");
        format = format.replace("{1}", "%1$s");
        return format;
    }

    private MenigaCurrency findCurrency(String code) {
        if (this.currencies == null) {
            return null;
        }
        for (MenigaCurrency currency : this.currencies) {
            if (!currency.getCode().toUpperCase().equals(code.toUpperCase(Locale.getDefault()))) continue;
            return currency;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaPublicSettings that = (MenigaPublicSettings)o;
        if (this.currencyRoundOff != that.currencyRoundOff) {
            return false;
        }
        if (this.currencyDecimalDigits != that.currencyDecimalDigits) {
            return false;
        }
        if (this.defaultCultureName != null ? !this.defaultCultureName.equals(that.defaultCultureName) : that.defaultCultureName != null) {
            return false;
        }
        if (this.systemCurrency != null ? !this.systemCurrency.equals(that.systemCurrency) : that.systemCurrency != null) {
            return false;
        }
        if (this.numberFormat != null ? !this.numberFormat.equals(that.numberFormat) : that.numberFormat != null) {
            return false;
        }
        if (this.currencyFormat != null ? !this.currencyFormat.equals(that.currencyFormat) : that.currencyFormat != null) {
            return false;
        }
        if (this.currencyFormatUsingCode != null ? !this.currencyFormatUsingCode.equals(that.currencyFormatUsingCode) : that.currencyFormatUsingCode != null) {
            return false;
        }
        if (this.clusterNodeName != null ? !this.clusterNodeName.equals(that.clusterNodeName) : that.clusterNodeName != null) {
            return false;
        }
        if (this.currencies != null ? !this.currencies.equals(that.currencies) : that.currencies != null) {
            return false;
        }
        if (this.currentCulture != null ? !this.currentCulture.equals(that.currentCulture) : that.currentCulture != null) {
            return false;
        }
        if (this.currencyGroupSymbol != null ? !this.currencyGroupSymbol.equals(that.currencyGroupSymbol) : that.currencyGroupSymbol != null) {
            return false;
        }
        return this.currencyDecimalSymbol != null ? this.currencyDecimalSymbol.equals(that.currencyDecimalSymbol) : that.currencyDecimalSymbol == null;
    }

    public int hashCode() {
        int result = this.defaultCultureName != null ? this.defaultCultureName.hashCode() : 0;
        result = 31 * result + (this.systemCurrency != null ? this.systemCurrency.hashCode() : 0);
        result = 31 * result + (this.numberFormat != null ? this.numberFormat.hashCode() : 0);
        result = 31 * result + (this.currencyFormat != null ? this.currencyFormat.hashCode() : 0);
        result = 31 * result + (this.currencyFormatUsingCode != null ? this.currencyFormatUsingCode.hashCode() : 0);
        result = 31 * result + (this.clusterNodeName != null ? this.clusterNodeName.hashCode() : 0);
        result = 31 * result + this.currencyRoundOff;
        result = 31 * result + this.currencyDecimalDigits;
        result = 31 * result + (this.currencies != null ? this.currencies.hashCode() : 0);
        result = 31 * result + (this.currentCulture != null ? this.currentCulture.hashCode() : 0);
        result = 31 * result + (this.currencyGroupSymbol != null ? this.currencyGroupSymbol.hashCode() : 0);
        result = 31 * result + (this.currencyDecimalSymbol != null ? this.currencyDecimalSymbol.hashCode() : 0);
        return result;
    }

    public static Result<MenigaPublicSettings> fetch() {
        return apiOperator.getPublicSettings();
    }

    public static class MenigaCurrency
    implements Parcelable,
    Serializable {
        public static final Parcelable.Creator<MenigaCurrency> CREATOR = new Parcelable.Creator<MenigaCurrency>(){

            public MenigaCurrency createFromParcel(Parcel source) {
                return new MenigaCurrency(source);
            }

            public MenigaCurrency[] newArray(int size) {
                return new MenigaCurrency[size];
            }
        };
        private int id;
        private String code;
        private Boolean isDefault;
        private String name;
        private String format;
        private String currencyFormat;
        private String currencyFormatUsingCode;
        private String provider;
        private Integer roundOff;

        protected MenigaCurrency() {
        }

        protected MenigaCurrency(Parcel in) {
            this.id = in.readInt();
            this.code = in.readString();
            this.isDefault = (Boolean)in.readValue(Boolean.class.getClassLoader());
            this.name = in.readString();
            this.format = in.readString();
            this.currencyFormat = in.readString();
            this.currencyFormatUsingCode = in.readString();
            this.provider = in.readString();
            this.roundOff = (Integer)in.readValue(Integer.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeString(this.code);
            dest.writeValue((Object)this.isDefault);
            dest.writeString(this.name);
            dest.writeString(this.format);
            dest.writeString(this.currencyFormat);
            dest.writeString(this.currencyFormatUsingCode);
            dest.writeString(this.provider);
            dest.writeValue((Object)this.roundOff);
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.code;
        }

        public Boolean getDefault() {
            return this.isDefault;
        }

        public String getName() {
            return this.name;
        }

        public String getFormat() {
            return this.format;
        }

        public String getCurrencyFormat() {
            return this.currencyFormat;
        }

        public String getCurrencyFormatUsingCode() {
            if (this.currencyFormatUsingCode == null) {
                this.currencyFormatUsingCode = this.code + " {0}";
            }
            return this.currencyFormatUsingCode;
        }

        public String getProvider() {
            return this.provider;
        }

        public Integer getRoundOff() {
            return this.roundOff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MenigaCurrency currency = (MenigaCurrency)o;
            if (this.id != currency.id) {
                return false;
            }
            if (this.code != null ? !this.code.equals(currency.code) : currency.code != null) {
                return false;
            }
            if (this.isDefault != null ? !this.isDefault.equals(currency.isDefault) : currency.isDefault != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(currency.name) : currency.name != null) {
                return false;
            }
            if (this.format != null ? !this.format.equals(currency.format) : currency.format != null) {
                return false;
            }
            if (this.currencyFormat != null ? !this.currencyFormat.equals(currency.currencyFormat) : currency.currencyFormat != null) {
                return false;
            }
            if (this.currencyFormatUsingCode != null ? !this.currencyFormatUsingCode.equals(currency.currencyFormatUsingCode) : currency.currencyFormatUsingCode != null) {
                return false;
            }
            if (this.provider != null ? !this.provider.equals(currency.provider) : currency.provider != null) {
                return false;
            }
            return this.roundOff != null ? this.roundOff.equals(currency.roundOff) : currency.roundOff == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.isDefault != null ? this.isDefault.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.currencyFormat != null ? this.currencyFormat.hashCode() : 0);
            result = 31 * result + (this.currencyFormatUsingCode != null ? this.currencyFormatUsingCode.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.roundOff != null ? this.roundOff.hashCode() : 0);
            return result;
        }
    }
}

