/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.organizations;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.meniga.sdk.helpers.KeyVal;
import com.meniga.sdk.models.organizations.enums.AuthParameterType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenigaRealmAuthParameter
implements Parcelable,
Serializable {
    protected String name;
    protected String displayName;
    protected String regularExpression;
    protected Integer minLength;
    protected Integer maxLength;
    protected boolean isPassword;
    protected boolean isHidden;
    protected boolean isDropDown;
    protected String dropDownValues;
    protected Long parentId;
    protected boolean canSave;
    protected boolean isEncrypted;
    protected boolean isIdentity;
    protected transient String selectedValue;
    public static final Parcelable.Creator<MenigaRealmAuthParameter> CREATOR = new Parcelable.Creator<MenigaRealmAuthParameter>(){

        public MenigaRealmAuthParameter createFromParcel(Parcel source) {
            return new MenigaRealmAuthParameter(source);
        }

        public MenigaRealmAuthParameter[] newArray(int size) {
            return new MenigaRealmAuthParameter[size];
        }
    };

    protected MenigaRealmAuthParameter() {
    }

    protected MenigaRealmAuthParameter(Parcel in) {
        this.name = in.readString();
        this.displayName = in.readString();
        this.regularExpression = in.readString();
        this.minLength = (Integer)in.readValue(Integer.class.getClassLoader());
        this.maxLength = (Integer)in.readValue(Integer.class.getClassLoader());
        this.isPassword = in.readByte() != 0;
        this.isHidden = in.readByte() != 0;
        this.isDropDown = in.readByte() != 0;
        this.dropDownValues = in.readString();
        this.parentId = (Long)in.readValue(Long.class.getClassLoader());
        this.canSave = in.readByte() != 0;
        this.isEncrypted = in.readByte() != 0;
        this.isIdentity = in.readByte() != 0;
    }

    public String getName() {
        return this.name;
    }

    public void setSelectedValue(String val) {
        this.selectedValue = val;
    }

    public AuthParameterType getAuthParameterType() {
        if (this.isHidden) {
            return AuthParameterType.MESSAGE;
        }
        if (this.name.equals("username")) {
            return AuthParameterType.USERNAME;
        }
        if (this.name.equals("password")) {
            return AuthParameterType.PASSWORD;
        }
        if (this.name.equals("otp")) {
            return AuthParameterType.AUTHENTICATION_METHOD_OTP;
        }
        if (this.name.equals("authUrl") && this.displayName.toLowerCase().startsWith("http")) {
            return AuthParameterType.AUTHENTICATION_URL;
        }
        if (this.name.equals("code") && this.displayName == null) {
            return AuthParameterType.AUTHENTICATION_URL_CODE;
        }
        String[] parts = this.displayName.split("\\|");
        switch (parts[0]) {
            case "@Username": {
                if (this.isDropDown) {
                    return AuthParameterType.USER_MULTI_SELECT;
                }
                return AuthParameterType.USERNAME;
            }
            case "@AuthMethod": {
                return AuthParameterType.AUTH_METHOD_MULTI_SELECT;
            }
            case "@AuthMethodTodos": {
                return AuthParameterType.AUTHENTICATION_METHOD_TODOS;
            }
            case "@AuthMethodSMS": {
                return AuthParameterType.AUTHENTICATION_METHOD_SMS;
            }
            case "@PhoneNumber": {
                return AuthParameterType.PHONE_NUMBER;
            }
            case "@SecurityNumber": {
                return AuthParameterType.PIN;
            }
        }
        return AuthParameterType.UNKNOWN;
    }

    public SimpleAuthParameter getSimpleParameter() {
        SimpleAuthParameter par = new SimpleAuthParameter();
        par.name = this.name;
        par.value = this.selectedValue;
        return par;
    }

    public String getDisplayName() {
        if (this.displayName.contains("|")) {
            String[] splt = this.displayName.split("\\|");
            return splt[splt.length - 1];
        }
        return this.displayName;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDropDown() {
        return this.isDropDown;
    }

    public List<KeyVal<String, String>> getDropDownValues() {
        JsonParser parser = new JsonParser();
        JsonElement elements = parser.parse(this.dropDownValues);
        JsonArray values = elements.getAsJsonArray();
        ArrayList<KeyVal<String, String>> entries = new ArrayList<KeyVal<String, String>>();
        for (int i = 0; i < values.size(); ++i) {
            JsonObject item = values.get(i).getAsJsonObject();
            KeyVal<String, String> entry = new KeyVal<String, String>(item.get("Name").getAsString(), item.get("Value").getAsString());
            entries.add(entry);
        }
        return entries;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public boolean isCanSave() {
        return this.canSave;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaRealmAuthParameter that = (MenigaRealmAuthParameter)o;
        if (this.isPassword != that.isPassword) {
            return false;
        }
        if (this.isHidden != that.isHidden) {
            return false;
        }
        if (this.isDropDown != that.isDropDown) {
            return false;
        }
        if (this.canSave != that.canSave) {
            return false;
        }
        if (this.isEncrypted != that.isEncrypted) {
            return false;
        }
        if (this.isIdentity != that.isIdentity) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.regularExpression != null ? !this.regularExpression.equals(that.regularExpression) : that.regularExpression != null) {
            return false;
        }
        if (this.minLength != null ? !this.minLength.equals(that.minLength) : that.minLength != null) {
            return false;
        }
        if (this.maxLength != null ? !this.maxLength.equals(that.maxLength) : that.maxLength != null) {
            return false;
        }
        if (this.dropDownValues != null ? !this.dropDownValues.equals(that.dropDownValues) : that.dropDownValues != null) {
            return false;
        }
        return this.parentId != null ? this.parentId.equals(that.parentId) : that.parentId == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.regularExpression != null ? this.regularExpression.hashCode() : 0);
        result = 31 * result + (this.minLength != null ? this.minLength.hashCode() : 0);
        result = 31 * result + (this.maxLength != null ? this.maxLength.hashCode() : 0);
        result = 31 * result + (this.isPassword ? 1 : 0);
        result = 31 * result + (this.isHidden ? 1 : 0);
        result = 31 * result + (this.isDropDown ? 1 : 0);
        result = 31 * result + (this.dropDownValues != null ? this.dropDownValues.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.canSave ? 1 : 0);
        result = 31 * result + (this.isEncrypted ? 1 : 0);
        result = 31 * result + (this.isIdentity ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.displayName);
        dest.writeString(this.regularExpression);
        dest.writeValue((Object)this.minLength);
        dest.writeValue((Object)this.maxLength);
        dest.writeByte(this.isPassword ? (byte)1 : 0);
        dest.writeByte(this.isHidden ? (byte)1 : 0);
        dest.writeByte(this.isDropDown ? (byte)1 : 0);
        dest.writeString(this.dropDownValues);
        dest.writeValue((Object)this.parentId);
        dest.writeByte(this.canSave ? (byte)1 : 0);
        dest.writeByte(this.isEncrypted ? (byte)1 : 0);
        dest.writeByte(this.isIdentity ? (byte)1 : 0);
    }

    public static class SimpleAuthParameter {
        public String name;
        public String value;
    }
}

