/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.organizations;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.organizations.MenigaRealmAccount;
import com.meniga.sdk.models.organizations.MenigaRealmAuthParameter;
import com.meniga.sdk.models.organizations.MenigaRealmAuthResponse;
import com.meniga.sdk.models.organizations.enums.AuthorizationType;
import com.meniga.sdk.models.organizations.operators.MenigaRealmOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MenigaRealm
implements Parcelable,
Serializable {
    private static MenigaRealmOperations apiOperations;
    protected long id;
    protected String description;
    protected String identifier;
    protected AuthorizationType authorizationType;
    protected String contentPageId;
    protected String externalRegistrationUrl;
    protected boolean showDuringSignup;
    public static final Parcelable.Creator<MenigaRealm> CREATOR;

    protected MenigaRealm() {
    }

    public static void setOperator(MenigaRealmOperations operations) {
        apiOperations = operations;
    }

    protected MenigaRealm(Parcel in) {
        this.id = in.readLong();
        this.description = in.readString();
        this.identifier = in.readString();
        int tmpAuthorizationType = in.readInt();
        this.authorizationType = tmpAuthorizationType == -1 ? null : AuthorizationType.values()[tmpAuthorizationType];
        this.contentPageId = in.readString();
        this.externalRegistrationUrl = in.readString();
        this.showDuringSignup = in.readByte() != 0;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public AuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    public String getContentPageId() {
        return this.contentPageId;
    }

    public String getExternalRegistrationUrl() {
        return this.externalRegistrationUrl;
    }

    public boolean showDuringSignup() {
        return this.showDuringSignup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaRealm that = (MenigaRealm)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.showDuringSignup != that.showDuringSignup) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.authorizationType != that.authorizationType) {
            return false;
        }
        if (this.contentPageId != null ? !this.contentPageId.equals(that.contentPageId) : that.contentPageId != null) {
            return false;
        }
        return this.externalRegistrationUrl != null ? this.externalRegistrationUrl.equals(that.externalRegistrationUrl) : that.externalRegistrationUrl == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.authorizationType != null ? this.authorizationType.hashCode() : 0);
        result = 31 * result + (this.contentPageId != null ? this.contentPageId.hashCode() : 0);
        result = 31 * result + (this.externalRegistrationUrl != null ? this.externalRegistrationUrl.hashCode() : 0);
        result = 31 * result + (this.showDuringSignup ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.description);
        dest.writeString(this.identifier);
        dest.writeInt(this.authorizationType == null ? -1 : this.authorizationType.ordinal());
        dest.writeString(this.contentPageId);
        dest.writeString(this.externalRegistrationUrl);
        dest.writeByte(this.showDuringSignup ? (byte)1 : 0);
    }

    public static Result<List<MenigaRealmAccount>> getRealmAccounts(long realmUserId, String sessionToken) {
        return apiOperations.getRealmAccounts(realmUserId, sessionToken);
    }

    public static Result<List<MenigaRealmAccount>> addRealmAccountsToMeniga(long realmUserId, List<MenigaRealmAccount> accounts, String sessionToken) {
        return apiOperations.addRealmAccountsToMeniga(realmUserId, accounts, sessionToken);
    }

    public Result<MenigaRealmAuthResponse> getInitialRealmAuthenticationSteps() {
        return apiOperations.performBankAuthenticationStep(this.id, null, "", null);
    }

    public Result<MenigaRealmAuthResponse> performBankAuthenticationStep(List<MenigaRealmAuthParameter> authPars, String userId, String sessionToken) {
        return apiOperations.performBankAuthenticationStep(this.id, authPars, userId, sessionToken);
    }

    public Result<MenigaRealmAuthResponse> transferUserAccounts(String realmUserId, String sessionToken) {
        ArrayList<MenigaRealmAuthParameter> emptyParametersList = new ArrayList<MenigaRealmAuthParameter>();
        return this.performBankAuthenticationStep(emptyParametersList, realmUserId, sessionToken);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaRealm>(){

            public MenigaRealm createFromParcel(Parcel source) {
                return new MenigaRealm(source);
            }

            public MenigaRealm[] newArray(int size) {
                return new MenigaRealm[size];
            }
        };
    }
}

