/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.offers.redemptions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.offers.redemptions.enums.RedemptionType;
import com.meniga.sdk.models.offers.redemptions.enums.ReimbursementStatus;
import java.io.Serializable;
import org.joda.time.DateTime;

public class MenigaRedemptionTransaction
implements Parcelable,
Serializable {
    protected long id;
    protected long offerId;
    protected String text;
    protected DateTime date;
    protected MenigaDecimal amount;
    protected MenigaDecimal redemptionAmount;
    protected RedemptionType redemptionType;
    protected ReimbursementStatus reimbursementStatus;
    protected DateTime reimbursementDate;
    protected DateTime scheduledReimbursementDate;
    protected String reimbursementAccountInfo;
    public static final Parcelable.Creator<MenigaRedemptionTransaction> CREATOR = new Parcelable.Creator<MenigaRedemptionTransaction>(){

        public MenigaRedemptionTransaction createFromParcel(Parcel source) {
            return new MenigaRedemptionTransaction(source);
        }

        public MenigaRedemptionTransaction[] newArray(int size) {
            return new MenigaRedemptionTransaction[size];
        }
    };

    protected MenigaRedemptionTransaction() {
    }

    protected MenigaRedemptionTransaction(Parcel in) {
        this.id = in.readLong();
        this.offerId = in.readLong();
        this.text = in.readString();
        this.date = (DateTime)in.readSerializable();
        this.amount = (MenigaDecimal)in.readSerializable();
        this.redemptionAmount = (MenigaDecimal)in.readSerializable();
        int tmpRedemptionType = in.readInt();
        this.redemptionType = tmpRedemptionType == -1 ? null : RedemptionType.values()[tmpRedemptionType];
        int tmpReimbursementStatus = in.readInt();
        this.reimbursementStatus = tmpReimbursementStatus == -1 ? null : ReimbursementStatus.values()[tmpReimbursementStatus];
        this.reimbursementDate = (DateTime)in.readSerializable();
        this.scheduledReimbursementDate = (DateTime)in.readSerializable();
        this.reimbursementAccountInfo = in.readString();
    }

    public String getReimbursementAccountInfo() {
        return this.reimbursementAccountInfo;
    }

    public long getId() {
        return this.id;
    }

    public long getOfferId() {
        return this.offerId;
    }

    public String getText() {
        return this.text;
    }

    public DateTime getDate() {
        return this.date;
    }

    public MenigaDecimal getAmount() {
        return this.amount;
    }

    public MenigaDecimal getRedemptionAmount() {
        return this.redemptionAmount;
    }

    public RedemptionType getRedemptionType() {
        return this.redemptionType;
    }

    public ReimbursementStatus getReimbursementStatus() {
        return this.reimbursementStatus;
    }

    public DateTime getReimbursementDate() {
        return this.reimbursementDate;
    }

    public DateTime getScheduledReimbursementDate() {
        return this.scheduledReimbursementDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaRedemptionTransaction that = (MenigaRedemptionTransaction)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.offerId != that.offerId) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(that.amount) : that.amount != null) {
            return false;
        }
        if (this.redemptionAmount != null ? !this.redemptionAmount.equals(that.redemptionAmount) : that.redemptionAmount != null) {
            return false;
        }
        if (this.redemptionType != that.redemptionType) {
            return false;
        }
        if (this.reimbursementStatus != that.reimbursementStatus) {
            return false;
        }
        if (this.reimbursementDate != null ? !this.reimbursementDate.equals((Object)that.reimbursementDate) : that.reimbursementDate != null) {
            return false;
        }
        if (this.scheduledReimbursementDate != null ? !this.scheduledReimbursementDate.equals((Object)that.scheduledReimbursementDate) : that.scheduledReimbursementDate != null) {
            return false;
        }
        return this.reimbursementAccountInfo != null ? this.reimbursementAccountInfo.equals(that.reimbursementAccountInfo) : that.reimbursementAccountInfo == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.offerId ^ this.offerId >>> 32);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.redemptionAmount != null ? this.redemptionAmount.hashCode() : 0);
        result = 31 * result + (this.redemptionType != null ? this.redemptionType.hashCode() : 0);
        result = 31 * result + (this.reimbursementStatus != null ? this.reimbursementStatus.hashCode() : 0);
        result = 31 * result + (this.reimbursementDate != null ? this.reimbursementDate.hashCode() : 0);
        result = 31 * result + (this.scheduledReimbursementDate != null ? this.scheduledReimbursementDate.hashCode() : 0);
        result = 31 * result + (this.reimbursementAccountInfo != null ? this.reimbursementAccountInfo.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.offerId);
        dest.writeString(this.text);
        dest.writeSerializable((Serializable)this.date);
        dest.writeSerializable((Serializable)this.amount);
        dest.writeSerializable((Serializable)this.redemptionAmount);
        dest.writeInt(this.redemptionType == null ? -1 : this.redemptionType.ordinal());
        dest.writeInt(this.reimbursementStatus == null ? -1 : this.reimbursementStatus.ordinal());
        dest.writeSerializable((Serializable)this.reimbursementDate);
        dest.writeSerializable((Serializable)this.scheduledReimbursementDate);
        dest.writeString(this.reimbursementAccountInfo);
    }
}

