/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.offers;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.offers.MenigaOfferMerchantLocation;
import com.meniga.sdk.models.offers.MenigaOfferMerchantLocationPage;
import com.meniga.sdk.models.offers.MenigaOfferPage;
import com.meniga.sdk.models.offers.MenigaSimilarBrandSpendingDetails;
import com.meniga.sdk.models.offers.RelevanceHookDisplay;
import com.meniga.sdk.models.offers.enums.OfferFilterState;
import com.meniga.sdk.models.offers.enums.OfferState;
import com.meniga.sdk.models.offers.enums.RewardType;
import com.meniga.sdk.models.offers.operators.MenigaOfferOperations;
import com.meniga.sdk.models.offers.redemptions.MenigaRedemptions;
import com.meniga.sdk.providers.tasks.TaskCompletionSource;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaOffer
implements Parcelable,
Serializable {
    protected static MenigaOfferOperations apiOperator;
    protected long id;
    protected String title;
    protected String description;
    protected Long brandId;
    protected String brandName;
    protected String validationToken;
    protected OfferState state;
    protected RewardType rewardType;
    protected MenigaDecimal reward;
    protected MenigaDecimal totalRedeemedAmount;
    protected MenigaDecimal minimumPurchaseAmount;
    protected MenigaDecimal maximumRedemptionPerOffer;
    protected MenigaDecimal maximumRedemptionPerPurchase;
    protected MenigaDecimal minimumAccumulatedAmount;
    protected Integer maximumPurchase;
    protected MenigaDecimal lastReimbursementAmount;
    protected DateTime lastReimbursementDate;
    protected MenigaDecimal scheduledReimbursementAmount;
    protected DateTime scheduledReimbursementDate;
    protected int daysLeft;
    protected DateTime validFrom;
    protected DateTime validTo;
    protected DateTime activatedDate;
    protected DateTime declineDate;
    protected Long merchantId;
    protected String merchantName;
    protected boolean merchantDeclined;
    protected boolean activateOfferOnFirstPurchase;
    protected RelevanceHookDisplay relevanceHook;
    protected MenigaDecimal totalSpendingAtSimilarBrands;
    protected MenigaDecimal totalSpendingOnOffer;
    protected MenigaDecimal offerSimilarBrandsSpendingRatio;
    protected List<MenigaOfferMerchantLocation> merchantLocations;
    protected String webUri;
    protected String webUriLabel;
    public static final Parcelable.Creator<MenigaOffer> CREATOR;

    protected MenigaOffer() {
    }

    public static void setOperator(MenigaOfferOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getBrandId() {
        return this.brandId;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getValidationToken() {
        return this.validationToken;
    }

    public OfferState getState() {
        return this.state;
    }

    public RewardType getRewardType() {
        return this.rewardType;
    }

    public MenigaDecimal getReward() {
        if (this.reward == null) {
            return new MenigaDecimal(0);
        }
        return this.reward;
    }

    public MenigaDecimal getTotalRedeemedAmount() {
        return this.totalRedeemedAmount;
    }

    public MenigaDecimal getMinimumPurchaseAmount() {
        return this.minimumPurchaseAmount;
    }

    public MenigaDecimal getMaximumRedemptionPerOffer() {
        return this.maximumRedemptionPerOffer;
    }

    public MenigaDecimal getMaximumRedemptionPerPurchase() {
        return this.maximumRedemptionPerPurchase;
    }

    public MenigaDecimal getMinimumAccumulatedAmount() {
        return this.minimumAccumulatedAmount;
    }

    public Integer getMaximumPurchase() {
        return this.maximumPurchase;
    }

    public MenigaDecimal getLastReimbursementAmount() {
        return this.lastReimbursementAmount;
    }

    public DateTime getLastReimbursementDate() {
        return this.lastReimbursementDate;
    }

    public MenigaDecimal getScheduledReimbursementAmount() {
        return this.scheduledReimbursementAmount;
    }

    public DateTime getScheduledReimbursementDate() {
        return this.scheduledReimbursementDate;
    }

    public int getDaysLeft() {
        return this.daysLeft;
    }

    public DateTime getValidFrom() {
        return this.validFrom;
    }

    public DateTime getValidTo() {
        return this.validTo;
    }

    public DateTime getDeclineDate() {
        return this.declineDate;
    }

    public long getMerchantId() {
        return this.merchantId;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public boolean isMerchantDeclined() {
        return this.merchantDeclined;
    }

    public boolean isActivateOfferOnFirstPurchase() {
        return this.activateOfferOnFirstPurchase;
    }

    public RelevanceHookDisplay getRelevanceHook() {
        return this.relevanceHook;
    }

    public MenigaDecimal getTotalSpendingAtSimilarBrands() {
        return this.totalSpendingAtSimilarBrands;
    }

    public MenigaDecimal getTotalSpendingOnOffer() {
        return this.totalSpendingOnOffer;
    }

    public MenigaDecimal getOfferSimilarBrandsSpendingRatio() {
        return this.offerSimilarBrandsSpendingRatio;
    }

    public DateTime getActivatedDate() {
        return this.activatedDate;
    }

    public List<MenigaOfferMerchantLocation> getMerchantLocations() {
        return this.merchantLocations;
    }

    public String getWebUri() {
        return this.webUri;
    }

    public String getWebUriLabel() {
        return this.webUriLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaOffer that = (MenigaOffer)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.daysLeft != that.daysLeft) {
            return false;
        }
        if (this.merchantDeclined != that.merchantDeclined) {
            return false;
        }
        if (this.activateOfferOnFirstPurchase != that.activateOfferOnFirstPurchase) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.brandId != null ? !this.brandId.equals(that.brandId) : that.brandId != null) {
            return false;
        }
        if (this.brandName != null ? !this.brandName.equals(that.brandName) : that.brandName != null) {
            return false;
        }
        if (this.validationToken != null ? !this.validationToken.equals(that.validationToken) : that.validationToken != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.rewardType != that.rewardType) {
            return false;
        }
        if (this.reward != null ? !this.reward.equals(that.reward) : that.reward != null) {
            return false;
        }
        if (this.totalRedeemedAmount != null ? !this.totalRedeemedAmount.equals(that.totalRedeemedAmount) : that.totalRedeemedAmount != null) {
            return false;
        }
        if (this.minimumPurchaseAmount != null ? !this.minimumPurchaseAmount.equals(that.minimumPurchaseAmount) : that.minimumPurchaseAmount != null) {
            return false;
        }
        if (this.maximumRedemptionPerOffer != null ? !this.maximumRedemptionPerOffer.equals(that.maximumRedemptionPerOffer) : that.maximumRedemptionPerOffer != null) {
            return false;
        }
        if (this.maximumRedemptionPerPurchase != null ? !this.maximumRedemptionPerPurchase.equals(that.maximumRedemptionPerPurchase) : that.maximumRedemptionPerPurchase != null) {
            return false;
        }
        if (this.minimumAccumulatedAmount != null ? !this.minimumAccumulatedAmount.equals(that.minimumAccumulatedAmount) : that.minimumAccumulatedAmount != null) {
            return false;
        }
        if (this.maximumPurchase != null ? !this.maximumPurchase.equals(that.maximumPurchase) : that.maximumPurchase != null) {
            return false;
        }
        if (this.lastReimbursementAmount != null ? !this.lastReimbursementAmount.equals(that.lastReimbursementAmount) : that.lastReimbursementAmount != null) {
            return false;
        }
        if (this.lastReimbursementDate != null ? !this.lastReimbursementDate.equals((Object)that.lastReimbursementDate) : that.lastReimbursementDate != null) {
            return false;
        }
        if (this.scheduledReimbursementAmount != null ? !this.scheduledReimbursementAmount.equals(that.scheduledReimbursementAmount) : that.scheduledReimbursementAmount != null) {
            return false;
        }
        if (this.scheduledReimbursementDate != null ? !this.scheduledReimbursementDate.equals((Object)that.scheduledReimbursementDate) : that.scheduledReimbursementDate != null) {
            return false;
        }
        if (this.validFrom != null ? !this.validFrom.equals((Object)that.validFrom) : that.validFrom != null) {
            return false;
        }
        if (this.validTo != null ? !this.validTo.equals((Object)that.validTo) : that.validTo != null) {
            return false;
        }
        if (this.activatedDate != null ? !this.activatedDate.equals((Object)that.activatedDate) : that.activatedDate != null) {
            return false;
        }
        if (this.declineDate != null ? !this.declineDate.equals((Object)that.declineDate) : that.declineDate != null) {
            return false;
        }
        if (this.merchantId != null ? !this.merchantId.equals(that.merchantId) : that.merchantId != null) {
            return false;
        }
        if (this.merchantName != null ? !this.merchantName.equals(that.merchantName) : that.merchantName != null) {
            return false;
        }
        if (this.relevanceHook != null ? !this.relevanceHook.equals(that.relevanceHook) : that.relevanceHook != null) {
            return false;
        }
        if (this.totalSpendingAtSimilarBrands != null ? !this.totalSpendingAtSimilarBrands.equals(that.totalSpendingAtSimilarBrands) : that.totalSpendingAtSimilarBrands != null) {
            return false;
        }
        if (this.totalSpendingOnOffer != null ? !this.totalSpendingOnOffer.equals(that.totalSpendingOnOffer) : that.totalSpendingOnOffer != null) {
            return false;
        }
        if (this.offerSimilarBrandsSpendingRatio != null ? !this.offerSimilarBrandsSpendingRatio.equals(that.offerSimilarBrandsSpendingRatio) : that.offerSimilarBrandsSpendingRatio != null) {
            return false;
        }
        if (this.merchantLocations != null ? !this.merchantLocations.equals(that.merchantLocations) : that.merchantLocations != null) {
            return false;
        }
        if (this.webUri != null ? !this.webUri.equals(that.webUri) : that.webUri != null) {
            return false;
        }
        return this.webUriLabel != null ? this.webUriLabel.equals(that.webUriLabel) : that.webUriLabel == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.brandId != null ? this.brandId.hashCode() : 0);
        result = 31 * result + (this.brandName != null ? this.brandName.hashCode() : 0);
        result = 31 * result + (this.validationToken != null ? this.validationToken.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.rewardType != null ? this.rewardType.hashCode() : 0);
        result = 31 * result + (this.reward != null ? this.reward.hashCode() : 0);
        result = 31 * result + (this.totalRedeemedAmount != null ? this.totalRedeemedAmount.hashCode() : 0);
        result = 31 * result + (this.minimumPurchaseAmount != null ? this.minimumPurchaseAmount.hashCode() : 0);
        result = 31 * result + (this.maximumRedemptionPerOffer != null ? this.maximumRedemptionPerOffer.hashCode() : 0);
        result = 31 * result + (this.maximumRedemptionPerPurchase != null ? this.maximumRedemptionPerPurchase.hashCode() : 0);
        result = 31 * result + (this.minimumAccumulatedAmount != null ? this.minimumAccumulatedAmount.hashCode() : 0);
        result = 31 * result + (this.maximumPurchase != null ? this.maximumPurchase.hashCode() : 0);
        result = 31 * result + (this.lastReimbursementAmount != null ? this.lastReimbursementAmount.hashCode() : 0);
        result = 31 * result + (this.lastReimbursementDate != null ? this.lastReimbursementDate.hashCode() : 0);
        result = 31 * result + (this.scheduledReimbursementAmount != null ? this.scheduledReimbursementAmount.hashCode() : 0);
        result = 31 * result + (this.scheduledReimbursementDate != null ? this.scheduledReimbursementDate.hashCode() : 0);
        result = 31 * result + this.daysLeft;
        result = 31 * result + (this.validFrom != null ? this.validFrom.hashCode() : 0);
        result = 31 * result + (this.validTo != null ? this.validTo.hashCode() : 0);
        result = 31 * result + (this.activatedDate != null ? this.activatedDate.hashCode() : 0);
        result = 31 * result + (this.declineDate != null ? this.declineDate.hashCode() : 0);
        result = 31 * result + (this.merchantId != null ? this.merchantId.hashCode() : 0);
        result = 31 * result + (this.merchantName != null ? this.merchantName.hashCode() : 0);
        result = 31 * result + (this.merchantDeclined ? 1 : 0);
        result = 31 * result + (this.activateOfferOnFirstPurchase ? 1 : 0);
        result = 31 * result + (this.relevanceHook != null ? this.relevanceHook.hashCode() : 0);
        result = 31 * result + (this.totalSpendingAtSimilarBrands != null ? this.totalSpendingAtSimilarBrands.hashCode() : 0);
        result = 31 * result + (this.totalSpendingOnOffer != null ? this.totalSpendingOnOffer.hashCode() : 0);
        result = 31 * result + (this.offerSimilarBrandsSpendingRatio != null ? this.offerSimilarBrandsSpendingRatio.hashCode() : 0);
        result = 31 * result + (this.merchantLocations != null ? this.merchantLocations.hashCode() : 0);
        result = 31 * result + (this.webUri != null ? this.webUri.hashCode() : 0);
        result = 31 * result + (this.webUriLabel != null ? this.webUriLabel.hashCode() : 0);
        return result;
    }

    public static Result<MenigaOfferPage> fetch(final int skip, final int take, final List<OfferFilterState> states, final List<Long> offerIds, final boolean expiredWithRedemptionOnly) {
        Result<MenigaOfferPage> task2 = apiOperator.getOffers(skip, take, states, offerIds, expiredWithRedemptionOnly);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaOfferPage>(){

            @Override
            public void onFinished(MenigaOfferPage result, boolean failed) {
                if (!failed && result != null) {
                    result.skip = skip;
                    result.take = take;
                    result.states = states != null ? states : Collections.emptyList();
                    result.offerIds = offerIds != null ? offerIds : Collections.emptyList();
                    result.expiredWithRedemptionOnly = expiredWithRedemptionOnly;
                    result.hasMorePages = skip + take < result.getTotalCount();
                }
            }
        });
    }

    public static Result<MenigaOffer> fetch(long id) {
        return apiOperator.getOfferById(id);
    }

    public static Result<MenigaOffer> fetch(String validationToken) {
        return apiOperator.getOfferByToken(validationToken);
    }

    @Deprecated
    public static Result<MenigaOfferPage> fetch(List<OfferFilterState> states) {
        int take = 100;
        boolean skip = false;
        return MenigaOffer.fetch(0, 100, states, null, false);
    }

    @Deprecated
    public static Result<MenigaOfferPage> fetchId(List<Long> offerIds) {
        int take = 100;
        boolean skip = false;
        return MenigaOffer.fetch(0, 100, null, offerIds, false);
    }

    public static Result<MenigaOfferPage> fetch(int skip, int take) {
        return MenigaOffer.fetch(skip, take, null, null, false);
    }

    public Result<Void> activate() {
        Result<Void> task2 = apiOperator.activateById(this.id);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<Void>(){

            @Override
            public void onFinished(Void result, boolean failed) {
                if (!failed) {
                    MenigaOffer.this.state = OfferState.ACTIVATED;
                }
            }
        });
    }

    public Result<Void> activateByToken() {
        Result<Void> task2 = MenigaOffer.activateByToken(this.validationToken);
        TaskCompletionSource tsc = new TaskCompletionSource();
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<Void>(){

            @Override
            public void onFinished(Void result, boolean failed) {
                if (!failed) {
                    MenigaOffer.this.state = OfferState.ACTIVATED;
                }
            }
        });
    }

    public static Result<Void> activateByToken(String validationToken) {
        return apiOperator.activateByToken(validationToken);
    }

    public static Result<Void> seen(long offerId) {
        return apiOperator.markAsSeen(offerId);
    }

    public Result<Void> decline() {
        return apiOperator.deactivate(this.id);
    }

    public Result<Void> markAsSeen() {
        return apiOperator.markAsSeen(this.id);
    }

    public Result<MenigaSimilarBrandSpendingDetails> fetchSimilarBrandSpendingDetails() {
        return apiOperator.similarBrandSpendingDetails(this.id);
    }

    public static Result<MenigaSimilarBrandSpendingDetails> fetchSimilarBrandSpendingDetailsById(int id) {
        return apiOperator.similarBrandSpendingDetails(id);
    }

    public Result<MenigaRedemptions> fetchRedemptions() {
        return apiOperator.getRedemptionsById(this.id);
    }

    public static Result<MenigaRedemptions> fetchRedemptionsById(int id) {
        return apiOperator.getRedemptionsById(id);
    }

    public Result<MenigaOfferMerchantLocationPage> fetchNearbyMerchantLocations(Double latitude, Double longitude, Double radiumKm, Integer limitLocations) {
        return apiOperator.getMerchantLocationsById(this.id, latitude, longitude, radiumKm, limitLocations);
    }

    public static Result<MenigaOfferMerchantLocationPage> fetchNearbyMerchantLocationsById(int id, Double latitude, Double longitude, Double radiumKm, Integer limitLocations) {
        return apiOperator.getMerchantLocationsById(id, latitude, longitude, radiumKm, limitLocations);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeValue((Object)this.brandId);
        dest.writeString(this.brandName);
        dest.writeString(this.validationToken);
        dest.writeInt(this.state == null ? -1 : this.state.ordinal());
        dest.writeInt(this.rewardType == null ? -1 : this.rewardType.ordinal());
        dest.writeSerializable((Serializable)this.reward);
        dest.writeSerializable((Serializable)this.totalRedeemedAmount);
        dest.writeSerializable((Serializable)this.minimumPurchaseAmount);
        dest.writeSerializable((Serializable)this.maximumRedemptionPerOffer);
        dest.writeSerializable((Serializable)this.maximumRedemptionPerPurchase);
        dest.writeSerializable((Serializable)this.minimumAccumulatedAmount);
        dest.writeValue((Object)this.maximumPurchase);
        dest.writeSerializable((Serializable)this.lastReimbursementAmount);
        dest.writeSerializable((Serializable)this.lastReimbursementDate);
        dest.writeSerializable((Serializable)this.scheduledReimbursementAmount);
        dest.writeSerializable((Serializable)this.scheduledReimbursementDate);
        dest.writeInt(this.daysLeft);
        dest.writeSerializable((Serializable)this.validFrom);
        dest.writeSerializable((Serializable)this.validTo);
        dest.writeSerializable((Serializable)this.activatedDate);
        dest.writeSerializable((Serializable)this.declineDate);
        dest.writeValue((Object)this.merchantId);
        dest.writeString(this.merchantName);
        dest.writeByte(this.merchantDeclined ? (byte)1 : 0);
        dest.writeByte(this.activateOfferOnFirstPurchase ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.relevanceHook, flags);
        dest.writeSerializable((Serializable)this.totalSpendingAtSimilarBrands);
        dest.writeSerializable((Serializable)this.totalSpendingOnOffer);
        dest.writeSerializable((Serializable)this.offerSimilarBrandsSpendingRatio);
        dest.writeTypedList(this.merchantLocations);
        dest.writeString(this.webUri);
        dest.writeString(this.webUriLabel);
    }

    protected MenigaOffer(Parcel in) {
        this.id = in.readLong();
        this.title = in.readString();
        this.description = in.readString();
        this.brandId = (Long)in.readValue(Long.class.getClassLoader());
        this.brandName = in.readString();
        this.validationToken = in.readString();
        int tmpState = in.readInt();
        this.state = tmpState == -1 ? null : OfferState.values()[tmpState];
        int tmpRewardType = in.readInt();
        this.rewardType = tmpRewardType == -1 ? null : RewardType.values()[tmpRewardType];
        this.reward = (MenigaDecimal)in.readSerializable();
        this.totalRedeemedAmount = (MenigaDecimal)in.readSerializable();
        this.minimumPurchaseAmount = (MenigaDecimal)in.readSerializable();
        this.maximumRedemptionPerOffer = (MenigaDecimal)in.readSerializable();
        this.maximumRedemptionPerPurchase = (MenigaDecimal)in.readSerializable();
        this.minimumAccumulatedAmount = (MenigaDecimal)in.readSerializable();
        this.maximumPurchase = (Integer)in.readValue(Integer.class.getClassLoader());
        this.lastReimbursementAmount = (MenigaDecimal)in.readSerializable();
        this.lastReimbursementDate = (DateTime)in.readSerializable();
        this.scheduledReimbursementAmount = (MenigaDecimal)in.readSerializable();
        this.scheduledReimbursementDate = (DateTime)in.readSerializable();
        this.daysLeft = in.readInt();
        this.validFrom = (DateTime)in.readSerializable();
        this.validTo = (DateTime)in.readSerializable();
        this.activatedDate = (DateTime)in.readSerializable();
        this.declineDate = (DateTime)in.readSerializable();
        this.merchantId = (Long)in.readValue(Long.class.getClassLoader());
        this.merchantName = in.readString();
        this.merchantDeclined = in.readByte() != 0;
        this.activateOfferOnFirstPurchase = in.readByte() != 0;
        this.relevanceHook = (RelevanceHookDisplay)in.readParcelable(RelevanceHookDisplay.class.getClassLoader());
        this.totalSpendingAtSimilarBrands = (MenigaDecimal)in.readSerializable();
        this.totalSpendingOnOffer = (MenigaDecimal)in.readSerializable();
        this.offerSimilarBrandsSpendingRatio = (MenigaDecimal)in.readSerializable();
        this.merchantLocations = in.createTypedArrayList(MenigaOfferMerchantLocation.CREATOR);
        this.webUri = in.readString();
        this.webUriLabel = in.readString();
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaOffer>(){

            public MenigaOffer createFromParcel(Parcel source) {
                return new MenigaOffer(source);
            }

            public MenigaOffer[] newArray(int size) {
                return new MenigaOffer[size];
            }
        };
    }
}

