/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.networth;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.networth.MenigaNetWorth;
import com.meniga.sdk.models.networth.operators.MenigaNetWorthBalanceOperations;
import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MenigaNetWorthBalance
implements Parcelable,
Serializable,
Cloneable,
Comparable<MenigaNetWorthBalance> {
    public static final Parcelable.Creator<MenigaNetWorthBalance> CREATOR = new Parcelable.Creator<MenigaNetWorthBalance>(){

        public MenigaNetWorthBalance createFromParcel(Parcel in) {
            return new MenigaNetWorthBalance(in);
        }

        public MenigaNetWorthBalance[] newArray(int size) {
            return new MenigaNetWorthBalance[size];
        }
    };
    protected static MenigaNetWorthBalanceOperations apiOperator;
    protected long id;
    protected Long accountId;
    protected MenigaDecimal balance;
    protected DateTime balanceDate;
    protected Boolean isDefault;

    protected MenigaNetWorthBalance() {
    }

    public MenigaNetWorthBalance(Parcel in) {
        Byte isDefaultRaw;
        long ms;
        boolean balanceIsNull;
        this.id = in.readLong();
        long tmpAccId = in.readLong();
        if (tmpAccId > -1L) {
            this.accountId = tmpAccId;
        }
        boolean bl = balanceIsNull = in.readByte() == 1;
        if (!balanceIsNull) {
            this.balance = new MenigaDecimal(in.readDouble());
        }
        if ((ms = in.readLong()) > -1L) {
            this.balanceDate = new DateTime(ms);
        }
        this.isDefault = (isDefaultRaw = Byte.valueOf(in.readByte())) == -1 ? null : Boolean.valueOf(isDefaultRaw != 0);
    }

    public static void setOperator(MenigaNetWorthBalanceOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public MenigaDecimal getBalance() {
        if (this.balance == null) {
            return new MenigaDecimal(0);
        }
        return this.balance;
    }

    public void setBalance(MenigaDecimal balance) {
        this.balance = balance;
    }

    public Long getNetWorthId() {
        return this.accountId;
    }

    public DateTime getBalanceDate() {
        return this.balanceDate;
    }

    public void setBalanceDate(DateTime date) {
        this.balanceDate = date;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.accountId == null ? -1L : this.accountId);
        dest.writeByte(this.balance == null ? (byte)1 : 0);
        if (this.balance != null) {
            dest.writeDouble(this.balance.doubleValue());
        }
        dest.writeLong(this.balanceDate == null ? -1L : this.balanceDate.getMillis());
        dest.writeByte(this.isDefault == null ? (byte)-1 : (this.isDefault != false ? (byte)1 : 0));
    }

    public MenigaNetWorthBalance clone() throws CloneNotSupportedException {
        return (MenigaNetWorthBalance)super.clone();
    }

    public String toString() {
        if (this.balance == null) {
            return "null";
        }
        return Double.toString(this.balance.doubleValue()) + ", " + this.balanceDate == null ? "" : this.balanceDate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaNetWorthBalance that = (MenigaNetWorthBalance)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.balance != null ? !this.balance.equals(that.balance) : that.balance != null) {
            return false;
        }
        if (this.balanceDate != null ? !this.balanceDate.equals((Object)that.balanceDate) : that.balanceDate != null) {
            return false;
        }
        return this.isDefault != null ? this.isDefault.equals(that.isDefault) : that.isDefault == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.balanceDate != null ? this.balanceDate.hashCode() : 0);
        result = 31 * result + (this.isDefault != null ? this.isDefault.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(MenigaNetWorthBalance another) {
        if (another == null || another.balanceDate == null) {
            return 0;
        }
        return this.balanceDate.compareTo((ReadableInstant)another.balanceDate);
    }

    public Result<Void> update() {
        return apiOperator.updateBalance(this.accountId, this.id, this.balance, this.balanceDate);
    }

    public Result<Void> delete() {
        return apiOperator.deleteBalance(this.accountId, this.id);
    }

    public Result<List<MenigaNetWorth>> refresh() {
        Result<List<MenigaNetWorth>> task2 = MenigaNetWorth.fetch(DateTime.now().minusYears(100), DateTime.now(), 0, -1);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaNetWorth>>(){

            @Override
            public void onFinished(List<MenigaNetWorth> result, boolean failed) {
                if (!failed) {
                    for (MenigaNetWorth netWorth : result) {
                        if (netWorth.getId() != MenigaNetWorthBalance.this.getAccountId()) continue;
                        for (MenigaNetWorthBalance bala : netWorth.getHistory()) {
                            if (bala.getId() != MenigaNetWorthBalance.this.getId()) continue;
                            try {
                                Merge.merge(MenigaNetWorthBalance.this, bala);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                    }
                }
            }
        });
    }

    public static Result<MenigaNetWorthBalance> create(final long netWorthId, MenigaDecimal balance, DateTime balanceDate) {
        Result<MenigaNetWorthBalance> task2 = apiOperator.createNetWorthBalanceHistory(netWorthId, balance, balanceDate);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaNetWorthBalance>(){

            @Override
            public void onFinished(MenigaNetWorthBalance result, boolean failed) {
                if (!failed) {
                    result.accountId = netWorthId;
                    result.isDefault = false;
                }
            }
        });
    }
}

