/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.merchants;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import javax.annotation.Nullable;

public class MenigaMerchantLocation
implements Serializable,
Parcelable {
    protected String city;
    protected String country;
    protected String countryCode;
    protected String latitude;
    protected String longitude;
    protected String postalCode;
    protected String streetLine1;
    protected String streetLine2;
    public static final Parcelable.Creator<MenigaMerchantLocation> CREATOR = new Parcelable.Creator<MenigaMerchantLocation>(){

        public MenigaMerchantLocation createFromParcel(Parcel source) {
            return new MenigaMerchantLocation(source);
        }

        public MenigaMerchantLocation[] newArray(int size) {
            return new MenigaMerchantLocation[size];
        }
    };

    protected MenigaMerchantLocation() {
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    @Nullable
    public Double getLatitude() {
        return this.getCoordinate(this.latitude);
    }

    @Nullable
    public Double getLongitude() {
        return this.getCoordinate(this.longitude);
    }

    @Nullable
    private Double getCoordinate(String coordinate) {
        if (coordinate == null) {
            return null;
        }
        try {
            return Double.parseDouble(coordinate);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getStreetLine1() {
        return this.streetLine1;
    }

    public String getStreetLine2() {
        return this.streetLine2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaMerchantLocation that = (MenigaMerchantLocation)o;
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.countryCode != null ? !this.countryCode.equals(that.countryCode) : that.countryCode != null) {
            return false;
        }
        if (this.latitude != null ? !this.latitude.equals(that.latitude) : that.latitude != null) {
            return false;
        }
        if (this.longitude != null ? !this.longitude.equals(that.longitude) : that.longitude != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.streetLine1 != null ? !this.streetLine1.equals(that.streetLine1) : that.streetLine1 != null) {
            return false;
        }
        return this.streetLine2 != null ? this.streetLine2.equals(that.streetLine2) : that.streetLine2 == null;
    }

    public int hashCode() {
        int result = this.city != null ? this.city.hashCode() : 0;
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
        result = 31 * result + (this.latitude != null ? this.latitude.hashCode() : 0);
        result = 31 * result + (this.longitude != null ? this.longitude.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.streetLine1 != null ? this.streetLine1.hashCode() : 0);
        result = 31 * result + (this.streetLine2 != null ? this.streetLine2.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.city);
        dest.writeString(this.country);
        dest.writeString(this.countryCode);
        dest.writeString(this.latitude);
        dest.writeString(this.longitude);
        dest.writeString(this.postalCode);
        dest.writeString(this.streetLine1);
        dest.writeString(this.streetLine2);
    }

    private MenigaMerchantLocation(Parcel in) {
        this.city = in.readString();
        this.country = in.readString();
        this.countryCode = in.readString();
        this.latitude = in.readString();
        this.longitude = in.readString();
        this.postalCode = in.readString();
        this.streetLine1 = in.readString();
        this.streetLine2 = in.readString();
    }
}

