/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.merchants;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.categories.MenigaCategoryScore;
import com.meniga.sdk.models.merchants.MenigaMerchantLocation;
import com.meniga.sdk.models.merchants.MerchantAttribute;
import com.meniga.sdk.models.merchants.operators.MenigaMerchantOperations;
import java.io.Serializable;
import java.util.List;

public class MenigaMerchant
implements Serializable,
Parcelable,
Cloneable {
    protected static MenigaMerchantOperations apiOperations;
    protected long id;
    protected long parentId;
    protected MenigaMerchant parentMerchant;
    protected String identifier;
    protected String masterIdentifier;
    protected String merchantCategoryIdentifier;
    protected String publicIdentifier;
    protected String name;
    protected String parentName;
    protected MenigaMerchantLocation address;
    protected List<MenigaCategoryScore> categoryScores;
    protected List<MenigaMerchant> childMerchants;
    protected List<MenigaCategoryScore> detectedCategory;
    protected String directoryLink;
    protected String email;
    protected String offersLink;
    protected String telephone;
    protected String webpage;
    protected MerchantAttribute customAttributes;
    public static final Parcelable.Creator<MenigaMerchant> CREATOR;

    protected MenigaMerchant() {
    }

    protected MenigaMerchant clone() throws CloneNotSupportedException {
        return (MenigaMerchant)super.clone();
    }

    public static void setOperator(MenigaMerchantOperations operator) {
        apiOperations = operator;
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public MenigaMerchant getParentMerchant() {
        return this.parentMerchant;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public String getMerchantCategoryIdentifier() {
        return this.merchantCategoryIdentifier;
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public MenigaMerchantLocation getAddress() {
        return this.address;
    }

    public List<MenigaCategoryScore> getCategoryScores() {
        return this.categoryScores;
    }

    public List<MenigaMerchant> getChildMerchants() {
        return this.childMerchants;
    }

    public List<MenigaCategoryScore> getDetectedCategory() {
        return this.detectedCategory;
    }

    public String getDirectoryLink() {
        return this.directoryLink;
    }

    public String getEmail() {
        return this.email;
    }

    public String getOffersLink() {
        return this.offersLink;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getWebpage() {
        return this.webpage;
    }

    public MerchantAttribute getCustomAttributes() {
        return this.customAttributes;
    }

    public static Result<MenigaMerchant> fetch(long id) {
        return apiOperations.getMerchant(id);
    }

    public static Result<List<MenigaMerchant>> fetch(List<Long> ids) {
        return apiOperations.getMerchants(ids);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.parentId);
        dest.writeParcelable((Parcelable)this.parentMerchant, flags);
        dest.writeString(this.identifier);
        dest.writeString(this.masterIdentifier);
        dest.writeString(this.merchantCategoryIdentifier);
        dest.writeString(this.publicIdentifier);
        dest.writeString(this.name);
        dest.writeString(this.parentName);
        dest.writeParcelable((Parcelable)this.address, flags);
        dest.writeTypedList(this.categoryScores);
        dest.writeTypedList(this.childMerchants);
        dest.writeTypedList(this.detectedCategory);
        dest.writeString(this.directoryLink);
        dest.writeString(this.email);
        dest.writeString(this.offersLink);
        dest.writeString(this.telephone);
        dest.writeString(this.webpage);
    }

    protected MenigaMerchant(Parcel in) {
        this.id = in.readLong();
        this.parentId = in.readLong();
        this.parentMerchant = (MenigaMerchant)in.readParcelable(MenigaMerchant.class.getClassLoader());
        this.identifier = in.readString();
        this.masterIdentifier = in.readString();
        this.merchantCategoryIdentifier = in.readString();
        this.publicIdentifier = in.readString();
        this.name = in.readString();
        this.parentName = in.readString();
        this.address = (MenigaMerchantLocation)in.readParcelable(MenigaMerchantLocation.class.getClassLoader());
        this.categoryScores = in.createTypedArrayList(MenigaCategoryScore.CREATOR);
        this.childMerchants = in.createTypedArrayList(CREATOR);
        this.detectedCategory = in.createTypedArrayList(MenigaCategoryScore.CREATOR);
        this.directoryLink = in.readString();
        this.email = in.readString();
        this.offersLink = in.readString();
        this.telephone = in.readString();
        this.webpage = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaMerchant that = (MenigaMerchant)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.parentId != that.parentId) {
            return false;
        }
        if (this.parentMerchant != null ? !this.parentMerchant.equals(that.parentMerchant) : that.parentMerchant != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.masterIdentifier != null ? !this.masterIdentifier.equals(that.masterIdentifier) : that.masterIdentifier != null) {
            return false;
        }
        if (this.merchantCategoryIdentifier != null ? !this.merchantCategoryIdentifier.equals(that.merchantCategoryIdentifier) : that.merchantCategoryIdentifier != null) {
            return false;
        }
        if (this.publicIdentifier != null ? !this.publicIdentifier.equals(that.publicIdentifier) : that.publicIdentifier != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parentName != null ? !this.parentName.equals(that.parentName) : that.parentName != null) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.categoryScores != null ? !this.categoryScores.equals(that.categoryScores) : that.categoryScores != null) {
            return false;
        }
        if (this.childMerchants != null ? !this.childMerchants.equals(that.childMerchants) : that.childMerchants != null) {
            return false;
        }
        if (this.detectedCategory != null ? !this.detectedCategory.equals(that.detectedCategory) : that.detectedCategory != null) {
            return false;
        }
        if (this.directoryLink != null ? !this.directoryLink.equals(that.directoryLink) : that.directoryLink != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.offersLink != null ? !this.offersLink.equals(that.offersLink) : that.offersLink != null) {
            return false;
        }
        if (this.telephone != null ? !this.telephone.equals(that.telephone) : that.telephone != null) {
            return false;
        }
        return this.webpage != null ? this.webpage.equals(that.webpage) : that.webpage == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        result = 31 * result + (this.parentMerchant != null ? this.parentMerchant.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.masterIdentifier != null ? this.masterIdentifier.hashCode() : 0);
        result = 31 * result + (this.merchantCategoryIdentifier != null ? this.merchantCategoryIdentifier.hashCode() : 0);
        result = 31 * result + (this.publicIdentifier != null ? this.publicIdentifier.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.parentName != null ? this.parentName.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.categoryScores != null ? this.categoryScores.hashCode() : 0);
        result = 31 * result + (this.childMerchants != null ? this.childMerchants.hashCode() : 0);
        result = 31 * result + (this.detectedCategory != null ? this.detectedCategory.hashCode() : 0);
        result = 31 * result + (this.directoryLink != null ? this.directoryLink.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.offersLink != null ? this.offersLink.hashCode() : 0);
        result = 31 * result + (this.telephone != null ? this.telephone.hashCode() : 0);
        result = 31 * result + (this.webpage != null ? this.webpage.hashCode() : 0);
        return result;
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaMerchant>(){

            public MenigaMerchant createFromParcel(Parcel source) {
                return new MenigaMerchant(source);
            }

            public MenigaMerchant[] newArray(int size) {
                return new MenigaMerchant[size];
            }
        };
    }
}

