/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.feed;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.challenges.enums.CustomChallengeColor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;

public class MenigaChallengeEventData
implements Parcelable,
Serializable {
    protected UUID challengeId;
    protected String title;
    protected boolean challengeSuccessful;
    protected MenigaDecimal targetAmount;
    protected String targetAmountFormatted;
    protected MenigaDecimal spentAmount;
    protected String spentAmountFormatted;
    protected MenigaDecimal amountDifference;
    protected String amountDifferenceFormatted;
    protected DateTime startDate;
    protected DateTime endDate;
    protected DateTime periodStart;
    protected DateTime periodEnd;
    protected String iconUrl;
    protected CustomChallengeColor metadata;
    protected List<Long> categoryIds;
    protected Float percentageSpent;
    protected Integer daysRemaining;
    public static final Parcelable.Creator<MenigaChallengeEventData> CREATOR = new Parcelable.Creator<MenigaChallengeEventData>(){

        public MenigaChallengeEventData createFromParcel(Parcel source) {
            return new MenigaChallengeEventData(source);
        }

        public MenigaChallengeEventData[] newArray(int size) {
            return new MenigaChallengeEventData[size];
        }
    };

    protected MenigaChallengeEventData() {
    }

    public UUID getChallengeId() {
        return this.challengeId;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isChallengeSuccessful() {
        return this.challengeSuccessful;
    }

    public MenigaDecimal getTargetAmount() {
        return this.targetAmount;
    }

    public String getTargetAmountFormatted() {
        return this.targetAmountFormatted;
    }

    public MenigaDecimal getSpentAmount() {
        return this.spentAmount;
    }

    public String getSpentAmountFormatted() {
        return this.spentAmountFormatted;
    }

    public MenigaDecimal getAmountDifference() {
        return this.amountDifference;
    }

    public String getAmountDifferenceFormatted() {
        return this.amountDifferenceFormatted;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public DateTime getPeriodStart() {
        return this.periodStart;
    }

    public DateTime getPeriodEnd() {
        return this.periodEnd;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public CustomChallengeColor getMetadata() {
        return this.metadata;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public Float getPercentageSpent() {
        return this.percentageSpent;
    }

    public Integer getDaysRemaining() {
        return this.daysRemaining;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.challengeId);
        dest.writeString(this.title);
        dest.writeByte(this.challengeSuccessful ? (byte)1 : 0);
        dest.writeSerializable((Serializable)this.targetAmount);
        dest.writeString(this.targetAmountFormatted);
        dest.writeSerializable((Serializable)this.spentAmount);
        dest.writeString(this.spentAmountFormatted);
        dest.writeSerializable((Serializable)this.amountDifference);
        dest.writeString(this.amountDifferenceFormatted);
        dest.writeSerializable((Serializable)this.startDate);
        dest.writeSerializable((Serializable)this.endDate);
        dest.writeSerializable((Serializable)this.periodStart);
        dest.writeSerializable((Serializable)this.periodEnd);
        dest.writeString(this.iconUrl);
        dest.writeInt(this.metadata == null ? -1 : this.metadata.ordinal());
        dest.writeList(this.categoryIds);
        dest.writeValue((Object)this.percentageSpent);
        dest.writeValue((Object)this.daysRemaining);
    }

    protected MenigaChallengeEventData(Parcel in) {
        this.challengeId = (UUID)in.readSerializable();
        this.title = in.readString();
        this.challengeSuccessful = in.readByte() != 0;
        this.targetAmount = (MenigaDecimal)in.readSerializable();
        this.targetAmountFormatted = in.readString();
        this.spentAmount = (MenigaDecimal)in.readSerializable();
        this.spentAmountFormatted = in.readString();
        this.amountDifference = (MenigaDecimal)in.readSerializable();
        this.amountDifferenceFormatted = in.readString();
        this.startDate = (DateTime)in.readSerializable();
        this.endDate = (DateTime)in.readSerializable();
        this.periodStart = (DateTime)in.readSerializable();
        this.periodEnd = (DateTime)in.readSerializable();
        this.iconUrl = in.readString();
        int tmpMetadata = in.readInt();
        this.metadata = tmpMetadata == -1 ? null : CustomChallengeColor.values()[tmpMetadata];
        this.categoryIds = new ArrayList<Long>();
        in.readList(this.categoryIds, Long.class.getClassLoader());
        this.percentageSpent = (Float)in.readValue(Float.class.getClassLoader());
        this.daysRemaining = (Integer)in.readValue(Integer.class.getClassLoader());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaChallengeEventData that = (MenigaChallengeEventData)o;
        if (this.challengeSuccessful != that.challengeSuccessful) {
            return false;
        }
        if (this.challengeId != null ? !this.challengeId.equals(that.challengeId) : that.challengeId != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.targetAmount != null ? !this.targetAmount.equals(that.targetAmount) : that.targetAmount != null) {
            return false;
        }
        if (this.targetAmountFormatted != null ? !this.targetAmountFormatted.equals(that.targetAmountFormatted) : that.targetAmountFormatted != null) {
            return false;
        }
        if (this.spentAmount != null ? !this.spentAmount.equals(that.spentAmount) : that.spentAmount != null) {
            return false;
        }
        if (this.spentAmountFormatted != null ? !this.spentAmountFormatted.equals(that.spentAmountFormatted) : that.spentAmountFormatted != null) {
            return false;
        }
        if (this.amountDifference != null ? !this.amountDifference.equals(that.amountDifference) : that.amountDifference != null) {
            return false;
        }
        if (this.amountDifferenceFormatted != null ? !this.amountDifferenceFormatted.equals(that.amountDifferenceFormatted) : that.amountDifferenceFormatted != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals((Object)that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals((Object)that.endDate) : that.endDate != null) {
            return false;
        }
        if (this.periodStart != null ? !this.periodStart.equals((Object)that.periodStart) : that.periodStart != null) {
            return false;
        }
        if (this.periodEnd != null ? !this.periodEnd.equals((Object)that.periodEnd) : that.periodEnd != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
            return false;
        }
        if (this.metadata != that.metadata) {
            return false;
        }
        if (this.categoryIds != null ? !this.categoryIds.equals(that.categoryIds) : that.categoryIds != null) {
            return false;
        }
        if (this.percentageSpent != null ? !this.percentageSpent.equals(that.percentageSpent) : that.percentageSpent != null) {
            return false;
        }
        return this.daysRemaining != null ? this.daysRemaining.equals(that.daysRemaining) : that.daysRemaining == null;
    }

    public int hashCode() {
        int result = this.challengeId != null ? this.challengeId.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.challengeSuccessful ? 1 : 0);
        result = 31 * result + (this.targetAmount != null ? this.targetAmount.hashCode() : 0);
        result = 31 * result + (this.targetAmountFormatted != null ? this.targetAmountFormatted.hashCode() : 0);
        result = 31 * result + (this.spentAmount != null ? this.spentAmount.hashCode() : 0);
        result = 31 * result + (this.spentAmountFormatted != null ? this.spentAmountFormatted.hashCode() : 0);
        result = 31 * result + (this.amountDifference != null ? this.amountDifference.hashCode() : 0);
        result = 31 * result + (this.amountDifferenceFormatted != null ? this.amountDifferenceFormatted.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.periodStart != null ? this.periodStart.hashCode() : 0);
        result = 31 * result + (this.periodEnd != null ? this.periodEnd.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.categoryIds != null ? this.categoryIds.hashCode() : 0);
        result = 31 * result + (this.percentageSpent != null ? this.percentageSpent.hashCode() : 0);
        result = 31 * result + (this.daysRemaining != null ? this.daysRemaining.hashCode() : 0);
        return result;
    }
}

