/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.challenges;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.challenges.CategoryDefinition;
import com.meniga.sdk.models.challenges.FetchChallengeFilter;
import com.meniga.sdk.models.challenges.NewChallenge;
import com.meniga.sdk.models.challenges.enums.ChallengeInterval;
import com.meniga.sdk.models.challenges.enums.ChallengeType;
import com.meniga.sdk.models.challenges.enums.CustomChallengeColor;
import com.meniga.sdk.models.challenges.operators.MenigaChallengesOperations;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class MenigaChallenge
implements Serializable,
Cloneable,
Parcelable {
    private static MenigaChallengesOperations apiOperations;
    protected UUID id;
    protected boolean accepted;
    protected DateTime acceptedDate;
    protected Long topicId;
    protected String title;
    protected String description;
    protected ChallengeType type;
    protected DateTime publishDate;
    protected DateTime startDate;
    protected DateTime endDate;
    protected DateTime parentEndDate;
    protected DateTime parentStartDate;
    protected List<Long> categoryIds;
    protected Integer targetPercentage;
    protected MenigaDecimal targetAmount;
    protected MenigaDecimal spentAmount;
    protected String iconUrl;
    protected ChallengeInterval recurringInterval;
    @SerializedName(value="color")
    protected CustomChallengeColor customChallengeColor;
    protected boolean categoryIdsDirty;
    protected Long parentTopicId;
    public static final Parcelable.Creator<MenigaChallenge> CREATOR;

    protected MenigaChallenge() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.id);
        dest.writeByte(this.accepted ? (byte)1 : 0);
        dest.writeSerializable((Serializable)this.acceptedDate);
        dest.writeValue((Object)this.topicId);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeSerializable((Serializable)this.publishDate);
        dest.writeSerializable((Serializable)this.startDate);
        dest.writeSerializable((Serializable)this.endDate);
        dest.writeSerializable((Serializable)this.parentEndDate);
        dest.writeSerializable((Serializable)this.parentStartDate);
        dest.writeList(this.categoryIds);
        dest.writeValue((Object)this.targetPercentage);
        dest.writeSerializable((Serializable)this.targetAmount);
        dest.writeSerializable((Serializable)this.spentAmount);
        dest.writeString(this.iconUrl);
        dest.writeInt(this.recurringInterval == null ? -1 : this.recurringInterval.ordinal());
        dest.writeInt(this.customChallengeColor == null ? -1 : this.customChallengeColor.ordinal());
        dest.writeByte(this.categoryIdsDirty ? (byte)1 : 0);
        dest.writeValue((Object)this.parentTopicId);
    }

    protected MenigaChallenge(Parcel in) {
        this.id = (UUID)in.readSerializable();
        this.accepted = in.readByte() != 0;
        this.acceptedDate = (DateTime)in.readSerializable();
        this.topicId = (Long)in.readValue(Long.class.getClassLoader());
        this.title = in.readString();
        this.description = in.readString();
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : ChallengeType.values()[tmpType];
        this.publishDate = (DateTime)in.readSerializable();
        this.startDate = (DateTime)in.readSerializable();
        this.endDate = (DateTime)in.readSerializable();
        this.parentEndDate = (DateTime)in.readSerializable();
        this.parentStartDate = (DateTime)in.readSerializable();
        this.categoryIds = new ArrayList<Long>();
        in.readList(this.categoryIds, Long.class.getClassLoader());
        this.targetPercentage = (Integer)in.readValue(Integer.class.getClassLoader());
        this.targetAmount = (MenigaDecimal)in.readSerializable();
        this.spentAmount = (MenigaDecimal)in.readSerializable();
        this.iconUrl = in.readString();
        int tmpRecurringInterval = in.readInt();
        this.recurringInterval = tmpRecurringInterval == -1 ? null : ChallengeInterval.values()[tmpRecurringInterval];
        int tmpCustomChallengeColor = in.readInt();
        this.customChallengeColor = tmpCustomChallengeColor == -1 ? null : CustomChallengeColor.values()[tmpCustomChallengeColor];
        this.categoryIdsDirty = in.readByte() != 0;
        this.parentTopicId = (Long)in.readValue(Long.class.getClassLoader());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaChallenge challenge = (MenigaChallenge)o;
        if (this.accepted != challenge.accepted) {
            return false;
        }
        if (this.categoryIdsDirty != challenge.categoryIdsDirty) {
            return false;
        }
        if (this.id != null ? !this.id.equals(challenge.id) : challenge.id != null) {
            return false;
        }
        if (this.acceptedDate != null ? !this.acceptedDate.equals((Object)challenge.acceptedDate) : challenge.acceptedDate != null) {
            return false;
        }
        if (this.topicId != null ? !this.topicId.equals(challenge.topicId) : challenge.topicId != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(challenge.title) : challenge.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(challenge.description) : challenge.description != null) {
            return false;
        }
        if (this.type != challenge.type) {
            return false;
        }
        if (this.publishDate != null ? !this.publishDate.equals((Object)challenge.publishDate) : challenge.publishDate != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals((Object)challenge.startDate) : challenge.startDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals((Object)challenge.endDate) : challenge.endDate != null) {
            return false;
        }
        if (this.parentEndDate != null ? !this.parentEndDate.equals((Object)challenge.parentEndDate) : challenge.parentEndDate != null) {
            return false;
        }
        if (this.parentStartDate != null ? !this.parentStartDate.equals((Object)challenge.parentStartDate) : challenge.parentStartDate != null) {
            return false;
        }
        if (this.categoryIds != null ? !this.categoryIds.equals(challenge.categoryIds) : challenge.categoryIds != null) {
            return false;
        }
        if (this.targetPercentage != null ? !this.targetPercentage.equals(challenge.targetPercentage) : challenge.targetPercentage != null) {
            return false;
        }
        if (this.targetAmount != null ? !this.targetAmount.equals(challenge.targetAmount) : challenge.targetAmount != null) {
            return false;
        }
        if (this.spentAmount != null ? !this.spentAmount.equals(challenge.spentAmount) : challenge.spentAmount != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(challenge.iconUrl) : challenge.iconUrl != null) {
            return false;
        }
        if (this.recurringInterval != challenge.recurringInterval) {
            return false;
        }
        if (this.customChallengeColor != challenge.customChallengeColor) {
            return false;
        }
        return this.parentTopicId != null ? this.parentTopicId.equals(challenge.parentTopicId) : challenge.parentTopicId == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.accepted ? 1 : 0);
        result = 31 * result + (this.acceptedDate != null ? this.acceptedDate.hashCode() : 0);
        result = 31 * result + (this.topicId != null ? this.topicId.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.publishDate != null ? this.publishDate.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.parentEndDate != null ? this.parentEndDate.hashCode() : 0);
        result = 31 * result + (this.parentStartDate != null ? this.parentStartDate.hashCode() : 0);
        result = 31 * result + (this.categoryIds != null ? this.categoryIds.hashCode() : 0);
        result = 31 * result + (this.targetPercentage != null ? this.targetPercentage.hashCode() : 0);
        result = 31 * result + (this.targetAmount != null ? this.targetAmount.hashCode() : 0);
        result = 31 * result + (this.spentAmount != null ? this.spentAmount.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.recurringInterval != null ? this.recurringInterval.hashCode() : 0);
        result = 31 * result + (this.customChallengeColor != null ? this.customChallengeColor.hashCode() : 0);
        result = 31 * result + (this.categoryIdsDirty ? 1 : 0);
        result = 31 * result + (this.parentTopicId != null ? this.parentTopicId.hashCode() : 0);
        return result;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public DateTime getAcceptedDate() {
        return this.acceptedDate;
    }

    public Long getTopicId() {
        return this.topicId;
    }

    public Long getParentTopicId() {
        return this.parentTopicId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public ChallengeType getType() {
        return this.type;
    }

    public DateTime getPublishDate() {
        return this.publishDate;
    }

    public DateTime getMostValidStartDate() {
        if ((this.startDate == null || this.startDate.getYear() < 1900) && this.parentStartDate != null && this.parentStartDate.getYear() > 1900) {
            return this.parentStartDate;
        }
        return this.startDate;
    }

    public DateTime getMostValidEndDate() {
        if ((this.endDate == null || this.endDate.getYear() < 1900) && this.parentEndDate != null && this.parentEndDate.getYear() > 1900) {
            return this.parentEndDate;
        }
        return this.endDate;
    }

    public DateTime getParentEndDate() {
        return this.parentEndDate;
    }

    public DateTime getParentStartDate() {
        return this.parentStartDate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public List<Long> getCategoryIds() {
        if (this.categoryIds == null) {
            return new ArrayList<Long>();
        }
        return this.categoryIds;
    }

    public Integer getTargetPercentage() {
        return this.targetPercentage;
    }

    public MenigaDecimal getTargetAmount() {
        if (this.targetAmount == null) {
            return new MenigaDecimal(0);
        }
        return this.targetAmount;
    }

    public MenigaDecimal getSpentAmount() {
        if (this.spentAmount == null) {
            return new MenigaDecimal(0);
        }
        return this.spentAmount;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public ChallengeInterval getRecurringInterval() {
        return this.recurringInterval;
    }

    public CustomChallengeColor getCustomChallengeColor() {
        return this.customChallengeColor;
    }

    public void setTitle(String titleIn) {
        this.title = titleIn;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setStartDate(DateTime starts) {
        this.startDate = starts;
    }

    public void setEndDate(DateTime ends) {
        this.endDate = ends;
    }

    public void setIconUrl(String url) {
        this.iconUrl = url;
    }

    public void setCustomChallengeColor(CustomChallengeColor color) {
        this.customChallengeColor = color;
    }

    public void setCategoryIds(List<Long> ids) {
        this.categoryIds = ids;
        this.categoryIdsDirty = true;
    }

    public static void setOperator(MenigaChallengesOperations operator) {
        apiOperations = operator;
    }

    public void setType(ChallengeType type2) {
        this.type = type2;
    }

    public void setTargetAmount(MenigaDecimal amt) {
        this.targetAmount = amt.abs();
    }

    public MenigaChallenge clone() throws CloneNotSupportedException {
        return (MenigaChallenge)super.clone();
    }

    public String toString() {
        return this.title;
    }

    public void merge(MenigaChallenge other) {
        if (other == null) {
            return;
        }
        Class<?> myClass = this.getClass();
        if (this.categoryIds != null && this.categoryIds.size() == 0) {
            this.categoryIds = null;
        }
        if (other.categoryIds != null && other.categoryIds.size() == 0) {
            other.categoryIds = null;
        }
        for (Field field : myClass.getDeclaredFields()) {
            try {
                Object myValue = field.get(this);
                Object otherValue = field.get(other);
                if (myValue != null || otherValue == null) continue;
                field.setAccessible(true);
                field.set(this, otherValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Result<List<MenigaChallenge>> fetch() {
        FetchChallengeFilter filter = new FetchChallengeFilter(true, false, false, true);
        return MenigaChallenge.fetch(filter);
    }

    public static Result<MenigaChallenge> fetch(UUID id) {
        return apiOperations.getChallenge(id);
    }

    public Result<MenigaChallenge> refresh() {
        Result<MenigaChallenge> task2 = MenigaChallenge.fetch(this.id);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaChallenge>(){

            @Override
            public void onFinished(MenigaChallenge result, boolean failed) {
                if (!failed && result != null) {
                    try {
                        Merge.merge(MenigaChallenge.this, result);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Deprecated
    public static Result<List<MenigaChallenge>> fetch(boolean includeExpired, boolean excludeSuggested, boolean excludeAccepted) {
        FetchChallengeFilter filter = new FetchChallengeFilter(includeExpired, excludeSuggested, excludeAccepted, false);
        return MenigaChallenge.fetch(filter);
    }

    public static Result<List<MenigaChallenge>> fetch(FetchChallengeFilter filter) {
        return apiOperations.getChallenges(filter);
    }

    public Result<Void> update() {
        Result<Void> task2 = apiOperations.updateChallenge(this, this.categoryIdsDirty);
        this.categoryIdsDirty = false;
        return task2;
    }

    public static Result<Void> delete(UUID id) {
        return apiOperations.deleteChallenge(id);
    }

    public Result<Void> delete() {
        return apiOperations.deleteChallenge(this.getId());
    }

    public Result<MenigaChallenge> accept(MenigaDecimal targetAmount) {
        if (targetAmount.lessThan(0.0)) {
            targetAmount = targetAmount.abs();
        }
        Result<MenigaChallenge> task2 = apiOperations.acceptChallenge(this.id, targetAmount);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaChallenge>(){

            @Override
            public void onFinished(MenigaChallenge result, boolean failed) {
                if (!failed && result != null) {
                    MenigaChallenge.this.merge(result);
                    MenigaChallenge.this.accepted = true;
                }
            }
        });
    }

    public Result<Void> disable() {
        return apiOperations.disableChallenge(this.id);
    }

    public Result<Void> enable() {
        return apiOperations.enableChallenge(this.id);
    }

    @Deprecated
    public static Result<MenigaChallenge> create(String title, String description, DateTime startDate, DateTime endDate, List<Long> categoryIds, MenigaDecimal targetAmount, CustomChallengeColor color) {
        return MenigaChallenge.create(title, description, startDate, endDate, categoryIds, targetAmount, null, color);
    }

    @Deprecated
    public static Result<MenigaChallenge> create(String title, String description, DateTime startDate, DateTime endDate, List<Long> categoryIds, MenigaDecimal targetAmount, CustomChallengeColor color, ChallengeInterval interval) {
        return MenigaChallenge.create(title, description, startDate, endDate, categoryIds, targetAmount, null, color, interval);
    }

    @Deprecated
    public static Result<MenigaChallenge> create(String title, String description, DateTime startDate, DateTime endDate, List<Long> categoryIds, MenigaDecimal targetAmount, Long iconId, CustomChallengeColor color) {
        return MenigaChallenge.create(title, description, startDate, endDate, categoryIds, targetAmount, iconId, color, null);
    }

    @Deprecated
    public static Result<MenigaChallenge> create(String title, String description, DateTime startDate, DateTime endDate, List<Long> categoryIds, MenigaDecimal targetAmount, Long iconId, CustomChallengeColor color, ChallengeInterval interval) {
        NewChallenge challenge = new NewChallenge(title, description, startDate, endDate, null, new CategoryDefinition.CategoryList(categoryIds), color, targetAmount, interval);
        return apiOperations.createChallenge(challenge);
    }

    public static Result<MenigaChallenge> create(@Nonnull NewChallenge challenge) {
        return apiOperations.createChallenge(challenge);
    }

    public Result<List<MenigaChallenge>> history(int page, int numPerPage) {
        return apiOperations.getChallengeHistory(this.id, page, numPerPage);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaChallenge>(){

            public MenigaChallenge createFromParcel(Parcel source) {
                return new MenigaChallenge(source);
            }

            public MenigaChallenge[] newArray(int size) {
                return new MenigaChallenge[size];
            }
        };
    }
}

