/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Objects;
import com.meniga.sdk.models.budget.enums.GenerationType;
import java.io.Serializable;

public final class TargetAmountGeneration
implements Parcelable,
Serializable {
    private final int value;
    public static final Parcelable.Creator<TargetAmountGeneration> CREATOR = new Parcelable.Creator<TargetAmountGeneration>(){

        public TargetAmountGeneration createFromParcel(Parcel source) {
            return new TargetAmountGeneration(source);
        }

        public TargetAmountGeneration[] newArray(int size) {
            return new TargetAmountGeneration[size];
        }
    };

    public static TargetAmountGeneration create(GenerationType type2, int value) {
        Objects.checkArgument(value >= 0, "The value must be >= 0");
        switch (type2) {
            case MANUAL: {
                return new TargetAmountGeneration(0);
            }
            case SAME_AS_MONTH: {
                return new TargetAmountGeneration(-value);
            }
            case AVERAGE_MONTHS: {
                return new TargetAmountGeneration(value);
            }
        }
        throw new IllegalArgumentException("Unhandled generation type " + (Object)((Object)type2) + " provided");
    }

    public static TargetAmountGeneration create(int value) {
        return new TargetAmountGeneration(value);
    }

    public static TargetAmountGeneration manual() {
        return TargetAmountGeneration.create(GenerationType.MANUAL, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetAmountGeneration that = (TargetAmountGeneration)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    private TargetAmountGeneration(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int getMonths() {
        return Math.abs(this.value);
    }

    public GenerationType getType() {
        if (this.value == 0) {
            return GenerationType.MANUAL;
        }
        if (this.value < 0) {
            return GenerationType.SAME_AS_MONTH;
        }
        return GenerationType.AVERAGE_MONTHS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.value);
    }

    TargetAmountGeneration(Parcel in) {
        this.value = in.readInt();
    }
}

